/**
 * 
 */
package code.simulator.protocolFilters;

import java.util.Collection;
import java.util.TreeSet;
import java.util.LinkedList;

import code.AcceptVV; 
import code.ObjId;
import code.branchDetecting.BranchID;
import code.simulator.Certificate;
import code.simulator.IrisNode;
import code.simulator.SimPreciseInv;
import code.simulator.agreement.Tuple;
import code.simulator.store.StoreEntry;

/**
 * @author princem
 * This filter receives notifications when syncs occur
 */
public interface SyncFilter{
  
  boolean notifySync(IrisNode myNode, 
      AcceptVV myCVV,
      BranchID otherNodeId, 
//      AcceptVV otherCVV, 
//      Checkpoint lastCheckpoint, 
      TreeSet<SimPreciseInv> newUpdates//, 
//      AcceptVV omitVV
      , Collection<Tuple<ObjId, TreeSet<StoreEntry>>> addedEntries
      ) throws Exception; 
  
  void notifyEpochSync(IrisNode myNode, Certificate cert) throws Exception;
  
  void syncOver(IrisNode myNode, boolean success) throws Exception;

}
