package code.simulator.protocolFilters.unit;

import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.simulator.*;
import code.simulator.protocolFilters.EvictionProposal;
import code.simulator.protocolFilters.EvictionProtocol;
import code.*;
 /** 
 *  Test bandwidth to subscribe to 1000 objects, 100 of which have
 
 *  been modified. Test created for sosp 2007 submission microbenchmark.
 
 **/ 

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class GCProtocolUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public GCProtocolUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    code.simulator.checkpoint.unit.SimulatorCheckpointUnit.makePractiConfig(0, 100);
  }


  public static int FIRST_NODE_ID = 10;
  public static int THIRD_NODE_ID = 15;

  public static int SECOND_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;


  public static String COARSE_PATH = "/coarse";


  public void testForking1(){
    try{
    System.out.println("/testForking");
    BranchID firstNodeId = NodeFactory.createNodeId(FIRST_NODE_ID);
    BranchID secondNodeId = NodeFactory.createNodeId(SECOND_NODE_ID);
    if(vverbose){
      System.out.println("UNIT ID: " + firstNodeId.toString());
    }
    assert(firstNodeId.equals(NodeFactory.createNodeId(FIRST_NODE_ID)));
    
    BranchID thirdNodeId = NodeFactory.createNodeId(THIRD_NODE_ID);
    

    TestPOMFilter tpf1 = new TestPOMFilter();
    TestPOMFilter tpf2 = new TestPOMFilter();
    TestPOMFilter tpf3 = new TestPOMFilter();
    TestPOMFilter tpf4 = new TestPOMFilter();
    TestPOMFilter tpf5 = new TestPOMFilter();
    
    IrisNode firstNode = (IrisNode)NodeFactory.createIrisNode(firstNodeId);
    firstNode.addPOMFilter(tpf1);
    
    /**
     * proper eviction filter
     */
    IrisNode secondNode = (IrisNode)NodeFactory.createNodeWithoutFilter(secondNodeId);
    secondNode.addPOMFilter(tpf2);
    EvictionProtocol evicProp2 = new EvictionProtocol();
    secondNode.addSyncFilter(evicProp2);
    secondNode.addDiscardeWriteFilter(evicProp2);
    secondNode.addPOMFilter(evicProp2);
    
    /**
     * no POM so not notified on POM receipt
     */
    IrisNode thirdNode = (IrisNode)NodeFactory.createNodeWithoutFilter(thirdNodeId);
    EvictionProtocol evicProp3 = new EvictionProtocol();
    thirdNode.addSyncFilter(evicProp3);
    thirdNode.addDiscardeWriteFilter(evicProp3);
    
    thirdNode.addPOMFilter(tpf3);
    
    /**
     * no sync filter
     */
    IrisNode fourthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(25));
    EvictionProtocol evicProp4 = new EvictionProtocol();
    fourthNode.addDiscardeWriteFilter(evicProp4);
    fourthNode.addPOMFilter(evicProp4);
    fourthNode.addPOMFilter(tpf4);
    
    /**
     * no sync/POM/discarded write filter
     */
    IrisNode fifthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(30));
    fifthNode.addPOMFilter(tpf5);

    //second set of writes
    
    HashMap<Long, TreeSet<Long>> evictionProposals2 = evicProp2.getEvictionProposals();
    HashMap<Long, TreeSet<Long>> evictionProposals3 = evicProp3.getEvictionProposals();
    HashMap<Long, TreeSet<Long>> evictionProposals4 = evicProp4.getEvictionProposals();
    
    
    int ni = 5;
    write(firstNode, COARSE_PATH, 0, ni-1, 0);
    checkRead(firstNode, COARSE_PATH, 0, ni-1, 0);

    assert firstNode.getCurrentVV().includes(new AcceptStamp(ni-1, firstNodeId));
    assert !firstNode.getCurrentVV().includes(new AcceptStamp(ni, firstNodeId));

    secondNode.sync(firstNode);


    ni=10;
    int numForks = 2;
    LinkedList<Node> forkedPseudoNodes = firstNode.fork(numForks);
    
    assert forkedPseudoNodes.size() == numForks;
    int i = 0;
    for(Node n1: forkedPseudoNodes){
      IrisNode n = (IrisNode)n1;
      checkRead(n, COARSE_PATH, 0, 4, 0);
      write(n, COARSE_PATH+i, 5, ni-1, 10);
      checkRead(n, COARSE_PATH+i, 5, ni-1, 10);
      i++;
    }
    
    
    secondNode.sync(forkedPseudoNodes.get(0));
    
    assert secondNode.getFaultyNodes().size() == 0;
    assert ((IrisNode)forkedPseudoNodes.get(0)).getFaultyNodes().size() == 0;
    assert tpf2.filter.size() == 0;

    // helper node should not accept the sync from thirdnode because thirdnode can't produce eviction certificate
    thirdNode.sync(forkedPseudoNodes.get(1));
    assert evictionProposals4.size() == 0;
    assert evictionProposals3.size() == 0;
    assert evictionProposals2.size() == 0;
    
    if(SangminConfig.useSync2){
      ((IrisNode)secondNode).exponentialBackoffSync(thirdNode);
    }
    
    secondNode.sync(thirdNode);
    assert evictionProposals3.size() == 0;
    assert evictionProposals2.size() == 1;
    
    assert secondNode.getFaultyNodes().size() == 1;
    assert thirdNode.getFaultyNodes().size() == 1;
    assert tpf2.filter.size() == 1;
    assert tpf3.filter.size() == 1;
    assert !checkRead(secondNode, COARSE_PATH+1, 5, ni-1, 10);
    assert checkRead(thirdNode, COARSE_PATH+1, 5, ni-1, 10);

    fourthNode.sync(thirdNode);
    fourthNode.notifyNewForks(secondNode.getPOMMap());
    secondNode.sync(fourthNode);
    fourthNode.sync(secondNode);
    assert evictionProposals4.size() == 1:evictionProposals4;
    assert evictionProposals2.size() == 1;
    assert evictionProposals2.get(new Long(FIRST_NODE_ID)).size() == 2:evictionProposals2.get(new Long(FIRST_NODE_ID)).size();
    
    assert tpf2.filter.size() == 1: tpf2.filter.size();
    
    forkedPseudoNodes = forkedPseudoNodes.get(0).fork(2);
    i=0;
    for(Node n1: forkedPseudoNodes){
      IrisNode n = (IrisNode)n1;
      checkRead(n, COARSE_PATH, 0, 4, 0);
      write(n, COARSE_PATH+i, 5, ni-1, 20);
      checkRead(n, COARSE_PATH+i, 5, ni-1, 20);
      i++;
    }
    
    fifthNode.sync(forkedPseudoNodes.get(1));
    if(SangminConfig.useSync2){
      ((IrisNode)fifthNode).exponentialBackoffSync(forkedPseudoNodes.get(0));
    }
    fifthNode.sync(forkedPseudoNodes.get(0));
    assert checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 20);
    //assert checkRead(fifthNode, COARSE_PATH+0, 5, ni-1, 20);
    assert tpf5.filter.size() == 1;


    fourthNode.sync(fifthNode);
    assert checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 10);
    assert checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 20);
    
    // shows that new write accompanied with new POM can be accepted
    secondNode.sync(fourthNode);
    checkRead(secondNode, COARSE_PATH+1, 5, ni-1, 10);
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }

    
    
  }
  
  
  public static boolean checkRead(Node n, 
      String prefix, 
      int is, int ie, int startVal){
      int ii;

    if(vverbose){
      System.out.println("Reading initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Reading " + oid);
      }
      Object o = n.read(oid);
      if(o == null)return false;
      assert o.equals(startVal + ii): "Expected value for obj " + oid + " was " + (startVal + ii) + " instead found " + n.read(oid);
    }
    return true;
  }

 /** 
 *  Write -- write 1-byte items to /prefix/[is..ie]/[js..je]/[ks..ke].
 
 *  Return final accept stamp.
 
 **/ 
  public static void write(Node n, 
                           String prefix, 
                           int is, int ie, 
                           int startVal){
    int ii;

    if(vverbose){
      System.out.println("Writing initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Writing " + oid);
      }
     
      n.write(oid, new IrisDataObject(new Integer(startVal + ii)));
    }
  }
    

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "/test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(GCProtocolUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "/test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "GCProtocolUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}



