package code.simulator.store;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

import code.AcceptStamp;
import code.ObjId;
import code.lasr.db.DbTransaction;
import code.simulator.Hash;
import code.simulator.IrisDataObject;
import code.simulator.IrisObject;

public class BodyStore implements BodyStoreInterface{

  private HashMap<Hash, IrisDataObject> bodyMap;
  
  public BodyStore(){
    bodyMap = new  HashMap<Hash, IrisDataObject>();
  }
  
  public IrisDataObject getBody(DbTransaction txn, Hash hash){
    return bodyMap.get(hash);
  }

  public boolean addBody(DbTransaction txn, IrisDataObject data){
    bodyMap.put(data.getHash(), data);
    return true;
  }

  public boolean removeBody(DbTransaction txn, Hash hash){
    if(bodyMap.containsKey(hash)){
      bodyMap.remove(hash);
    }
    return true;
  }

  public void retainHashes(DbTransaction txn, Set<Hash> hashes){
    TreeSet<Hash> removedHash = new TreeSet<Hash>();
    removedHash.addAll(bodyMap.keySet());
    removedHash.removeAll(hashes);
    for(Hash h: removedHash){
      bodyMap.remove(h);
    }
  }

  public boolean containsBody(DbTransaction txn, Hash hash){
    return bodyMap.containsKey(hash);
  }

  public String toString(){
    return "BodyStore: " + bodyMap;
  }

}
