package code.simulator.store;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

import code.simulator.Hash;
import code.simulator.IrisDataObject;
import code.simulator.persistentLog.PersistentStore;

import com.sleepycat.collections.StoredMap;
import code.lasr.db.*;

public class PersistentBodyStore implements BodyStoreInterface{

  PersistentStore ps;
  
  public PersistentBodyStore(PersistentStore pe) {
    this.ps = pe;
  }
  
  public IrisDataObject getBody(DbTransaction txn, Hash hash){
    try{
      byte[] body = (byte[])(txn.read(ps.storeDbHandle, hash.getHashVal()));
      if(body != null){
        return new IrisDataObject(body, hash);
      }
    }catch(DbException e){
      e.printStackTrace();
    }
    return null;
  }

  public boolean addBody(DbTransaction txn, IrisDataObject data){
    try{
      txn.write(ps.getStoreDbHandle(), data.getHash().getHashVal(), data.getUnsafeBytes());
      return true;
    }catch(DbException e){
      e.printStackTrace();
    }
    return false;
  }

  public boolean removeBody(DbTransaction txn, Hash hash){
    try{
      txn.remove(ps.getStoreDbHandle(), hash.getHashVal());
      return true;
    }catch(DbException e){
      e.printStackTrace();
    }
    return false;
  }

  public void retainHashes(DbTransaction txn, Set<Hash> hashes){
    try{
      DbIterator dbi = txn.getIterator(ps.getStoreDbHandle());
      while(dbi.hasNext()){
        dbi.next();
        Hash h = new Hash((byte[])dbi.getKey(), false);
        if(!hashes.contains(h)){
          dbi.delete();
        }
      }
    }catch(DbException e){
      e.printStackTrace();
    }
  }

  public boolean containsBody(DbTransaction txn, Hash hash){
    try{
      return (txn.read(ps.getStoreDbHandle(), hash.getHashVal()) != null);
    }catch(DbException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    return false;
  }
  
}
