package code.simulator.store;

import java.util.HashMap;
import java.util.TreeSet;

import code.simulator.Hash;

public class RefCount{
  
  private HashMap<Hash, Integer> refCounts;
  
  public RefCount(){
    refCounts = new HashMap<Hash, Integer>();
  }
  
  public void addRef(Hash h){
    if(!refCounts.containsKey(h)){
     refCounts.put(h, 1); 
    }else{
      refCounts.put(h, refCounts.get(h)+1);
    }
  }
  
  public boolean removeRef(Hash h){
    if(refCounts.containsKey(h) && refCounts.get(h) > 0){
      int val = refCounts.get(h);
      refCounts.put(h, val-1);
      if(val ==1){
        return true;
      }
    }
    return false;
  }

  public TreeSet<Hash> removedEntries(){
    TreeSet<Hash> re = new TreeSet<Hash>();
    for(Hash h: refCounts.keySet()){
      if(refCounts.get(h) == 0){
        re.add(h);
      }
    }
    return re;
  }
}
