package code.simulator.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import code.AcceptStamp;
import code.AcceptVV;
import code.NodeId;
import code.ObjId;
import code.SubscriptionSet;
import code.security.SangminConfig;
import code.simulator.Hash;
import code.simulator.IrisDataObject;
import code.simulator.IrisObject;
import code.simulator.Obj2Bytes;
import code.simulator.POMRemap;
import code.simulator.SimPreciseInv;
import code.simulator.agreement.Tuple;
import code.simulator.log.Log;

public interface StoreInterface{
  
  /**
   * Returns the number of key-value mappings in this map.  If the
   * map contains more than <tt>Integer.MAX_VALUE</tt> elements, returns
   * <tt>Integer.MAX_VALUE</tt>.
   *
   * @return the number of key-value mappings in this map
   */
  int size();

  /**
   * Returns <tt>true</tt> if this map contains no key-value mappings.
   *
   * @return <tt>true</tt> if this map contains no key-value mappings
   */
  boolean isEmpty();

  /**
   * Returns <tt>true</tt> if this map contains a mapping for the specified
   * key.  More formally, returns <tt>true</tt> if and only if
   * this map contains a mapping for a key <tt>k</tt> such that
   * <tt>(key==null ? k==null : key.equals(k))</tt>.  (There can be
   * at most one such mapping.)
   *
   * @param key key whose presence in this map is to be tested
   * @return <tt>true</tt> if this map contains a mapping for the specified
   *         key
   * @throws ClassCastException if the key is of an inappropriate type for
   *         this map (optional)
   * @throws NullPointerException if the specified key is null and this map
   *         does not permit null keys (optional)
   */
  boolean containsKey(ObjId key);
  
  TreeSet<StoreEntry> get(ObjId key);
  
  StoreEntry apply(SimPreciseInv spi);

  StoreInterface clone();
  
  void setIgnoreSet(SubscriptionSet ignoreSet2);
  
  StoreInterface applyBranchMap(HashMap<NodeId, NodeId> branchMap);
  
  void applyPOMRemap(POMRemap pr);

  TreeSet<Hash> getObjectHashes(ObjId objId);

  LinkedList<IrisObject> getData(ObjId objId);

  LinkedList<StoreEntry> getRawData(ObjId objId);

  SubscriptionSet getIgnoreSet();

  Map<ObjId, TreeSet<StoreEntry>> subMap(ObjId objIdStart, boolean b,
      ObjId objIdEnd, boolean c);

  void clear();

  Iterator<ObjId> iterator();

  TreeSet<StoreEntry> put(ObjId o, TreeSet<StoreEntry> treeSet);

  void startTxn();

  void endTxn(boolean b);

  long getStoreId();

  LinkedList<Tuple<ObjId, TreeSet<StoreEntry>>> getAddedEntries();

  HashMap<ObjId, TreeSet<StoreEntry>> getRemovedEntries();
  
  void putAll(StoreInterface si);
  
  IrisObject getBody(ObjId o, Hash hash);

}
