package code.simulator.store.unit;

import java.util.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.*;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.simulator.agreement.Tuple;
import code.simulator.checkpoint.Checkpoint;
import code.simulator.checkpoint.unit.SimulatorCheckpointUnit;
import code.simulator.ConcurrentPOM;
import code.simulator.Flags;
import code.simulator.Hash;
import code.simulator.HashedVV;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.simulator.Node;
import code.simulator.NodeFactory;
import code.simulator.POMRemap;
import code.simulator.ProofOfMisbehavior;
import code.simulator.SecureSimPreciseInv;
import code.simulator.SimPreciseInv;
import code.simulator.SyncPacket;
import code.simulator.SyncRequest;
import code.simulator.SyncStatus;
import code.simulator.log.Log;
import code.simulator.log.LogStatus;
import code.simulator.log.NodeLog;
import code.simulator.store.Store;
import code.simulator.store.StoreEntry;
import code.simulator.store.StoreInterface;

public class StoreUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public StoreUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    code.simulator.checkpoint.unit.SimulatorCheckpointUnit.makePractiConfig(0, 100);

  }


  public static int UNIT_NODE_ID = 10;
  public static int MIDDLE_NODE_ID = 15;

  public static int HELPER_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;


  public static String COARSE_PATH = "/coarse";


  //--------------------------------------------------------------------------- 
  // Test coarse-grained subscriptions. 
  //
  // To initialize state, Unit create 1000 objects
  // (/data-coarse/[0..9]/[0..9]/[0..9]. Then helper subscribe
  // to /* from unit and wait for /data-coarse/9/9/9 to arrive.
  //
  //
  // start helper and wait for writing to complete
  //---------------------------------------------------------------------------
  public void testCOW(){
    try{
      System.out.println("/testCOW");

      BranchID nodeId1 = NodeFactory.createNodeId(15);
      BranchID nodeId2 = NodeFactory.createNodeId(20);
      BranchID nodeId3 = NodeFactory.createNodeId(25);

      Node node1 = NodeFactory.createNodeWithoutFilter(nodeId1);
      Node node2 = NodeFactory.createNodeWithoutFilter(nodeId2);
      Node node3 = NodeFactory.createNodeWithoutFilter(nodeId3);

      ObjId oid0 = new ObjId("/test/0");
      node1.write(oid0, new IrisDataObject(new Integer(0)));

      ObjId oid1 = new ObjId("/test/1");
      node1.write(oid1, new IrisDataObject(new Integer(1)));

      node2.write(new ObjId("/test/00"), new IrisDataObject(new Integer(2)));
      node2.write(new ObjId("/test/01"), new IrisDataObject(new Integer(3)));
      node3.write(new ObjId("/test/0"), new IrisDataObject(new Integer(4)));
      node3.write(new ObjId("/test/1"), new IrisDataObject(new Integer(5)));

      Log log1 = node1.getLogTest();
      Log log2 = node2.getLogTest();
      Log log3 = node3.getLogTest();
      StoreInterface store1 = node1.getStoreTest();
      assert store1.size() == 2: store1;
      StoreInterface store2 = node2.getStoreTest();
      assert store2.size() == 2: store2;
      StoreInterface store3 = node3.getStoreTest();
      assert store3.size() == 2: store3;
      
      // test the use of addedEntries
      StoreInterface store1Clone = node1.getStore();
      store1.startTxn();
      store1.apply((SimPreciseInv)log2.get(nodeId2).get(0));
      assert store1Clone.size() == (store1.size()-1); // one new entry added
      assert !store1.equals(store1Clone);
      LinkedList<Tuple<ObjId, TreeSet<StoreEntry>>> modifiedEntries = store1.getAddedEntries();
      assert modifiedEntries.size() == 1;
      Tuple<ObjId, TreeSet<StoreEntry>> tp = modifiedEntries.get(0);
      assert store2.containsKey(tp.getKey());
      assert store2.get(tp.getKey()).equals(tp.getValue());
      store1.endTxn(false);
      assert store1.equals(store1Clone);
      
      store1.startTxn();
      store1.apply((SimPreciseInv)log2.get(nodeId2).get(0));
      store1.endTxn(true);
      assert !store1.equals(store1Clone);

      // test the use of modifiedEntries
      store1Clone = node1.getStore();
      assert store1Clone.equals(store1);

      store1.startTxn();
      store1.apply((SimPreciseInv)log3.get(nodeId3).get(0));
      assert store1Clone.size() == store1.size(): "\n"+store1Clone +"\n" + store1; // one entry modified
      assert !store1.equals(store1Clone);
      
      modifiedEntries = store1.getAddedEntries();
      assert modifiedEntries.size() == 1;
      tp = modifiedEntries.get(0);
      assert store1Clone.containsKey(tp.getKey());
      assert store3.containsKey(tp.getKey());
      assert tp.getValue().containsAll(store3.get(tp.getKey()));
      assert !store3.get(tp.getKey()).containsAll(tp.getValue());
      store1.endTxn(false);
      assert store1.equals(store1Clone);
      
      store1.startTxn();
      store1.apply((SimPreciseInv)log3.get(nodeId3).get(0));
      store1.endTxn(true);
      assert !store1.equals(store1Clone);
      
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }


  }

  public boolean apply(Log log, SimPreciseInv spi, byte applyCondition, LogStatus expectedStatus){
    LogStatus ls = log.apply(spi, applyCondition);
    if(ls.equals(expectedStatus)){
      return true;
    }else{
      return false;
    }
  }

 
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "/test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(StoreUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "/test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "StoreUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}
