package code.simulator.unit;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Random;

import code.AcceptStamp;
import code.Config;
import code.Env;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.ResultStats;
import code.SummaryHash;
import code.branchDetecting.BranchID;
import code.security.Crypto;
import code.security.DataHash;
import code.security.SecurePreciseInv;
import code.security.ahs.DependencyVV;
import code.simulator.Hash;
import code.simulator.IrisDataObject;
import code.simulator.Node;
import code.simulator.NodeFactory;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.client.ClientNode;
import code.untrustedstorage.writeanyreadany.client.ClientNodeWrapper;

public class Benchmark{
  public static final int UNIT_NODE_ID = 10;
    public static final int NUM=1000 ;
  protected static void  makeDummyConfig(String path, int nNodes){

    // System.out.println("DBG: user.dir = " //MDD Debug jswat working dir
    // + System.getProperties().getProperty("user.dir")); 

    Config.createEmptyConfig();

    for(int i=0; i < nNodes; i++){
      NodeId id = new NodeId(NodeFactory.createNodeId(i).getIDint());
      Config.addOneNodeConfig(id, "localhost",
          4778+i, 3588+i, 4588+i, 5588+i, 6588+i, 
          "testBranchManager_"+i+".db", "/*", -1, 
          "localhost.cs.utexas.edu", 7078+i, 7578+i, -1,Config.CACHE_SIZE_BYTES_DEFAULT,
          Config.MAX_LOG_DISK_SIZE_BYTES, Config.MAX_LOG_MEM_SIZE_BYTES);
    }
    System.out.println("Config file for " + Config.getNumNodes() + " nodes created");
    Config.writeToFile(path);
    Config.readConfig(path);
    Config.publicKeys.get(10);
  }
  
public static void main3(String[] argv) throws IOException{
    
    int datasize = 1024;
    if(argv.length > 0){
      datasize = Integer.parseInt(argv[0]);
    }
    int mode = 0;
    int All = 0, HashGen = 1, SigGen = 2, SigVer =3;
    if(argv.length > 1){
      if(argv[1].contains("All")){
        mode = All;
      }else if(argv[1].contains("HashGen")){
        mode = HashGen;
      }else if(argv[1].contains("SigGen")){
        mode = SigGen;
      }else if(argv[1].contains("SigVer")){
        mode = SigVer;
      }
    }
    
    
    try{
      Config.readKeys();
    } catch (Exception e){
      e.printStackTrace();
      System.exit(-1);
    }
    System.out.println("Key reading completed.");
    PrivateKey privKey = (PrivateKey)Config.privateKeys.get(new Long(1));
    PublicKey pubKey = (PublicKey)Config.publicKeys.get(new Long(1));

    ResultStats stats = new ResultStats();
    ResultStats hstats = new ResultStats();
    ResultStats stats2 = new ResultStats();
    long start = 0,end = 0;

    
    Signature sig = Crypto.getSignature();
    byte[] signature = null;
    Random r = new Random(System.currentTimeMillis());
    byte[] b = new byte[datasize];
    r.nextBytes(b);    
    ResultStats.logData = true;
    try{
      sig.initSign(privKey);
      sig.update(b);
      signature = sig.sign();
    }catch(Exception e){
      System.out.println(e.toString());
      e.printStackTrace();
      System.exit(-1);
    } 
    Hash h = Hash.NullHash;
    for(int i=0; i<NUM; i++){
      b[0] = (byte)(i&0xFF);
      b[1] = (byte)((i>>8)&0xFF);
      try{
        if(mode == All || mode == HashGen){
          start = System.currentTimeMillis();
          h = new Hash(b,true);
          end = System.currentTimeMillis();
          hstats.enter(end-start);
        }
        if(mode == All || mode == SigGen){
          sig.initSign(privKey);
          start = System.currentTimeMillis();
          sig.update(h.getHashVal());
          signature = sig.sign();
          end = System.currentTimeMillis();
          stats.enter((double)end-start);
        }

        if(mode == All || mode == SigVer){
          sig.initVerify(pubKey);
          start = System.currentTimeMillis();
          sig.update(h.getHashVal());
          if(!sig.verify(signature)){
            System.out.println("Verification failed. " + i);
            System.exit(-1);
          }
          end = System.currentTimeMillis();
          stats2.enter((double)end-start);
        }
      }catch(Exception e){
        System.out.println(e.toString());
        e.printStackTrace();
        System.exit(-1);
      }      
    }
    System.out.println("###### hash time!!");
    System.out.println("Summary1:"  + hstats.getSummary(1));
    System.out.println("Summary0:" + hstats.getSummary(0));
    System.out.println(hstats.getAverage90());
    System.out.println("###### Signning time!!");
    System.out.println("Summary1:"  + stats.getSummary(1));
    System.out.println("Summary0:" + stats.getSummary(0));
    System.out.println(stats.getAverage90());
    System.out.println("###### Verifying time!!");
    System.out.println("Summary1:"  + stats2.getSummary(1));
    System.out.println("Summary0:" + stats2.getSummary(0));
    System.out.println(stats2.getSummary(1));
    System.out.println(stats2.getAverage90());
  }

  public static void main(String[] args){
    System.currentTimeMillis();
    System.nanoTime();
    long s = System.nanoTime();
    int NUM = 100000000;
    for(int i = 0; i <NUM; i++){
      System.currentTimeMillis();
    }
    System.out.println(NUM + " calls took " + (System.nanoTime()-s));
//    s = System.nanoTime();
//    for(int i = 0; i <NUM; i++){
//      System.nanoTime();
//    }
//    System.out.println(NUM + " calls took " + (System.nanoTime()-s));
  }
  
  public static void main1(String[] args){
    int size = StorageConfig.objSize;
    if(args.length  > 0){
      size = Integer.parseInt(args[0]); 
    }
    makeDummyConfig("/tmp/configtest", 50);

    BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);

    assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));

    Node myNode = NodeFactory.createNodeWithoutFilter(myNodeId);

    byte[] data = new byte[size];

    for(int i=0; i < data.length; i++){
      data[i] = (byte) i;
    }
    ResultStats rs = new ResultStats();

      System.out.println("Hello from SimulatorUnit2");

     try{
      Thread.sleep(10000);
    }catch(InterruptedException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    long t1, t2;

    ObjId oid;
    t1 = System.currentTimeMillis();

    for(int i=0; i<StorageConfig.numObjs ; i++){
      long tt1 = System.currentTimeMillis();

      oid = new ObjId(ClientNodeWrapper.getKeyString(i));
      //oid = new ObjId("/" + String.format("%31d", i));
      data[0] = (byte)myNodeId.getIDint();
      data[1] = (byte)t1;
      data[2] = (byte)Long.rotateRight(t1, 8);
      myNode.write(oid, new IrisDataObject(data));
      long tt2 = System.currentTimeMillis();
      rs.enter(tt2-tt1);

    }

    t2 = System.currentTimeMillis();
    System.out.println(StorageConfig.numObjs + " writes took " + (t2-t1));
    System.out.println("avg0" + rs.getMean(0));
    System.out.println("90%" + rs.getAverage90());
    System.out.println("std0" + rs.getStandardDeviation(0));
    System.out.println("avg1" + rs.getMean(1));
    System.out.println("std1" + rs.getStandardDeviation(1));
    
    System.out.println(StorageConfig.numObjs + " writes took " + (t2-t1));
  }
}
