package code.simulator.unit;


import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;

import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.SummaryHash;
import code.simulator.*;
import code.simulator.protocolFilters.unit.TestPOMFilter;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BranchDetectorUnit extends TestCase{
  public static String COARSE_PATH = "/coarse";

  
  protected void setUp() throws Exception{
    super.setUp();
  }
  public static int UNIT_NODE_ID = 10;
  public static int MIDDLE_NODE_ID = 15;

  public static int HELPER_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;
  
  public void testForking1(){
    try{
      System.out.println("testForking");
      SimBranchID myNodeId = new SimBranchID(UNIT_NODE_ID);
      SimBranchID thirdNodeId = new SimBranchID(MIDDLE_NODE_ID);
      
      SimBranchID helperNodeId = new SimBranchID(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(new SimBranchID(UNIT_NODE_ID)));
  
      TestPOMFilter tpf1 = new TestPOMFilter();
      TestPOMFilter tpf2 = new TestPOMFilter();
      TestPOMFilter tpf3 = new TestPOMFilter();
      TestPOMFilter tpf4 = new TestPOMFilter();
      TestPOMFilter tpf5 = new TestPOMFilter();
      
      IrisNode myNode = (IrisNode)NodeFactory.createIrisNode(myNodeId);
      myNode.addPOMFilter(tpf1);
      IrisNode helperNode = (IrisNode)NodeFactory.createNodeWithoutFilter(helperNodeId);
      helperNode.addPOMFilter(tpf2);
      IrisNode thirdNode = (IrisNode)NodeFactory.createNodeWithoutFilter(thirdNodeId);
      thirdNode.addPOMFilter(tpf3);
      IrisNode fourthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(new SimBranchID(25));
      fourthNode.addPOMFilter(tpf4);
      IrisNode fifthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(new SimBranchID(30));
      fifthNode.addPOMFilter(tpf5);
      //second set of writes
      
      
      int ni = 5;
      write(myNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myNode, COARSE_PATH, 0, ni-1, 0);

      assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
      assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));

      helperNode.sync(myNode);


      ni=10;
      int numForks = 2;
      LinkedList<Node> forkedPseudoNodes = myNode.fork(numForks);
      
      assert forkedPseudoNodes.size() == numForks;
      int i = 0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 0);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 0);
        i++;
      }
      
      
      helperNode.sync(forkedPseudoNodes.get(0));
      
      assert helperNode.getFaultyNodes().size() == 0;
      assert ((IrisNode)forkedPseudoNodes.get(0)).getFaultyNodes().size() == 0;
      assert tpf2.filter.size() == 0;

      thirdNode.sync(forkedPseudoNodes.get(1));
      helperNode.sync(thirdNode);
      
      assert helperNode.getFaultyNodes().size() == 1;
      assert thirdNode.getFaultyNodes().size() == 1;
      assert tpf2.filter.size() == 1;
      assert tpf3.filter.size() == 1;
      
      fourthNode.sync(helperNode);
      assert tpf2.filter.size() == 1: tpf2.filter.size();
      assert tpf4.filter.size() == 1: tpf4.filter.size();
      
      
      forkedPseudoNodes = forkedPseudoNodes.get(0).fork(2);
      i=0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 10);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 10);
        i++;
      }
      
      fifthNode.sync(forkedPseudoNodes.get(0));
      fifthNode.sync(forkedPseudoNodes.get(1));
      assert tpf5.filter.size() == 1;


      fifthNode.sync(helperNode);
      assert tpf5.filter.size() == 2;
      assert tpf2.filter.size() == 1;

      helperNode.sync(fifthNode);
      assert tpf5.filter.size() == 2;
      assert tpf2.filter.size() == 1;
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }

    
    
  }
  
  public static void checkRead(IrisNode n, 
      String prefix, 
      int is, int ie, int startVal){
      int ii;

    if(vverbose){
      System.out.println("Reading initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Reading " + oid);
      }
      assert n.read(oid).equals(startVal + ii): "Expected value for obj " + oid + " was " + (startVal + ii) + " instead found " + n.read(oid);
    }
  }

 /** 
 *  Write -- write 1-byte items to /prefix/[is..ie]/[js..je]/[ks..ke].
 
 *  Return final accept stamp.
 
 **/ 
  public static void write(IrisNode n, 
                           String prefix, 
                           int is, int ie, 
                           int startVal){
    int ii;

    if(vverbose){
      System.out.println("Writing initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Writing " + oid);
      }
     
      n.write(oid, new IrisDataObject(new Integer(startVal + ii)));
    }
  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(BranchDetectorUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "BranchDetectorUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }
}
