package code.simulator.unit;

import code.branchDetecting.BranchID;
import code.simulator.*;
import code.*;
 /** 
 *  Test bandwidth to subscribe to 1000 objects, 100 of which have
 
 *  been modified. Test created for sosp 2007 submission microbenchmark.
 
 **/ 

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class NetSyncUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public NetSyncUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
 
  }


  public static int UNIT_NODE_ID = 10;
  public static int MIDDLE_NODE_ID = 15;

  public static int HELPER_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;


  public static String COARSE_PATH = "/coarse";


  //--------------------------------------------------------------------------- 
  // Test coarse-grained subscriptions. 
  //
  // To initialize state, Unit create 1000 objects
  // (/data-coarse/[0..9]/[0..9]/[0..9]. Then helper subscribe
  // to /* from unit and wait for /data-coarse/9/9/9 to arrive.
  //
  //
  // start helper and wait for writing to complete
  //---------------------------------------------------------------------------
  public void dotestSimple(){
    try{
      System.out.println("testSimple");

      BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);
      
      BranchID helperNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));
  
      Node myNode = NodeFactory.createNodeWithoutFilter(myNodeId);
      Node helperNode = NodeFactory.createNodeWithoutFilter(helperNodeId);

      //second set of writes
      
      if(verbose){
        System.out.println("Hello from SimulatorUnit");
      }

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      write(myNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myNode, COARSE_PATH, 0, ni-1, 0);

      assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
      assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));

      helperNode.sync(myNode);

      checkRead(helperNode, COARSE_PATH, 0, ni-1, 0);
      
      // now do writes at helper node and sync with the main node
      
      write(helperNode, COARSE_PATH, 0, ni-1, 10);
      checkRead(helperNode, COARSE_PATH, 0, ni-1, 10);

      assert helperNode.getCurrentVV().includes(new AcceptStamp(ni-1+5, helperNodeId));
      assert !helperNode.getCurrentVV().includes(new AcceptStamp(ni+5, helperNodeId));

      myNode.sync(helperNode);
      checkRead(myNode, COARSE_PATH, 0, ni-1, 10);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
  }
  
  //--------------------------------------------------------------------------- 
  // Test conflict resolution by ensuring that writes with same time stamp and to same objects are resolved based on the nodeId
  //---------------------------------------------------------------------------
  public void testConflictResolution(){
    try{
      System.out.println("testConflictResolution");
      BranchID myNodeId = NodeFactory.createNodeId(0);
      BranchID helperNodeId = NodeFactory.createNodeId(1);
      
      Node myNode = NodeFactory.createConfigNodeWithoutFilter(myNodeId, "/Users/princem/workspace/testbranch/trace.config");
      Node helperNode = NodeFactory.createConfigNodeWithoutFilter(helperNodeId, "/Users/princem/workspace/testbranch/trace.config");

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      write(myNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myNode, COARSE_PATH, 0, ni-1, 0);
      assert myNode.getLogTest().get(myNode.getBranchID()).size() == 5;
      assert myNode.getLogTest().get(helperNodeId).size() == 0;
      
      ((IrisNode)helperNode).sync2(myNode.getBranchID(), helperNode.getCurrentVV(), false);
      
//    assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
//    assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));
//
//    checkRead(myNode, COARSE_PATH, 0, ni-1, 0);
//
//    // now do writes at helper node and sync with the main node
//    ni=10;
//    write(helperNode, COARSE_PATH, 0, ni-1, 10);
//    assert helperNode.getLogTest().get(myNode.getBranchID()).size() == 0;
//    assert helperNode.getLogTest().get(helperNodeId).size() == 10;
//    
//    checkRead(helperNode, COARSE_PATH, 0, ni-1, 10);
//
//    assert helperNode.getCurrentVV().includes(new AcceptStamp(ni-1, helperNodeId));
//    assert !helperNode.getCurrentVV().includes(new AcceptStamp(ni, helperNodeId));
//
//    ((IrisNode)myNode).sync2(helperNode.getBranchID(), myNode.getCurrentVV());
//    assert myNode.getLogTest().get(myNode.getBranchID()).size() == 5;
//    assert myNode.getLogTest().get(helperNodeId).size() == 10;
//    
//    //ensure that local writes got overwritten
//    checkRead(myNode, COARSE_PATH, 0, ni-1, 10);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
  }
  
  
  public static void checkRead(Node n, 
      String prefix, 
      int is, int ie, int startVal){
      int ii;

    if(vverbose){
      System.out.println("Reading initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Reading " + oid);
      }
      assert n.read(oid).equals(startVal + ii): "Expected value for obj " + oid + " was " + (startVal + ii) + " instead found " + n.read(oid);
    }
  }

 /** 
 *  Write -- write 1-byte items to /prefix/[is..ie]/[js..je]/[ks..ke].
 
 *  Return final accept stamp.
 
 **/ 
  public static void write(Node n, 
                           String prefix, 
                           int is, int ie, 
                           int startVal){
    int ii;

    if(vverbose){
      System.out.println("Writing initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Writing " + oid);
      }
     
      n.write(oid, new IrisDataObject(new Integer(startVal + ii)));
    }
  }
    

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(NetSyncUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SimulatorUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}



