package code.simulator.unit;

import code.security.SangminConfig;
import code.simulator.*;
import code.simulator.protocolFilters.EvictionCertificate;
import code.simulator.protocolFilters.InstantGCProtocol;
import code.*;
 /** 
 *  Test bandwidth to subscribe to 1000 objects, 100 of which have
 
 *  been modified. Test created for sosp 2007 submission microbenchmark.
 
 **/ 

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;
import code.branchDetecting.*;


/**
 * TBD: Update class name
 */
public class RollbackUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public RollbackUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
 
  }


  public static int UNIT_NODE_ID = 10;
  public static int MIDDLE_NODE_ID = 15;

  public static int HELPER_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;


  public static String COARSE_PATH = "/coarse";

  //--------------------------------------------------------------------------- 
  // Test coarse-grained subscriptions. 
  //
  // To initialize state, Unit create 1000 objects
  // (/data-coarse/[0..9]/[0..9]/[0..9]. Then helper subscribe
  // to /* from unit and wait for /data-coarse/9/9/9 to arrive.
  //
  //
  // start helper and wait for writing to complete
  //---------------------------------------------------------------------------
  public void testSimple(){
    try{
      System.out.println("testSimple");

      BranchID myIrisNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);
      
      BranchID helperIrisNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myIrisNodeId.toString());
      }
      assert(myIrisNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));
  
      IrisNode myIrisNode = (IrisNode)NodeFactory.createNodeWithoutFilter(myIrisNodeId);
      IrisNode helperIrisNode = (IrisNode)NodeFactory.createNodeWithoutFilter(helperIrisNodeId);

      //second set of writes
      
      if(verbose){
        System.out.println("Hello from RollbackUnit");
      }

      assert myIrisNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      write(myIrisNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 0);

      assert myIrisNode.getCurrentVV().includes(new AcceptStamp(ni-1, myIrisNodeId));
      assert !myIrisNode.getCurrentVV().includes(new AcceptStamp(ni, myIrisNodeId));

      helperIrisNode.sync(myIrisNode);

      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 0);
      
      // now do writes at helper node and sync with the main node
      
      write(helperIrisNode, COARSE_PATH, 0, ni-1, 10);
      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 10);

      
      
      assert helperIrisNode.getCurrentVV().includes(new AcceptStamp(ni-1+5, helperIrisNodeId));
      assert !helperIrisNode.getCurrentVV().includes(new AcceptStamp(ni+5, helperIrisNodeId));

      myIrisNode.sync(helperIrisNode);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 10);
      
      HashMap<BranchID, TreeSet<PreciseInv>> acceptedWrites = myIrisNode.getAcceptedForkedWrites(helperIrisNodeId);
      
      write(myIrisNode, COARSE_PATH, 0, ni-1, 20);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 20);
      
      write(helperIrisNode, COARSE_PATH, 0, ni-1, 30);
      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 30);
      
      myIrisNode.sync(helperIrisNode);
      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 30);
      
      EvictionCertificate ec = new EvictionCertificate(helperIrisNode.getBranchID().getBaseId(), acceptedWrites, 1);
      myIrisNode.addCertificate(ec);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 20);
      
      assert myIrisNode.getEpoch() == 1;
      
      write(helperIrisNode, COARSE_PATH, 0, ni-1, 40);
      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 40);
      
      myIrisNode.sync(helperIrisNode);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 20);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
  }
  
  public void testSimple1(){
    try{
      System.out.println("testSimple");

      BranchID myIrisNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);
      
      BranchID helperIrisNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myIrisNodeId.toString());
      }
      assert(myIrisNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));
  
      IrisNode myIrisNode = (IrisNode)NodeFactory.createNodeWithoutFilter(myIrisNodeId);
      IrisNode helperIrisNode = (IrisNode)NodeFactory.createNodeWithoutFilter(helperIrisNodeId);

      //second set of writes
      
      if(verbose){
        System.out.println("Hello from RollbackUnit");
      }

      assert myIrisNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      write(myIrisNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 0);

      assert myIrisNode.getCurrentVV().includes(new AcceptStamp(ni-1, myIrisNodeId));
      assert !myIrisNode.getCurrentVV().includes(new AcceptStamp(ni, myIrisNodeId));

      helperIrisNode.sync(myIrisNode);

      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 0);
      
      // now do writes at helper node and sync with the main node
      
      write(helperIrisNode, COARSE_PATH, 0, ni-1, 10);
      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 10);

      
      
      assert helperIrisNode.getCurrentVV().includes(new AcceptStamp(ni-1+5, helperIrisNodeId));
      assert !helperIrisNode.getCurrentVV().includes(new AcceptStamp(ni+5, helperIrisNodeId));

      myIrisNode.sync(helperIrisNode);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 10);
      
      HashMap<BranchID, TreeSet<PreciseInv>> acceptedWrites = myIrisNode.getAcceptedForkedWrites(helperIrisNodeId);
      
      write(helperIrisNode, COARSE_PATH, 0, ni-1, 30);
      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 30);
      
      myIrisNode.sync(helperIrisNode);
      checkRead(helperIrisNode, COARSE_PATH, 0, ni-1, 30);
      
      write(myIrisNode, COARSE_PATH, 0, ni-1, 20);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 20);
      
      EvictionCertificate ec = new EvictionCertificate(helperIrisNode.getBranchID().getBaseId(), acceptedWrites, 1);
      myIrisNode.addCertificate(ec);
      checkRead(myIrisNode, COARSE_PATH, 0, ni-1, 10);
      
      assert myIrisNode.getEpoch() == 1;
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
  }
  
  public void testForking(){
    try{
      System.out.println("testForking");
      BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);
      BranchID thirdNodeId = NodeFactory.createNodeId(MIDDLE_NODE_ID);
      
      BranchID helperNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));
  
      
      IrisNode myNode = (IrisNode)NodeFactory.createNodeWithoutFilter(myNodeId);
      ((IrisNode)myNode).addSyncFilter(new InstantGCProtocol());

      IrisNode helperNode = (IrisNode)NodeFactory.createNodeWithoutFilter(helperNodeId);
      ((IrisNode)helperNode).addSyncFilter(new InstantGCProtocol());

      IrisNode thirdNode = (IrisNode)NodeFactory.createNodeWithoutFilter(thirdNodeId);
      ((IrisNode)thirdNode).addSyncFilter(new InstantGCProtocol());

      IrisNode fourthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(25));
      ((IrisNode)fourthNode).addSyncFilter(new InstantGCProtocol());

      IrisNode fifthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(30));
      ((IrisNode)fifthNode).addSyncFilter(new InstantGCProtocol());

      //second set of writes
      
      if(verbose){
        System.out.println("Hello from SimulatorUnit");
      }

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      write(myNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myNode, COARSE_PATH, 0, ni-1, 0);

      assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
      assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));


      ni=10;
      int numForks = 2;
      LinkedList<Node> forkedPseudoNodes = myNode.fork(numForks);
      
      assert forkedPseudoNodes.size() == numForks;
      int i = 0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 0);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 0);
        i++;
      }
      
      
      helperNode.sync(forkedPseudoNodes.get(0));
      thirdNode.sync(forkedPseudoNodes.get(1));
      if(!SangminConfig.useSimulatorId){
        ((IrisNode)helperNode).exponentialBackoffSync(thirdNode);
      }
      helperNode.sync(thirdNode);
      thirdNode.sync(helperNode);
      
      checkRead(helperNode, COARSE_PATH, 0, 4, 0);
      checkRead(helperNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(helperNode, COARSE_PATH+1, 5, ni-1, 0);
      
      
      checkRead(thirdNode, COARSE_PATH, 0, 4, 0);
      checkRead(thirdNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(thirdNode, COARSE_PATH+1, 5, ni-1, 0);

      HashMap<BranchID, TreeSet<PreciseInv>> acceptedWrites = thirdNode.getAcceptedForkedWrites(myNodeId);

      i=0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 10);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 10);
        i++;
      }
      
      fourthNode.sync(forkedPseudoNodes.get(0));
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 10);
      
      
      fifthNode.sync(forkedPseudoNodes.get(1));
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);

      if(!SangminConfig.useSimulatorId){
        ((IrisNode)fourthNode).exponentialBackoffSync(fifthNode);
      }
      fourthNode.sync(fifthNode);
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1,10);

      fifthNode.sync(fourthNode);
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fifthNode, COARSE_PATH+0, 5, ni-1,10);

      EvictionCertificate ec = new EvictionCertificate(myNode.getBranchID().getBaseId(), acceptedWrites, 1);
      thirdNode.addCertificate(ec);
      checkRead(thirdNode, COARSE_PATH, 0, 4, 0);
      checkRead(thirdNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(thirdNode, COARSE_PATH+1, 5, ni-1, 0);
      
      helperNode.addCertificate(ec);
      checkRead(helperNode, COARSE_PATH, 0, 4, 0);
      checkRead(helperNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(helperNode, COARSE_PATH+1, 5, ni-1, 0);
      
      fifthNode.addCertificate(ec);
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 0);
      
      fourthNode.addCertificate(ec);
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 0);
      
      fourthNode.sync(forkedPseudoNodes.get(0));
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 0);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
  }
  
  public void testForking1(){
    try{
      System.out.println("testForking1");
      BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);
      BranchID thirdNodeId = NodeFactory.createNodeId(MIDDLE_NODE_ID);
      
      BranchID helperNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));
  
      IrisNode myNode = (IrisNode)NodeFactory.createNodeWithoutFilter(myNodeId);
      ((IrisNode)myNode).addSyncFilter(new InstantGCProtocol());

      IrisNode helperNode = (IrisNode)NodeFactory.createNodeWithoutFilter(helperNodeId);
      ((IrisNode)helperNode).addSyncFilter(new InstantGCProtocol());

      IrisNode thirdNode = (IrisNode)NodeFactory.createNodeWithoutFilter(thirdNodeId);
      ((IrisNode)thirdNode).addSyncFilter(new InstantGCProtocol());

      IrisNode fourthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(25));
      ((IrisNode)fourthNode).addSyncFilter(new InstantGCProtocol());

      IrisNode fifthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(30));
      ((IrisNode)fifthNode).addSyncFilter(new InstantGCProtocol());


      //second set of writes
      
      if(verbose){
        System.out.println("Hello from SimulatorUnit");
      }

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      write(myNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myNode, COARSE_PATH, 0, ni-1, 0);

      assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
      assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));


      ni=10;
      int numForks = 2;
      LinkedList<Node> forkedPseudoNodes = myNode.fork(numForks);
      
      assert forkedPseudoNodes.size() == numForks;
      int i = 0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 0);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 0);
        i++;
      }
      
      
      helperNode.sync(forkedPseudoNodes.get(0));
      thirdNode.sync(forkedPseudoNodes.get(1));
      if(!SangminConfig.useSimulatorId){
        ((IrisNode)helperNode).exponentialBackoffSync(thirdNode);
      }
      helperNode.sync(thirdNode);
      thirdNode.sync(helperNode);
      
      checkRead(helperNode, COARSE_PATH, 0, 4, 0);
      checkRead(helperNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(helperNode, COARSE_PATH+1, 5, ni-1, 0);
      
      
      checkRead(thirdNode, COARSE_PATH, 0, 4, 0);
      checkRead(thirdNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(thirdNode, COARSE_PATH+1, 5, ni-1, 0);

      thirdNode.garbageCollect(thirdNode.getCurrentVV());
      HashMap<BranchID, TreeSet<PreciseInv>> acceptedWrites = thirdNode.getAcceptedForkedWrites(myNodeId);

      helperNode.sync(thirdNode);
      
      i=0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 10);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 10);
        i++;
      }
      
      fourthNode.sync(forkedPseudoNodes.get(0));
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 10);
      
      
      fifthNode.sync(forkedPseudoNodes.get(1));
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);

      if(!SangminConfig.useSimulatorId){
        ((IrisNode)fourthNode).exponentialBackoffSync(fifthNode);
      }
      fourthNode.sync(fifthNode);
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1,10);

      fifthNode.sync(fourthNode);
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fifthNode, COARSE_PATH+0, 5, ni-1,10);

      EvictionCertificate ec = new EvictionCertificate(myNode.getBranchID().getBaseId(), acceptedWrites, 2);
      thirdNode.addCertificate(ec);
      checkRead(thirdNode, COARSE_PATH, 0, 4, 0);
      checkRead(thirdNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(thirdNode, COARSE_PATH+1, 5, ni-1, 0);
      
      helperNode.addCertificate(ec);
      checkRead(helperNode, COARSE_PATH, 0, 4, 0);
      checkRead(helperNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(helperNode, COARSE_PATH+1, 5, ni-1, 0);
      
      fifthNode.sync(helperNode);
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 0);
      
      fourthNode.sync(helperNode);
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 0);
      
      fourthNode.sync(forkedPseudoNodes.get(0));
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 0);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
  }
  
  public void testForking2(){
    try{
      System.out.println("testForking");
      BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);
      BranchID thirdNodeId = NodeFactory.createNodeId(MIDDLE_NODE_ID);
      
      BranchID helperNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));
  
      
      IrisNode myNode = (IrisNode)NodeFactory.createNodeWithoutFilter(myNodeId);
      ((IrisNode)myNode).addSyncFilter(new InstantGCProtocol());

      IrisNode helperNode = (IrisNode)NodeFactory.createNodeWithoutFilter(helperNodeId);
      ((IrisNode)helperNode).addSyncFilter(new InstantGCProtocol());

      IrisNode thirdNode = (IrisNode)NodeFactory.createNodeWithoutFilter(thirdNodeId);
      ((IrisNode)thirdNode).addSyncFilter(new InstantGCProtocol());

      IrisNode fourthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(25));
      ((IrisNode)fourthNode).addSyncFilter(new InstantGCProtocol());

      IrisNode fifthNode = (IrisNode)NodeFactory.createNodeWithoutFilter(NodeFactory.createNodeId(30));
      ((IrisNode)fifthNode).addSyncFilter(new InstantGCProtocol());

      //second set of writes
      
      if(verbose){
        System.out.println("Hello from SimulatorUnit");
      }

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      write(myNode, COARSE_PATH, 0, ni-1, 0);
      checkRead(myNode, COARSE_PATH, 0, ni-1, 0);

      assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
      assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));


      ni=10;
      int numForks = 2;
      LinkedList<Node> forkedPseudoNodes = myNode.fork(numForks);
      
      assert forkedPseudoNodes.size() == numForks;
      int i = 0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 0);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 0);
        i++;
      }
      
      
      helperNode.sync(forkedPseudoNodes.get(0));
      thirdNode.sync(forkedPseudoNodes.get(1));
      if(!SangminConfig.useSimulatorId){
        ((IrisNode)helperNode).exponentialBackoffSync(thirdNode);
      }
      helperNode.sync(thirdNode);
      thirdNode.sync(helperNode);
      
      checkRead(helperNode, COARSE_PATH, 0, 4, 0);
      checkRead(helperNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(helperNode, COARSE_PATH+1, 5, ni-1, 0);
      
      
      checkRead(thirdNode, COARSE_PATH, 0, 4, 0);
      checkRead(thirdNode, COARSE_PATH+0, 5, ni-1, 0);
      checkRead(thirdNode, COARSE_PATH+1, 5, ni-1, 0);

      HashMap<BranchID, TreeSet<PreciseInv>> acceptedWrites = thirdNode.getAcceptedForkedWrites(myNodeId);

      i=0;
      for(Node n1: forkedPseudoNodes){
        IrisNode n = (IrisNode)n1;
        checkRead(n, COARSE_PATH, 0, 4, 0);
        write(n, COARSE_PATH+i, 5, ni-1, 10);
        checkRead(n, COARSE_PATH+i, 5, ni-1, 10);
        i++;
      }
      
      fourthNode.sync(forkedPseudoNodes.get(0));
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 10);
      
      
      fifthNode.sync(forkedPseudoNodes.get(1));
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);

      if(!SangminConfig.useSimulatorId){
        ((IrisNode)fourthNode).exponentialBackoffSync(fifthNode);
      }
      fourthNode.sync(fifthNode);
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1,10);

      fifthNode.sync(fourthNode);
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fifthNode, COARSE_PATH+0, 5, ni-1,10);

      fifthNode.garbageCollect(fifthNode.getCurrentVV());
      EvictionCertificate ec = new EvictionCertificate(myNode.getBranchID().getBaseId(), acceptedWrites, 2);
      
      fifthNode.addCertificate(ec);
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fifthNode, COARSE_PATH+0, 5, ni-1,10);
      
      thirdNode.sync(fifthNode);
      checkRead(fifthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fifthNode, COARSE_PATH+1, 5, ni-1, 10);
      checkRead(fifthNode, COARSE_PATH+0, 5, ni-1,10);
      
      helperNode.sync(fifthNode);
      checkRead(helperNode, COARSE_PATH, 0, 4, 0);
      checkRead(helperNode, COARSE_PATH+0, 5, ni-1, 10);
      checkRead(helperNode, COARSE_PATH+1, 5, ni-1, 10);
      
      fourthNode.sync(fifthNode);
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 10);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 10);
      
      fourthNode.sync(forkedPseudoNodes.get(0));
      checkRead(fourthNode, COARSE_PATH, 0, 4, 0);
      checkRead(fourthNode, COARSE_PATH+0, 5, ni-1, 10);
      checkRead(fourthNode, COARSE_PATH+1, 5, ni-1, 10);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
  }
  
  public static void checkRead(IrisNode n, 
      String prefix, 
      int is, int ie, int startVal){
      int ii;

    if(vverbose){
      System.out.println("Reading initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Reading " + oid);
      }
      assert n.read(oid).equals(startVal + ii): "Expected value for obj " + oid + " was " + (startVal + ii) + " instead found " + n.read(oid);
    }
  }

 /** 
 *  Write -- write 1-byte items to /prefix/[is..ie]/[js..je]/[ks..ke].
 
 *  Return final accept stamp.
 
 **/ 
  public static void write(IrisNode n, 
                           String prefix, 
                           int is, int ie, 
                           int startVal){
    int ii;

    if(vverbose){
      System.out.println("Writing initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Writing " + oid);
      }
     
      n.write(oid, new IrisDataObject(new Integer(startVal + ii)));
    }
  }
    

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(RollbackUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoIrisNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "RollbackUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}



