package code.simulator.unit;

import code.branchDetecting.BranchID;
import code.simulator.*;
import code.simulator.SyncRequest;
import code.*;
import code.security.SangminConfig;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.client.ClientNode;
import code.untrustedstorage.writeanyreadany.client.ClientNodeWrapper;

/** 
 *  Test bandwidth to subscribe to 1000 objects, 100 of which have

 *  been modified. Test created for sosp 2007 submission microbenchmark.

 **/ 

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 * 
 * This differs from SimulatorUnit.
 * In particular, dotestFaultSecurity().
 * Nodes in the test sync each other through network
 * where as in the SimulatorUnit they sync using sync() function call.
 * 
 */
public class SimulatorUnit2 extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  String configpath = "./branchtestconfig";
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public SimulatorUnit2 (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    makeDummyConfig(configpath, 50);
  }


  public static int UNIT_NODE_ID = 10;
  public static int MIDDLE_NODE_ID = 15;

  public static int HELPER_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;


  public static String COARSE_PATH = "/coarse";

  protected static void  makeDummyConfig(String path, int nNodes){

    // System.out.println("DBG: user.dir = " //MDD Debug jswat working dir
    // + System.getProperties().getProperty("user.dir")); 

    Config.createEmptyConfig();

    for(int i=0; i < nNodes; i++){
      NodeId id = new NodeId(NodeFactory.createNodeId(i).getIDint());
      Config.addOneNodeConfig(id, "localhost",
          4778+i, 3588+i, 4588+i, 5588+i, 6588+i, 
          "testBranchManager_"+i+".db", "/*", -1, 
          "localhost.cs.utexas.edu", 7078+i, 7578+i, -1,Config.CACHE_SIZE_BYTES_DEFAULT,
          Config.MAX_LOG_DISK_SIZE_BYTES, Config.MAX_LOG_MEM_SIZE_BYTES);
    }
    System.out.println("Config file for " + Config.getNumNodes() + " nodes created");
    Config.writeToFile(path);
    Config.readConfig(path);
    Config.publicKeys.get(10);
  }

  public void dtestBenchmark(){
    SangminConfig.usePersistentStore = true;
    Node.useSignature = true;
    BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);

    ResultStats rs = new ResultStats();
    if(vverbose){
      System.out.println("UNIT ID: " + myNodeId.toString());
    }
    assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));

    Node myNode = NodeFactory.createNodeWithoutFilter(myNodeId);

    byte[] data = new byte[StorageConfig.objSize];

    for(int i=0; i < data.length; i++){
      data[i] = (byte) i;
    }

    if(verbose){
      System.out.println("Hello from SimulatorUnit2");
    }


    long t1, t2;

    ObjId oid;
    t1 = System.currentTimeMillis();

    for(int i=0; i<StorageConfig.numObjs ; i++){
      long tt1 = System.currentTimeMillis();

      oid = new ObjId(ClientNodeWrapper.getKeyString(i));
      //oid = new ObjId("/" + String.format("%31d", i));
      data[0] = (byte)myNodeId.getIDint();
      data[1] = (byte)t1;
      data[2] = (byte)Long.rotateRight(t1, 8);
      myNode.write(oid, new IrisDataObject(data));
      long tt2 = System.currentTimeMillis();
      rs.enter(tt2-tt1);

    }

    t2 = System.currentTimeMillis();
    System.out.println(StorageConfig.numObjs + " writes took " + (t2-t1));
    System.out.println("avg" + rs.getMean(0));
    System.out.println("90%" + rs.getAverage90());
    System.out.println("std" + rs.getStandardDeviation(0));
    System.out.println(StorageConfig.numObjs + " writes took " + (t2-t1));
}


  //--------------------------------------------------------------------------- 
  // Test coarse-grained subscriptions. 
  //
  // To initialize state, Unit create 1000 objects
  // (/data-coarse/[0..9]/[0..9]/[0..9]. Then helper subscribe
  // to /* from unit and wait for /data-coarse/9/9/9 to arrive.
  //
  //
  // start helper and wait for writing to complete
  //---------------------------------------------------------------------------
  public void testSimple(){
    try{
      System.out.println("testSimple");

      BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);

      BranchID helperNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));

      Node myNode = NodeFactory.createNodeWithoutFilter(myNodeId);
      Node helperNode = NodeFactory.createNodeWithoutFilter(helperNodeId);

      //second set of writes

      if(verbose){
        System.out.println("Hello from SimulatorUnit2");
      }

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      SimulatorUnit.write(myNode, COARSE_PATH, 0, ni-1, 0);
      SimulatorUnit.checkRead(myNode, COARSE_PATH, 0, ni-1, 0);
      SyncRequest sr = new SyncRequest(new AcceptVV(), 0, new HashSet<ProofOfMisbehavior> (), myNode.getBranchID().getIDint(), SangminConfig.BodyConfig, false);
      SyncPacket sp = ((IrisNode)myNode).getSyncPacket(sr);
      SyncStatus ss = ((IrisNode)myNode).applySyncPacket(sp);
      System.out.println(ss);
      assert ss.status == SyncStatus.SyncSuccessful;

      assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
      assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));

      ((IrisNode)helperNode).exponentialBackoffSync(myNode.getBranchID(),
          helperNode.getCurrentVV());


      SimulatorUnit.checkRead(helperNode, COARSE_PATH, 0, ni-1, 0);

      // now do writes at helper node and sync with the main node

      SimulatorUnit.write(helperNode, COARSE_PATH, 0, ni-1, 10);
      SimulatorUnit.checkRead(helperNode, COARSE_PATH, 0, ni-1, 10);

      assert helperNode.getCurrentVV().includes(new AcceptStamp(ni-1+5, helperNodeId));
      assert !helperNode.getCurrentVV().includes(new AcceptStamp(ni+5, helperNodeId));

      ((IrisNode)myNode).exponentialBackoffSync(helperNode.getBranchID(),
          myNode.getCurrentVV());
      //myNode.sync(helperNode);
      SimulatorUnit.checkRead(myNode, COARSE_PATH, 0, ni-1, 10);

      System.out.println("TEST COMPLETE");
      Thread.sleep(2000);
      myNode.close();
      helperNode.close();


    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }finally{

    }

  }

  public void testForkSecurity(){
    //  if(Node.enableSecurity){
    //    return;
    //  }
    try{
      try{
        Thread.sleep(1000);
      }catch(Exception e){
        e.printStackTrace();
      }
      System.out.println("testForkSecurity");
      BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);
      BranchID thirdNodeId = NodeFactory.createNodeId(MIDDLE_NODE_ID);

      BranchID helperNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));

      Node myNode = NodeFactory.createNodeWithoutFilter(myNodeId);
      Node helperNode = NodeFactory.createNodeWithoutFilter(helperNodeId);
      Node thirdNode = NodeFactory.createNodeWithoutFilter(thirdNodeId);

      //second set of writes

      if(verbose){
        System.out.println("Hello from SimulatorUnit2");
      }

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      System.out.println("Round " + 0 + " --------");

      int ni = 1;
      SimulatorUnit.write(myNode, COARSE_PATH, 0, ni-1, 0);

      int numForks = 2;
      //LinkedList<Node> forkedPseudoNodes = myNode.fork(numForks);

      BranchID forkedID1 = NodeFactory.createNodeId(UNIT_NODE_ID+1);
      Node forkedNode1 = NodeFactory.createIrisNode(myNodeId,forkedID1);
      BranchID forkedID2 = NodeFactory.createNodeId(UNIT_NODE_ID+2);
      Node forkedNode2 = NodeFactory.createIrisNode(myNodeId,forkedID2);
      forkedNode1.sync(myNode);
      forkedNode2.sync(myNode);


      //assert forkedPseudoNodes.size() == numForks;

      int MAX = 5;

      //SimulatorUnit.write(forkedPseudoNodes.get(0), COARSE_PATH, 0, ni-1, 0);
      //SimulatorUnit.write(forkedPseudoNodes.get(1), COARSE_PATH, 0, ni-1, 100);
      SimulatorUnit.write(forkedNode1, COARSE_PATH, 0, ni-1, 0);
      SimulatorUnit.write(forkedNode2, COARSE_PATH, 0, ni-1, 100);
      //helperNode.sync(forkedPseudoNodes.get(0));  
      //thirdNode.sync(forkedPseudoNodes.get(1));
      ((IrisNode)helperNode).exponentialBackoffSync(forkedID1, helperNode.getCurrentVV());  
      ((IrisNode)thirdNode).exponentialBackoffSync(forkedID2, thirdNode.getCurrentVV());


      if(!SangminConfig.useSimulatorId){
        ((IrisNode)thirdNode).exponentialBackoffSync(helperNode.getBranchID(),thirdNode.getCurrentVV());
        ((IrisNode)thirdNode).exponentialBackoffSync(helperNode.getBranchID(),thirdNode.getCurrentVV());
      }
      if(!SangminConfig.useSimulatorId){
        ((IrisNode)helperNode).exponentialBackoffSync(thirdNode.getBranchID(), helperNode.getCurrentVV());
        ((IrisNode)helperNode).exponentialBackoffSync(thirdNode.getBranchID(), helperNode.getCurrentVV());
      }

      SimulatorUnit.printRead(helperNode, COARSE_PATH, 0, ni-1);
      SimulatorUnit.printRead(thirdNode, COARSE_PATH, 0, ni-1);


      for(int i = 0; i < MAX; i++){
        System.out.println("Round " + (i+1) + " --------");

        int value = (i+1)*ni;
        int value1 = MAX-value;
        //    SimulatorUnit.write(forkedPseudoNodes.get(0), COARSE_PATH, 0, ni-1, value);
        //    SimulatorUnit.write(forkedPseudoNodes.get(1), COARSE_PATH, 0, ni-1, value1);
        SimulatorUnit.write(forkedNode1, COARSE_PATH, 0, ni-1, value);
        SimulatorUnit.write(forkedNode2, COARSE_PATH, 0, ni-1, value1);

        //((IrisNode)helperNode).exponentialBackoffSync(forkedPseudoNodes.get(0).getBranchID(), helperNode.getCurrentVV());    
        //((IrisNode)thirdNode).exponentialBackoffSync(forkedPseudoNodes.get(1).getBranchID(), thirdNode.getCurrentVV());
        ((IrisNode)helperNode).exponentialBackoffSync(forkedID1, helperNode.getCurrentVV());  
        ((IrisNode)thirdNode).exponentialBackoffSync(forkedID2, thirdNode.getCurrentVV());

        if(!SangminConfig.useSimulatorId){
          ((IrisNode)thirdNode).exponentialBackoffSync(helperNode.getBranchID(),thirdNode.getCurrentVV());
          ((IrisNode)thirdNode).exponentialBackoffSync(helperNode.getBranchID(),thirdNode.getCurrentVV());
        }
        if(!SangminConfig.useSimulatorId){
          ((IrisNode)helperNode).exponentialBackoffSync(thirdNode.getBranchID(), helperNode.getCurrentVV());
          ((IrisNode)helperNode).exponentialBackoffSync(thirdNode.getBranchID(), helperNode.getCurrentVV());
        }
        //SimulatorUnit.printRead(forkedPseudoNodes.get(0), COARSE_PATH, 0, ni-1);
        //SimulatorUnit.printRead(forkedPseudoNodes.get(1), COARSE_PATH, 0, ni-1);
        SimulatorUnit.printRead(helperNode, COARSE_PATH, 0, ni-1);
        SimulatorUnit.printRead(thirdNode, COARSE_PATH, 0, ni-1);

      }
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SimulatorUnit2.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SimulatorUnit2";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}




