package code.untrustedstorage.writeanyreadany;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

import code.ObjId;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.IrisHashObject;
import code.simulator.IrisObject;


public class BodyRequestData implements Externalizable, IrisSerializable{
  final public static String DIGEST_ALGORITHM = "MD5";
  final public static int DIGEST_SIZE = 2;
  private ObjId oid;
//  public List<IrisHashObject> hashObjList;
  private byte[] digest; // 
  
  public BodyRequestData(){
    
  }
  
  public BodyRequestData(ObjId oid, List<IrisHashObject> list){
    this.oid = oid;
    
    
    if(StorageConfig.S3Emulation){
      assert list == null;
      this.digest = null;
      return;
    }   
    this.digest = getCompactHashUsingIrisHashObject(list);
    
  }
  
  public static byte[] getCompactHashUsingIrisHashObject(List<IrisHashObject> list){
    assert list.size() > 0; // since if we didn't have no hash, we would have done sync to a server immediately
    LinkedList<Hash> set = new LinkedList<Hash>();
    for(IrisHashObject iho : list){
      set.add(iho.getHash());
    }
    return getCompactHashHelper(set);
  }
  
  public static byte[] getCompactHashUsingIrisObject(List<IrisObject> list){
    assert list.size() > 0; // since if we didn't have no hash, we would have done sync to a server immediately
    LinkedList<Hash> set = new LinkedList<Hash>();
    for(IrisObject iho : list){
      set.add(iho.getHash());
    }
    return getCompactHashHelper(set);
  }
  
  public static byte[] getCompactHashHelper(List<Hash> set){
    byte [] digest = new byte[DIGEST_SIZE];
    assert set.size() > 0; // since if we didn't have no hash, we would have done sync to a server immediately
    Collections.sort(set);
    MessageDigest md5=null;
    try{
      md5 = MessageDigest.getInstance(DIGEST_ALGORITHM);
    }catch(NoSuchAlgorithmException e){
      e.printStackTrace();
      System.exit(-1);
    }
    md5.reset();
    for(Hash h : set){
      md5.update(h.getHashVal());
    }
    byte[] long_digest = md5.digest();
    for(int i=0; i < DIGEST_SIZE; i++){
      digest[i] = long_digest[i];
    }
    return digest;
  }
  
  public ObjId getObjId(){
    return oid;
  }
  
  public byte[] getDigest(){
    return digest;
  }
  
  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + Arrays.hashCode(digest);
    result = prime * result + ((oid == null) ? 0 : oid.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj)
      return true;
    if(obj == null)
      return false;
    if(getClass() != obj.getClass())
      return false;
    BodyRequestData other = (BodyRequestData) obj;
    if(!Arrays.equals(digest, other.digest))
      return false;
    if(oid == null){
      if(other.oid != null)
        return false;
    }else if(!oid.equals(other.oid))
      return false;
    return true;
  }

  public void readExternal(ObjectInput in) throws IOException,
      ClassNotFoundException{
    
    String str = SerializationHelper.readShortString(in);
    ObjId objId = new ObjId(str);
    
    
    byte[] _digest;
    if(StorageConfig.S3Emulation){
      _digest = null;
    } else {
      _digest = new byte[DIGEST_SIZE];
      in.readFully(_digest);
    }
    
    
//    int size = in.readInt();
//    LinkedList<IrisHashObject> list = new LinkedList<IrisHashObject>();
//    for(int i=0; i<size; i++){
//      byte[] hass = new byte[Hash.Length];
//      in.readFully(hass);
//      list.add(new IrisHashObject(new Hash(hass, false)));
//    }
    
    
    Field[] f = new Field[2];

    try{
      f[0] = BodyRequestData.class.getDeclaredField("oid");
      f[1] = BodyRequestData.class.getDeclaredField("digest");
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, objId);
      f[1].set(this, _digest);
    }catch(Exception ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    
    
    
  }

  public void writeExternal(ObjectOutput out) throws IOException{
    
    SerializationHelper.writeShortString(this.oid.getPath(), out);
    
    out.write(digest);
//    out.writeInt(hashObjList.size());
//    for(IrisHashObject iho : hashObjList){
//      out.write(iho.getHash().getHashVal());
//    }
    
  }
  
  public static void main(String args[]){
    
    ObjId oid = new ObjId("/asdfsdf");
    byte[] hash = new byte[Hash.Length];
    LinkedList<IrisHashObject> ll = new LinkedList<IrisHashObject>();
    
    for( int k=0; k < 10; k++){
      for(int i=0; i < hash.length; i++){
        hash[i] = (byte)(i+k);
      }

      ll.add(new IrisHashObject(new Hash(hash, false)));
    }
    BodyRequestData brd = new BodyRequestData(oid, ll);
    
    try{
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      IrisOutputStream ios = new IrisOutputStream(bos);
      //      ios.writeObject(rep);
      brd.writeToStream(ios, false);
//      ios.flush();
      
      IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bos.toByteArray()));
      BodyRequestData req2 = new BodyRequestData();
      req2.readFromStream(ois, false);

      if(brd.equals(req2)){
        System.out.println("SUCCESS");
      } else {
        System.out.println("FAIL");
      }
      
//      ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
//      brd.writeToStream(bos2);
//      
//      ByteArrayInputStream ios2= new ByteArrayInputStream(bos2.toByteArray());
//      BodyRequestData brd3 = new BodyRequestData();
//      brd3.readFromStream(ios2);
//      
//      if(brd.equals(brd3)){
//        System.out.println("SUCCESS");
//      } else {
//        System.out.println("FAIL");
//      }
      
      
      

    } catch(Exception e){
      e.printStackTrace();
    }
    
  }
//
//  @Override
//  public int readFromStream(InputStream is) throws IOException{
//    int len = is.read();
//    assert len >= 0;
//    byte[] b = new byte[len];
//    SerializationHelper.readFully(is, b);
//    byte[] _digest = new byte[DIGEST_SIZE];
//    SerializationHelper.readFully(is, _digest);
//    this.oid = new ObjId(new String(b));
//    this.digest = _digest;
//    return ( 1 + len + _digest.length);
//  }
//
//  @Override
//  public int writeToStream(OutputStream os) throws IOException{
//    
//    byte[] b = oid.getPath().getBytes();
//    assert b.length < 256;
//    os.write(b.length);
//    os.write(b);
//    os.write(digest);
//    
//    return (1 + b.length + digest.length);
//  }

  public void readFromStream(IrisInputStream in, boolean optimized)
      throws IOException{
//    String str = SerializationHelper.readShortString(in);
    String str = in.readShortString();
    ObjId objId = new ObjId(str);
    this.oid = objId;
    if(StorageConfig.S3Emulation){
      this.digest = null;
      return;
    }
    
    byte[] _digest = new byte[DIGEST_SIZE];
    in.readFully(_digest);        
    this.digest = _digest;
    
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
      throws IOException{

    out.writeShortString(this.oid.getPath());   
    if(StorageConfig.S3Emulation){
      return;
    }
    out.write(digest);
    
  }

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "BodyRequestData [digest=" + Arrays.toString(digest) + ", oid=" + oid + "]";
  }
  
  
}