package code.untrustedstorage.writeanyreadany;

import code.ObjId;
import code.branchDetecting.BranchID;
import code.simulator.protocolFilters.AgreementGCProtocol;

public class NamespaceLayout{

//  final public static String FORCE_OBJ_ROOT="/forceObj";
  
//  final public static String SERVER_ACK_PREFIX = "/server-";
  
  final public static String BEACON_OBJ_ROOT= AgreementGCProtocol.gcProposalDir+"/beaconObj";
  
  final public static String COMMIT_OBJ_ROOT="/commitObj";
  
//  public static String getForceObjID(Object clientID){
//    return FORCE_OBJ_ROOT+"/"+clientID;
//  }
  
  public static String getCommitObjID(Object serverID){
    return COMMIT_OBJ_ROOT + "/" + serverID;
  }
  
  public static String getBeaconObj(int clientId){
    return BEACON_OBJ_ROOT+"/"+clientId;
  }
  
  public static int getServerIdFromCommitObjId(ObjId commitObjId){
    String s = commitObjId.getPath();
    String strID = s.substring(COMMIT_OBJ_ROOT.length() + 1);
    return Integer.parseInt(strID);
    
  }
  
  public static int getServerIdFromBeaconObjId(ObjId beaconObjId){
    String s = beaconObjId.getPath();
    String strID = s.substring(BEACON_OBJ_ROOT.length() + 1);
    return Integer.parseInt(strID);
    
  }
//  public static String getServerAckPath(BranchID serverID){
//    return SERVER_ACK_PREFIX + serverID;
//  }
//  
//  public static String getServerAckPathForClient(BranchID serverID, Object clientID){
//    return getServerAckPath(serverID) + "/" + clientID;
//  }
//
//  public static int getServerIdFromServerAckObjId(ObjId serverAckObjId){
//    String s = serverAckObjId.getPath();
//    int secondSlashIndex = s.indexOf("/", 1);
//    String strId = s.substring(s.indexOf(SERVER_ACK_PREFIX)+SERVER_ACK_PREFIX.length(), secondSlashIndex);
//    return Integer.parseInt(strId);
//  }
//  
}
