package code.untrustedstorage.writeanyreadany;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.TreeSet;

import code.AcceptStamp;
import code.NodeId;
import code.ObjId;
import code.branchDetecting.BranchID;
import code.security.ahs.DependencyVV;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.HashedVV;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.simulator.SecureSimPreciseInv;
import code.simulator.SimPreciseInv;


public class NewWriteRequestData implements Externalizable, IrisSerializable{

  private SimPreciseInv spi;
  private IrisDataObject ido;
  
  public NewWriteRequestData(){
    
  }
  
  public NewWriteRequestData(SimPreciseInv spi, IrisDataObject ido){
    this.spi = spi;
    this.ido = ido;
  }
  
  public SimPreciseInv getInval(){
    return spi;
  }
  
  public IrisDataObject getData(){
    return ido;
  }

  public void readExternal(ObjectInput in) throws IOException,
      ClassNotFoundException{
    SimPreciseInv sspi;
    if(IrisNode.enableSecurity){
      sspi = new SecureSimPreciseInv();
    }else{
      sspi = new SimPreciseInv();
    }
    sspi.readExternal(in);
    
    int size = in.readInt();
    byte[] buf = new byte[size];
    in.readFully(buf);
    IrisDataObject _ido = new IrisDataObject(buf);
    
    Field[] f = new Field[2];

    try{
      f[0] = NewWriteRequestData.class.getDeclaredField("spi");
      f[1] = NewWriteRequestData.class.getDeclaredField("ido");
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, sspi);
      f[1].set(this, _ido);
    }catch(Exception ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    
  }

  public void writeExternal(ObjectOutput out) throws IOException{
    spi.writeExternal(out);
    
    byte[] buf = ido.getUnsafeBytes();
    out.writeInt(buf.length);
    out.write(buf);
    
  } 
  
  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((ido == null) ? 0 : ido.hashCode());
    result = prime * result + ((spi == null) ? 0 : spi.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj)
      return true;
    if(obj == null)
      return false;
    if(getClass() != obj.getClass())
      return false;
    NewWriteRequestData other = (NewWriteRequestData) obj;
    if(ido == null){
      if(other.ido != null)
        return false;
    }else if(!ido.equals(other.ido))
      return false;
    if(spi == null){
      if(other.spi != null)
        return false;
    }else if(!spi.equals(other.spi))
      return false;
    return true;
  }
  
  public static void main(String[] args){
    DependencyVV dvv = new DependencyVV();
    dvv.put(new BranchID(5), 3);
    
    int datasize = 1024*1000;
    byte[] data = new byte[datasize];
    for(int i=0; i < data.length; i++){
      data[i] = (byte) i;
    }
    
    byte[] bytes = new byte[Hash.Length];
    for(int i=0; i<Hash.Length; i++){
      bytes[i] = 'a';
    }

    Hash hash = new Hash(bytes, false);
    HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
    hashes.put(new BranchID(5), hash);
    HashedVV hdvv = new HashedVV(dvv, hashes);

    TreeSet<Hash> objHashes = new TreeSet<Hash>();
    objHashes.add(Hash.NullHash);
    objHashes.add(hash);
    
    IrisDataObject irisData = new IrisDataObject(data);
    SecureSimPreciseInv sspi = new SecureSimPreciseInv(new ObjId("/test"), new AcceptStamp(10,new BranchID(10)), hdvv, irisData , 0, objHashes);

    NewWriteRequestData nwrd = new NewWriteRequestData(sspi, irisData);
    
    try{
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      IrisOutputStream ios = new IrisOutputStream(bos);
      //      ios.writeObject(rep);
      nwrd.writeToStream(ios, false);
      ios.flush();
      
      IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bos.toByteArray()));
      
      NewWriteRequestData nwrd2 = new NewWriteRequestData();
      nwrd2.readFromStream(ois, false);
      
      
      
      
      if(nwrd.equals(nwrd2)){
       System.out.println("SUCCESS"); 
      } else {
        System.out.println("Fail");
      }
//      
//      ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
//      nwrd.writeToStream(baos2, false);
//      baos2.flush();

//      byte[] b2 = baos2.toByteArray();
//      ByteArrayInputStream bais2 = new ByteArrayInputStream(b2);
//
//      NewWriteRequestData nwrd3 = new NewWriteRequestData();
//      
//      nwrd3.readFromStream(bais2);
//      
//      if(nwrd.equals(nwrd3)){
//        System.out.println("SUCCESS"); 
//       } else {
//         System.out.println("Fail");
//       }
    } catch(Exception e){
      e.printStackTrace();
    }
    
    
    
  }

//  @Override
//  public int readFromStream(InputStream is) throws IOException{
//    SimPreciseInv sspi;
//    if(IrisNode.enableSecurity){
//      sspi = new SecureSimPreciseInv();
//    }else{
//      sspi = new SimPreciseInv();
//    }
////    int sspiLen = sspi.readFromStream(is);
//    int sspiLen = 0;
//    
////    byte[] len = new byte[4];
////    SerializationHelper.readFully(is, len);
////    int dataLen = SerializationHelper.getInt(len, 0);
//    
//    int dataLen = SerializationHelper.readInt(is);
//    byte[] data = new byte[dataLen];
//    SerializationHelper.readFully(is, data);
//    
//    this.spi = sspi;
//    this.ido = new IrisDataObject(data);    
//    
//    return (sspiLen + 4 + data.length);
//  }
//
//  @Override
//  public int writeToStream(OutputStream os) throws IOException{
//    
////    int spiLen = spi.writeToStream(os);
//    int spiLen = 0;
//    byte[] b = ido.getUnsafeBytes();
//    SerializationHelper.writeInt(os, b.length);
////    byte[] len = new byte[4];
////    SerializationHelper.putInt(len, 0, b.length);
////    os.write(len);
//    os.write(b);
//    
//    return (spiLen + 4 + b.length);
//  }

  public void readFromStream(IrisInputStream in, boolean optimized)
      throws IOException{
    SimPreciseInv sspi;
    if(IrisNode.enableSecurity){
      sspi = new SecureSimPreciseInv();
    }else{
      sspi = new SimPreciseInv();
    }
    sspi.readFromStream(in, optimized);
    
    int size = in.readInt();
    byte[] buf = new byte[size];
    in.readFully(buf);
    IrisDataObject _ido = new IrisDataObject(buf);
    
    this.spi = sspi;
    this.ido = _ido;
    
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
      throws IOException{
    spi.writeToStream(out, optimized);
    
    byte[] buf = ido.getUnsafeBytes();
    out.writeInt(buf.length);
    out.write(buf);
    
  }

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "NewWriteRequestData [ido=" + ido + ", spi=" + spi + "]";
  }
  
}
