package code.untrustedstorage.writeanyreadany;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

import code.ObjId;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.IrisHashObject;
import code.simulator.IrisObject;


public class P2PBodyRequestData implements IrisSerializable{
  private ObjId oid;
  public LinkedList<IrisHashObject> hashObjList;
 
  public P2PBodyRequestData(){
    
  }
  
  public P2PBodyRequestData(ObjId oid, List<IrisHashObject> hashObjList2){
    this.oid = oid;
    assert hashObjList2.size() > 0; // since if we didn't have no hash, we would have done sync to a server immediately
    this.hashObjList = new LinkedList<IrisHashObject>(hashObjList2);
  }
  
  public ObjId getObjId(){
    return oid;
  }
  
  public LinkedList<IrisHashObject> getHashes(){
    return hashObjList;
  }
  
 

  
  public static void main(String args[]){
    
    ObjId oid = new ObjId("/asdfsdf");
    byte[] hash = new byte[Hash.Length];
    LinkedList<IrisHashObject> ll = new LinkedList<IrisHashObject>();
    
    for( int k=0; k < 10; k++){
      for(int i=0; i < hash.length; i++){
        hash[i] = (byte)(i+k);
      }

      ll.add(new IrisHashObject(new Hash(hash, false)));
    }
    P2PBodyRequestData brd = new P2PBodyRequestData(oid, ll);
    
    try{
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      IrisOutputStream ios = new IrisOutputStream(bos);
      brd.writeToStream(ios, false);
      ios.flush();
      
      IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bos.toByteArray()));
      P2PBodyRequestData req2 = new P2PBodyRequestData();
      req2.readFromStream(ois, false);

      if(brd.equals(req2)){
        System.out.println("SUCCESS");
      } else {
        System.out.println("FAIL");
      }
      
    } catch(Exception e){
      e.printStackTrace();
    }
    
  }


  public void readFromStream(IrisInputStream in, boolean optimized)
      throws IOException{
    String str = in.readShortString();
    this.oid = new ObjId(str);
    this.hashObjList = new LinkedList<IrisHashObject>();
    int size = in.readInt();
    for(int i = 0; i < size; i++){
      byte[] buf = new byte[Hash.Length];
      in.readFully(buf);
      hashObjList.add(new IrisHashObject(new Hash(buf, false)));
    }
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
      throws IOException{
    out.writeShortString(this.oid.getPath());   
    out.writeInt(this.hashObjList.size());
    for(IrisObject iho: hashObjList){
      out.write(iho.getHash().getHashVal());
    }
  }

  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result
        + ((hashObjList == null) ? 0 : hashObjList.hashCode());
    result = prime * result + ((oid == null) ? 0 : oid.hashCode());
    return result;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof P2PBodyRequestData)){
      return false;
    }
    P2PBodyRequestData other = (P2PBodyRequestData) obj;
    if(hashObjList == null){
      if(other.hashObjList != null){
        return false;
      }
    }else if(!hashObjList.equals(other.hashObjList)){
      return false;
    }
    if(oid == null){
      if(other.oid != null){
        return false;
      }
    }else if(!oid.equals(other.oid)){
      return false;
    }
    return true;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "P2PBodyRequestData [hashObjList=" + hashObjList + ", oid=" + oid
        + "]";
  }
  
  
}