package code.untrustedstorage.writeanyreadany;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.LinkedList;

import code.Env;
import code.ResultStats;
import code.security.SangminConfig;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.HashedVV;
import code.simulator.IrisDataObject;
import code.simulator.IrisObject;
import code.simulator.Node;
import code.simulator.SimPreciseInv;
import code.simulator.agreement.Tuple;
import code.simulator.protocolFilters.AgreementGCProtocol;
import code.untrustedstorage.writeanyreadany.Request.RequestType;

public class Reply implements IrisSerializable{
  
  private RequestType type;
  private Object data;
  
  public Reply(RequestType type, Object data){
    this.type = type;
    this.data = data;
  }
  
  public Reply(){
    
  }

  public RequestType getType(){
    return type;
  }
  public Object getData(){
    return data;
  }
  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((data == null) ? 0 : data.hashCode());
    result = prime * result + ((type == null) ? 0 : type.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj)
      return true;
    if(obj == null)
      return false;
    if(getClass() != obj.getClass())
      return false;
    Reply other = (Reply) obj;
    if(data == null){
      if(other.data != null)
        return false;
    }else if(!data.equals(other.data))
      return false;
    if(type == null){
      if(other.type != null)
        return false;
    }else if(!type.equals(other.type))
      return false;
    return true;
  }

 
  public static void main(String[] args) throws IOException, ClassNotFoundException{
    StorageConfig.objSize = 3;
    
    byte[] data = new byte[StorageConfig.objSize];
    for(int i=0; i < StorageConfig.objSize; i++){
      data[i] = (byte)i;
    }

    IrisDataObject ido = new IrisDataObject(data);
    LinkedList<IrisDataObject> ll = new LinkedList<IrisDataObject>();
    ll.add(ido);

    Reply rep = new Reply(RequestType.REQUEST_BODY, ll);

    ResultStats stats1 = new ResultStats();
    ResultStats stats2 = new ResultStats();
    for(int i=0; i<1; i++){

      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      IrisOutputStream ios = new IrisOutputStream(baos);
      rep.writeToStream(ios, false);
      ios.flush();

      byte[] b = baos.toByteArray();
      System.out.println("serialized " + StorageConfig.objSize + "  objects " + b.length);
      ByteArrayInputStream bais = new ByteArrayInputStream(b);  

      Reply rep2 = new Reply();
      long t1 = System.currentTimeMillis();

      rep2.readFromStream(new IrisInputStream(bais), false);


      stats1.enter((System.currentTimeMillis() - t1));
      if(!rep2.equals(rep)){
        System.err.println("REP2 WRONG rep " + rep + " rep2 " + rep2);
        System.exit(-1);
      }
      
//      ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
//      rep.writeToStream(baos2);
//      baos2.flush();
//
//      byte[] b2 = baos2.toByteArray();
//      ByteArrayInputStream bais2 = new ByteArrayInputStream(b2);
//
//      Reply rep3 = new Reply();
//      long t2 = System.currentTimeMillis();
//      rep3.readFromStream(bais2);
//      stats2.enter((System.currentTimeMillis() - t2));
//      if(!rep3.equals(rep)){
//        System.err.println("REP3 WRONG");
//        System.exit(-1);
//      }

    }
    System.out.println("SUCCESS");
    System.out.println(stats1.getAverage90());
    System.out.println(stats1.getSummary(0));
    System.out.println(stats2.getAverage90());
    System.out.println(stats2.getSummary(0));
    
  }

//  @Override
//  public int readFromStream(InputStream is) throws IOException{
//    int dataLen = 0;
//    
//    int t = is.read();
//    if(t == 0){
//      this.type = RequestType.NEW_WRITES;
//      data = null;
//    } else {
//      this.type = RequestType.REQUEST_BODY;
//      LinkedList<IrisObject> ll = new LinkedList<IrisObject>();
//      int numObj = is.read();
//      dataLen += 1;
//      for(int i=0; i <numObj; i++){
////        byte[] len = new byte[4];
////        SerializationHelper.readFully(is, len);
//        dataLen += 4;
////        int size = SerializationHelper.getInt(len, 0);
//        int size = SerializationHelper.readInt(is);
//        byte[] buf = new byte[size];
//        SerializationHelper.readFully(is, buf);
//        dataLen += size;
//        ll.add( new IrisDataObject(buf));
//      }
//      this.data = ll;
//    }
//    
//    return (1+dataLen);
//  }

//  @Override
//  public int writeToStream(OutputStream os) throws IOException{
//    int dataLen = 0;
//    if(type == RequestType.NEW_WRITES){
//      os.write(0);
//
//    } else {
//      os.write(1);
//
//      LinkedList<IrisObject> list = (LinkedList<IrisObject>)data;
//      assert list.size() < 256;
//      byte numObj = (byte)list.size();
//      os.write(numObj);
//      dataLen += 1;
//      for(IrisObject ido : list){
//        byte[] buf = ((IrisDataObject)ido).getUnsafeBytes();
////        byte[] len = SerializationHelper.getBytesFromInt(buf.length);
////        os.write(len);
//        SerializationHelper.writeInt(os, buf.length);
//        os.write(buf);
//        dataLen += (buf.length + 4);
//      }
//
//    }
//    
//    return (1 + dataLen);
//  }

  public void readFromStream(IrisInputStream in, boolean optimized)
      throws IOException{
    byte t = in.readByte();
    RequestType _type = null;
    Object _data = null;
    if(t == 0){
      _type = RequestType.NEW_WRITES;      
    } else if(t == 1) {
      _type = RequestType.REQUEST_BODY;      
    } else if(t == 2) {
      _type = RequestType.REQUEST_P2P_BODY;      
    } else {
      assert false : "WRONG VALUE : " + t;
    }

    if(_type == RequestType.REQUEST_BODY || _type == RequestType.REQUEST_P2P_BODY){
      LinkedList<IrisObject> ll = new LinkedList<IrisObject>();
      int len = in.readByte();
      for(int i=0; i <len; i++){
        int size = in.readInt();
        byte[] buf = new byte[size];
        in.readFully(buf);
        ll.add( new IrisDataObject(buf));
      }
      _data = ll;
    }else{
      boolean res  = in.readBoolean();
      if(SangminConfig.echoWrittenObject){
        int size = in.readInt();
        byte []buf = new byte[size];
        in.readFully(buf);
        IrisDataObject d = new IrisDataObject(buf);
        _data = new Tuple<Boolean, IrisDataObject>(res, d);
      }else{
        _data = res;
      }
    }
    this.data = _data;
    this.type = _type;
    
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
      throws IOException{
    if(type == RequestType.NEW_WRITES){
      out.writeByte((byte)0);
      if(SangminConfig.echoWrittenObject){
        Tuple<Boolean, IrisDataObject> t = (Tuple<Boolean, IrisDataObject>)this.data;
        out.writeBoolean(t.getKey());
        out.writeInt(t.getValue().getUnsafeBytes().length);
        out.write(t.getValue().getUnsafeBytes());
      }else{
        out.writeBoolean((Boolean)this.data);
      }
    } else{
      if(type == RequestType.REQUEST_BODY){
        out.writeByte((byte)1);
      } else if(type == RequestType.REQUEST_P2P_BODY){
        out.writeByte((byte)2);
      }else{
        assert false:"unrecognized message type";
      }

      LinkedList<IrisObject> list = (LinkedList<IrisObject>)data;
      assert list.size() < 256;
      out.writeByte((byte)list.size());
      for(IrisObject ido : list){
        byte[] buf = ((IrisDataObject)ido).getUnsafeBytes();
        out.writeInt(buf.length);
        out.write(buf);
      }            
    }
  }

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "Reply [data=" + data + ", type=" + type + "]";
  }


}
