package code.untrustedstorage.writeanyreadany;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.TreeSet;

import code.AcceptStamp;
import code.NodeId;
import code.ObjId;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.security.ahs.DependencyVV;
import code.serialization.IrisInputStream;
import code.serialization.IrisObjectInputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.simulator.Hash;
import code.simulator.HashedVV;
import code.simulator.IrisDataObject;
import code.simulator.IrisObject;
import code.simulator.SecureSimPreciseInv;
import code.simulator.SimPreciseInv;
import code.simulator.log.Log;
import code.simulator.protocolFilters.AgreementGCProtocol;

public class Request implements IrisSerializable{ //Externalizable

  public enum RequestType {NEW_WRITES, REQUEST_BODY, REQUEST_P2P_BODY};

  public RequestType type;
  public Object data;

  public Request(){

  }
  public Request(RequestType type, Object data){
    this.type = type;
    this.data = data;
  }

//  public void readExternal(ObjectInput in) throws IOException,
//  ClassNotFoundException{
//    byte t = in.readByte();
//    Object _data;
//    RequestType _type;
//    if(t==0){
//      _type = RequestType.NEW_WRITES; 
//      if(StorageConfig.S3Emulation){
//        S3Inval s3inval = new S3Inval();
//        s3inval.readExternal(in);
//        _data = s3inval;
//      }else{
//        NewWriteRequestData nwrd = new NewWriteRequestData();
//        nwrd.readExternal(in);
//        _data = nwrd;
//      }
//    } else {
//      if(t==1){
//        _type = RequestType.REQUEST_BODY;
//      }else{
//        _type = RequestType.REQUEST_P2P_BODY;
//      }
//      BodyRequestData brd = new BodyRequestData();
//      brd.readExternal(in);
//      _data = brd;      
//    }
//
//    Field[] f = new Field[2];
//
//    try{
//      f[0] = Request.class.getDeclaredField("type");
//      f[1] = Request.class.getDeclaredField("data");
//    }catch(NoSuchFieldException ne){
//      System.err.println(ne.toString());
//      ne.printStackTrace();
//      System.exit(-1);
//    }
//    try{
//      AccessibleObject.setAccessible(f, true);
//    } catch (SecurityException se){
//      System.err.println(se.toString());
//      se.printStackTrace();
//      System.exit(-1);
//    }
//    try{
//      f[0].set(this, _type);
//      f[1].set(this, _data);
//    }catch(Exception ie){
//      System.err.println(ie.toString());
//      ie.printStackTrace();
//      System.exit(-1);
//    }
//    try{
//      AccessibleObject.setAccessible(f, false);
//    } catch (SecurityException se){
//      System.err.println(se.toString());
//      se.printStackTrace();
//      System.exit(-1);
//    }
//
//  }
//
//  public void writeExternal(ObjectOutput out) throws IOException{
//
//    if(type == RequestType.NEW_WRITES){
//      out.writeByte(0);
//      if(StorageConfig.S3Emulation){
//        S3Inval s3inval = (S3Inval)this.data;
//        s3inval.writeExternal(out);
//      } else {
//        NewWriteRequestData nwrd = (NewWriteRequestData) this.data;
//        nwrd.writeExternal(out);
//      }
//    } else {
//      if(type == RequestType.REQUEST_BODY){
//        out.writeByte(1);
//      }else{
//        out.writeByte(2);
//      }
//      BodyRequestData brd = (BodyRequestData) this.data;
//      brd.writeExternal(out);      
//    }
//
//  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((data == null) ? 0 : data.hashCode());
    result = prime * result + ((type == null) ? 0 : type.hashCode());
    return result;
  }
  @Override
  public boolean equals(Object obj){
    if(this == obj)
      return true;
    if(obj == null)
      return false;
    if(getClass() != obj.getClass())
      return false;
    Request other = (Request) obj;
    if(data == null){
      if(other.data != null)
        return false;
    }else if(!data.equals(other.data))
      return false;
    if(type == null){
      if(other.type != null)
        return false;
    }else if(!type.equals(other.type))
      return false;
    return true;
  }

  public static void main(String[] args){


    DependencyVV dvv = new DependencyVV();
    dvv.put(new BranchID(5), 3);
    String data = "data";
    byte[] bytes = new byte[Hash.Length];
    for(int i=0; i<Hash.Length; i++){
      bytes[i] = 'a';
    }

    Hash hash = new Hash(bytes, false);
    HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
    hashes.put(new BranchID(5), hash);
    HashedVV hdvv = new HashedVV(dvv, hashes);

    TreeSet<Hash> objHashes = new TreeSet<Hash>();
    objHashes.add(Hash.NullHash);
    objHashes.add(hash);

    IrisDataObject irisData = new IrisDataObject(data.getBytes());
    SecureSimPreciseInv sspi = new SecureSimPreciseInv(new ObjId("/test"), new AcceptStamp(10,new BranchID(10)), hdvv, irisData , 0, objHashes);

    NewWriteRequestData nwrd = new NewWriteRequestData(sspi, irisData);
    Request req = new Request(RequestType.NEW_WRITES, nwrd);

    try{
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      IrisOutputStream ios = new IrisOutputStream(bos);
      //      ios.writeObject(rep);
      req.writeToStream(ios, false);
      //      ios.flush();

      IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bos.toByteArray()));
      Request req2 = new Request();
      req2.readFromStream(ois, false);

      if(req.equals(req2)){
        System.out.println("SUCCESS");
      } else {
        System.out.println("FAIL");
      }
      //      
      //      ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
      //      req.writeToStream(bos2);
      //      
      //      ByteArrayInputStream ios2= new ByteArrayInputStream(bos2.toByteArray());
      //      Request req3 = new Request();
      //      req3.readFromStream(ios2);
      //      
      //      if(req.equals(req3)){
      //        System.out.println("SUCCESS");
      //      } else {
      //        System.out.println("FAIL");
      //      }



    } catch(Exception e){
      e.printStackTrace();
    }

  }
  //  @Override
  //  public int readFromStream(InputStream is) throws IOException{
  //    int t = is.read();
  //    int dataLen;
  //    if(t==0){
  //      this.type = RequestType.NEW_WRITES; 
  //      NewWriteRequestData nwrd = new NewWriteRequestData();
  //      dataLen = nwrd.readFromStream(is);
  //      this.data = nwrd;
  //    } else {
  //      this.type = RequestType.REQUEST_BODY;
  //      BodyRequestData brd = new BodyRequestData();
  //      dataLen = brd.readFromStream(is);
  //      this.data = brd;      
  //    }
  //    return (dataLen +1);
  //  }
  //  @Override
  //  public int writeToStream(OutputStream os) throws IOException{
  //    int dataLen;
  //    if(type == RequestType.NEW_WRITES){
  //      os.write(0);
  //      NewWriteRequestData nwrd = (NewWriteRequestData) this.data;
  //      dataLen = nwrd.writeToStream(os);    
  //    } else {
  //      os.write(1);
  //      BodyRequestData brd = (BodyRequestData) this.data;
  //      dataLen = brd.writeToStream(os);     
  //    }
  //    return (1 + dataLen);
  //  }
  public void readFromStream(IrisInputStream in, boolean optimized)
  throws IOException{
    if(SangminConfig.sanityCheck){
      byte b = in.readByte();
      assert b == (byte)0xAB: b + " " + (byte)0xAB;
    }
    byte t = in.readByte();
    Object _data;
    RequestType _type;
    if(t==0 || t==3){
      _type = RequestType.NEW_WRITES; 
//      if(StorageConfig.S3Emulation){
//        S3Inval s3inval = new S3Inval();
//        s3inval.readFromStream(in, optimized);
//        _data = s3inval;
//      } else {
//        NewWriteRequestData nwrd = new NewWriteRequestData();
//        nwrd.readFromStream(in, optimized);
//        _data = nwrd;
//      }
      if(t==0){
        S3Inval s3inval = new S3Inval();
        s3inval.readFromStream(in, optimized);
        _data = s3inval;
      } else {
        NewWriteRequestData nwrd = new NewWriteRequestData();
        nwrd.readFromStream(in, optimized);
        _data = nwrd;
      }
    } else if(t==1){
        _type = RequestType.REQUEST_BODY;
      BodyRequestData brd = new BodyRequestData();
      brd.readFromStream(in, optimized);
      _data = brd;      
    }else if(t==2){
      _type = RequestType.REQUEST_P2P_BODY;
      P2PBodyRequestData brd = new P2PBodyRequestData();
      brd.readFromStream(in, optimized);
      _data = brd;      
    }else{
      throw new IOException("unrecognized request type " + t);
    }
    this.data = _data;
    this.type = _type;
    if(SangminConfig.sanityCheck){
      byte b = in.readByte();
      assert b == (byte)0xAC: b + " " + (byte)0xAC;
    }

  }
  public void writeToStream(IrisOutputStream out, boolean optimized)
  throws IOException{
    if(SangminConfig.enableSanityCheck){
      out.writeByte(0xAB);
    }
    if(type == RequestType.NEW_WRITES){
//      if(StorageConfig.S3Emulation){
//        S3Inval s3inv = (S3Inval)this.data;
//        s3inv.writeToStream(out, optimized);
//      } else {
//        NewWriteRequestData nwrd = (NewWriteRequestData) this.data;
//        nwrd.writeToStream(out, optimized);
//      }
      if(data instanceof S3Inval){
        out.writeByte((byte)0);
        S3Inval s3inv = (S3Inval)this.data;
        s3inv.writeToStream(out, optimized);
      } else {
        out.writeByte((byte)3);
        NewWriteRequestData nwrd = (NewWriteRequestData) this.data;
        nwrd.writeToStream(out, optimized);
      }
    } else if(type == RequestType.REQUEST_BODY){
      out.writeByte(1);
      BodyRequestData brd = (BodyRequestData) this.data;
      brd.writeToStream(out, optimized);      

    }else if(type == RequestType.REQUEST_P2P_BODY){
      out.writeByte(2);
      P2PBodyRequestData brd = (P2PBodyRequestData) this.data;
      brd.writeToStream(out, optimized);      
    }

    if(SangminConfig.enableSanityCheck){
      out.writeByte(0xAC);
    }
  }
  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "Request [data=" + data + ", type=" + type + "]";
  }
}

