package code.untrustedstorage.writeanyreadany;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

import code.ObjId;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.IrisDataObject;

public class S3Inval implements Externalizable, IrisSerializable{

  private ObjId objId;
  private IrisDataObject value;

  public S3Inval(ObjId oid, IrisDataObject v){
    objId = oid;
    value = v;
  }

  public S3Inval(){
    // TODO Auto-generated constructor stub
  }

  public ObjId getObjId(){
    return objId;
  }

  public IrisDataObject getValue(){
    return value;
  }

  public void readExternal(ObjectInput in) throws IOException,
  ClassNotFoundException{
    ObjId _oid = new ObjId(SerializationHelper.readShortString(in));

    int size = in.readInt();
    byte[] buf = new byte[size];
    in.readFully(buf);

    IrisDataObject _o = new IrisDataObject(buf);

    Field[] f = new Field[2];

    try{
      f[0] = S3Inval.class.getDeclaredField("objId");
      f[1] = S3Inval.class.getDeclaredField("value");      
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, _oid);
      f[1].set(this, _o);
    }catch(Exception ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }

  }

  public void writeExternal(ObjectOutput out) throws IOException{
    SerializationHelper.writeShortString(this.objId.getPath(), out);

    byte[] b = value.getUnsafeBytes();
    out.writeInt(b.length);
    out.write(b);

  }

//  @Override
//  public int readFromStream(InputStream is) throws IOException{
//    int nRead = 0;
//
//    int oidLen = is.read();
//    nRead += 1;
//    byte[] b = new byte[oidLen];
//    SerializationHelper.readFully(is, b);
//    nRead += oidLen;
//    this.objId = new ObjId(new String(b));
//
////    byte[] len = new byte[4];
////    SerializationHelper.readFully(is, len);
////    nRead += 4;
////
////    int size = SerializationHelper.getInt(len, 0);
//    int size = SerializationHelper.readInt(is);
//    nRead += 4;
//    byte[] data = new byte[size];
//    SerializationHelper.readFully(is, data);
//    nRead += size;
//
//    this.value = new IrisDataObject(data);
//
//    return nRead;
//  }

//  @Override
//  public int writeToStream(OutputStream os) throws IOException{
//    byte[] b = this.objId.getPath().getBytes();
//    assert b.length < 256;
//    os.write(b.length);
//    os.write(b);
//
//    byte[] data = value.getUnsafeBytes();
//    SerializationHelper.writeInt(os, data.length);
////    byte[] len = new byte[4];
////    SerializationHelper.putInt(len, 0, data.length);
////    os.write(len);
//    os.write(data);
//
//    return (1 + b.length + 4 + data.length);
//  }
  
  public static void main(String[] args){
    
  }

  public void readFromStream(IrisInputStream in, boolean optimized)
      throws IOException{
//    ObjId _oid = new ObjId(SerializationHelper.readShortString(in));
    ObjId _oid = new ObjId(in.readShortString());
    int size = in.readInt();
    byte[] buf = new byte[size];
    in.readFully(buf);

    IrisDataObject _o = new IrisDataObject(buf);
    this.objId = _oid;
    this.value = _o;
    
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
      throws IOException{
//    SerializationHelper.writeShortString(this.objId.getPath(), out);
    out.writeShortString(this.objId.getPath());

    byte[] b = value.getUnsafeBytes();
    out.writeInt(b.length);
    out.write(b);
    
  }

}
