package code.untrustedstorage.writeanyreadany;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import code.security.SangminConfig;
import code.simulator.Node;
import code.simulator.agreement.Tuple;
import code.untrustedstorage.writeanyreadany.client.ClientNode;


public class StorageConfig{
  
  
  public static boolean useNetty = true;

  public static boolean useBeacon;
  public static long    BeaconInterval;
  
  public static long    InterServerSyncInterval;
  
  public static boolean useCommit;
  public static int     MaxNumWritesPerCommit;
  public static long    CommitInterval;
  public static int     CommitQuorumSize;
  
  public static boolean useClientBodyCleanup;
//  public static boolean useRMIforStorageAppChannel; // if false, use TCP
  public static int     ServerTCPListenPort;
  
  // Netty related fields
  public static int NettyTCPListenPort; 
  public static int NumNettyReceiveThreads = 1;
  public static int NumNettySendThreads = 1;
  
  public static boolean useNewWriteForwarding = true;
  
  public static long    ClientServerSyncInterval;
  
  public static boolean S3Emulation;
  
  public static boolean NoBodyOnClientServerSync;
  
  public static HashMap<Integer, Set<Integer>> serverMap;
  public static HashMap<Integer, Integer> Client2WriteServerMap;
  public static HashMap<Integer, Integer> Client2ReadServerMap;
  public static HashMap<Integer, Set<Integer>> Client2SyncServerMap;
 
  // modes for preload 
  public static final byte NONE=0;
  public static final byte DELAY=1;
  public static final byte TIMED=2;
  
  // reference absolute time
  public static long refTime = 0;
  
  // Experiments parameters
  public static long    ClientWriteInterval = 1000L;
  public static int     numObjs = 1000;
  public static int    objSize = 3;//1024*1024;
  public static float   readRatio = (float)0.9;
  public static long    preloadTime = 120000; //2 mins by deafult
  public static byte    usePreload = DELAY; //NONE/DELAY/TIMED
  public static long    executionTime = 60000; // 10 mins by deafult
  public static long    waitAfterPreload = -1; // 60000 time to wait after preload (depends on the number of clients)
  public static long    numRequests = -1; // 600 number of requests to issue

  
  // [left, right)
  public static HashMap<Integer, Tuple<Integer, Integer>> clientWriteRange = 
    new HashMap<Integer, Tuple<Integer, Integer>>();
  
  public static boolean simulateSSPartition;
  public static long firstSSPartitionEnd;
  public static long firstSSPartitionStart;
  public static boolean simulateClientPartition;
  public static long firstClientPartitionEnd;
  public static long firstClientPartitionStart;
  
  static {
    useBeacon = true;
    BeaconInterval = 10000L;
    
    InterServerSyncInterval = 1000L;
    
    useCommit = true;
    MaxNumWritesPerCommit = 1000;
    CommitInterval = 10000L;
    CommitQuorumSize = 2;
    
    useClientBodyCleanup = true;
//    useRMIforStorageAppChannel = false;
    ServerTCPListenPort = 4321;
    NettyTCPListenPort = 5322;
    
    ClientServerSyncInterval = 5000L;
    
    serverMap = new HashMap<Integer, Set<Integer>>();
    Client2WriteServerMap = new HashMap<Integer, Integer>();
    Client2ReadServerMap = new HashMap<Integer, Integer>();
    Client2SyncServerMap = new HashMap<Integer, Set<Integer>>();
    
    S3Emulation = false;
    
    NoBodyOnClientServerSync = true;
    
    simulateSSPartition = false;
    firstSSPartitionStart = Long.MAX_VALUE;
    firstSSPartitionEnd = Long.MAX_VALUE;
    simulateClientPartition = false;
    firstClientPartitionStart = Long.MAX_VALUE;
    firstClientPartitionEnd = Long.MAX_VALUE;
  }
  
  public static void printCurrentConfig(){
    System.out.println("useNetty : " + useNetty);
    System.out.println("ForwardWrites : " + useNewWriteForwarding);
    System.out.println("BeaconInterval : " + BeaconInterval);
    System.out.println("ClientWriteInterval : " + ClientWriteInterval);
    System.out.println("CommitInterval : " + CommitInterval);
    System.out.println("CommitQuorumSize : " + CommitQuorumSize);
    System.out.println("InterServerSynchInterval : " + InterServerSyncInterval);
    System.out.println("MaxNumWritesPerCommit : " + MaxNumWritesPerCommit);
    System.out.println("NoBodyOnClientServerSync : " + NoBodyOnClientServerSync);
    System.out.println("numObjs : " + numObjs);
    System.out.println("objSize : " + objSize);
    System.out.println("readRatio : " + readRatio);
    System.out.println("S3Emulation : " + S3Emulation);
    System.out.println("useBeacon : " + useBeacon);
    System.out.println("useClientBodyCleanup : " + useClientBodyCleanup);
    System.out.println("useCommit : " + useCommit);
//    System.out.println("useRMIforStorageAppChannel :" + useRMIforStorageAppChannel);
    System.out.println("useSignature :" + Node.useSignature);
    System.out.println("enableSecurity : " + Node.enableSecurity);
    System.out.println("db path :" + SangminConfig.configFile);
    System.out.println("usePersistentStore : " + SangminConfig.usePersistentStore);
    System.out.println("BerkeleyDB Cache size : " + SangminConfig.BDBCacheSize);
    System.out.println("BerkeletDB storage path : " + SangminConfig.configFile);
    System.out.println("preload time : " + preloadTime);
    System.out.println("usePreload : " + usePreload);
    System.out.println("hacked hash: " + SangminConfig.hackedHash);
    System.out.println("hackedStore: " + SangminConfig.hackedStore);
    System.out.println("useHash: " + SangminConfig.useHash);
    System.out.println("hacked signature: " + SangminConfig.hackedSignature);
    System.out.println("ServerPartition : " + simulateSSPartition);
    System.out.println("ServerPartition start time : " + firstSSPartitionStart);
    System.out.println("ServerPartition end time : " + firstSSPartitionEnd);

    System.out.println("UseNewWriteForwarding : " + useNewWriteForwarding);
    //System.out.println("execution time : " + executionTime);
    System.out.println("numRequests : " + StorageConfig.numRequests);
    System.out.println("fineGrainedTracking : " + SangminConfig.fineGrainedTracking);
    System.out.println("waitAfterPreload : " + StorageConfig.waitAfterPreload);
    System.out.println("useBufferedIO : " + SangminConfig.useBufferedIO);
    System.out.println("IOBufferSize : " + SangminConfig.IOBufferSize);
    System.out.println("useByteArraysForIO : " + SangminConfig.useByteArraysForIO);
    for(Integer i: StorageConfig.clientWriteRange.keySet()){
      Tuple t = StorageConfig.clientWriteRange.get(i);
      System.out.println("RangePartition " + i + " " + t.getKey() + " " + t.getValue());
    }
//    System.out.println("execution time : " + executionTime);

  }
  
  public static void readConfig(String configFile) throws IOException{
    //
    //
    // ## server <iris node id> <server to sync 1> [<server to sync 2> ... ]
    // ## client <iris node id> <server for write>  <server for read> <server to sync 1> [<server to sync 2> ... ]
    
    reset();
    BufferedReader reader = new BufferedReader(new FileReader(configFile));

    for(;;){
      String str = reader.readLine();
      
      if(str == null){
        printCurrentConfig();
        return;
      }      
      
      str = str.trim();
      if(str.startsWith("#")){
        continue;
      }
      String[] line = str.split("\\s+");
      
      if(line[0].equalsIgnoreCase("server")){
        int sId = Integer.parseInt(line[1]);
        int numSyncServers = line.length - 2;
        HashSet<Integer> s = new HashSet<Integer>();
        for(int i=0; i < numSyncServers; i++){
          s.add(Integer.parseInt(line[i+2]));
        }
        serverMap.put(sId, s);
      }
      
      else if(line[0].equalsIgnoreCase("client")){
        int cId = Integer.parseInt(line[1]);
        int wServerId = Integer.parseInt(line[2]);
        int rServerId = Integer.parseInt(line[3]);
        int numSyncServers = line.length - 4;
        HashSet<Integer> s = new HashSet<Integer>();
        for(int i=0; i < numSyncServers; i++){
          s.add(Integer.parseInt(line[i+4]));
        }
        Client2WriteServerMap.put(cId, wServerId);
        Client2ReadServerMap.put(cId, rServerId);
        Client2SyncServerMap.put(cId, s);
      }
      
      else if(line[0].equalsIgnoreCase("useBeacon")){
        if(line[1].equalsIgnoreCase("true")){
          useBeacon = true;
        } else if(line[1].equalsIgnoreCase("false")){
          useBeacon = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } 
      }
      
      else if(line[0].equalsIgnoreCase("RangePartition")){
        int id = Integer.parseInt(line[1]);
        int lowerValIncl = Integer.parseInt(line[2]);
        int upperValExcl = Integer.parseInt(line[3]);
        if(line.length != 4){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } else{
          StorageConfig.clientWriteRange.put(id, new Tuple<Integer, Integer>(lowerValIncl, upperValExcl));
        }
      }
      
      else if(line[0].equalsIgnoreCase("useCommit")){
        if(line[1].equalsIgnoreCase("true")){
          useCommit = true;
        } else if(line[1].equalsIgnoreCase("false")){
          useCommit = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } 
      }
      
      else if(line[0].equalsIgnoreCase("fineGrainedTracking")){
        if(line[1].equalsIgnoreCase("true")){
          SangminConfig.fineGrainedTracking = true;
        } else if(line[1].equalsIgnoreCase("false")){
          SangminConfig.fineGrainedTracking = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } 
      }
      
      else if(line[0].equalsIgnoreCase("CommitInterval")){
        try{
          CommitInterval = Long.parseLong(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      
      else if(line[0].equalsIgnoreCase("MaxNumWritesPerCommit")){
        try{
          MaxNumWritesPerCommit = Integer.parseInt(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      
      else if(line[0].equalsIgnoreCase("CommitQuorumSize")){
        try{
          CommitQuorumSize = Integer.parseInt(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      
      else if(line[0].equalsIgnoreCase("InterServerSyncInterval")){
        try{
          InterServerSyncInterval = Long.parseLong(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      
      else if(line[0].equalsIgnoreCase("ClientServerSyncInterval")){
        try{
          ClientServerSyncInterval = Long.parseLong(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      
      else if(line[0].equalsIgnoreCase("useClientBodyCleanup")){
        if(line[1].equalsIgnoreCase("true")){
          useClientBodyCleanup = true;
        } else if(line[1].equalsIgnoreCase("false")){
          useClientBodyCleanup = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } 
      }
      
      else if(line[0].equalsIgnoreCase("useSignature")){
        if(line[1].equalsIgnoreCase("true")){
          Node.useSignature = true;
        } else if(line[1].equalsIgnoreCase("false")){
          Node.useSignature = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("useSecurity")){
        if(line[1].equalsIgnoreCase("true")){
          Node.enableSecurity= true;
        } else if(line[1].equalsIgnoreCase("false")){
          Node.enableSecurity = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("usePersistentStore")){
        if(line[1].equalsIgnoreCase("true")){
          SangminConfig.usePersistentStore = true;
        } else if(line[1].equalsIgnoreCase("false")){
          SangminConfig.usePersistentStore = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("S3Emulation")){
        if(line[1].equalsIgnoreCase("true")){
          S3Emulation= true;
          //SangminConfig.hackedHash = true;
        } else if(line[1].equalsIgnoreCase("false")){
          S3Emulation = false;
          //SangminConfig.hackedHash = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("useNewWriteForwarding")){
        if(line[1].equalsIgnoreCase("true")){
          useNewWriteForwarding= true;
          //SangminConfig.hackedHash = true;
        } else if(line[1].equalsIgnoreCase("false")){
          useNewWriteForwarding = false;
          //SangminConfig.hackedHash = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("hackedHash")){
        if(line[1].equalsIgnoreCase("true")){
          SangminConfig.hackedHash = true;
        } else if(line[1].equalsIgnoreCase("false")){
          SangminConfig.hackedHash = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }else if(line[0].equalsIgnoreCase("hackedStore")){
        if(line[1].equalsIgnoreCase("true")){
          SangminConfig.hackedStore = true;
        } else if(line[1].equalsIgnoreCase("false")){
          SangminConfig.hackedStore = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }else if(line[0].equalsIgnoreCase("useHash")){
        if(line[1].equalsIgnoreCase("true")){
          SangminConfig.useHash = true;
        } else if(line[1].equalsIgnoreCase("false")){
          SangminConfig.useHash = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("hackedSignature")){
        if(line[1].equalsIgnoreCase("true")){
          SangminConfig.hackedSignature = true;
        } else if(line[1].equalsIgnoreCase("false")){
          SangminConfig.hackedSignature = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("NoBodyOnClientServerSync")){
        if(line[1].equalsIgnoreCase("true")){
          NoBodyOnClientServerSync= true;
        } else if(line[1].equalsIgnoreCase("false")){
          NoBodyOnClientServerSync = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("ClientWriteInterval")){
        try{
          ClientWriteInterval = Long.parseLong(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("NumObjs")){
        try{
          numObjs = Integer.parseInt(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }
      }
      else if(line[0].equalsIgnoreCase("objSize")){
        try{
          objSize = Integer.parseInt(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("readRatio")){
        try{
          readRatio = Float.parseFloat(line[1]);
        } catch(NumberFormatException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("DBPath")){
        try{
          SangminConfig.configFile = line[1];
  
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("preloadTime")){
        try{
          preloadTime = Long.parseLong(line[1]);
  
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("usePreload")){
        try{
          usePreload = Byte.parseByte(line[1]);
  
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("ServerPartition")){        
        if(line[1].equalsIgnoreCase("true")){
          simulateSSPartition= true;
        } else if(line[1].equalsIgnoreCase("false")){
          simulateSSPartition = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }        
      }
      else if(line[0].equalsIgnoreCase("serverPartitionStartTime")){
        try{
          firstSSPartitionStart = Long.parseLong(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("serverPartitionEndTime")){
        try{
          firstSSPartitionEnd = Long.parseLong(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("simulateClientPartition")){        
        if(line[1].equalsIgnoreCase("true")){
          simulateClientPartition= true;
        } else if(line[1].equalsIgnoreCase("false")){
          simulateClientPartition = false;
        } else {
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);
        }        
      }
      else if(line[0].equalsIgnoreCase("clientPartitionStartTime")){
        try{
          firstClientPartitionStart = Long.parseLong(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }
      else if(line[0].equalsIgnoreCase("clientPartitionEndTime")){
        try{
          firstClientPartitionEnd = Long.parseLong(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }else if(line[0].equalsIgnoreCase("numRequests")){
        try{
          StorageConfig.numRequests = Long.parseLong(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }else if(line[0].equalsIgnoreCase("waitAfterPreload")){
        try{
          StorageConfig.waitAfterPreload = Long.parseLong(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }else if(line[0].equalsIgnoreCase("forwardWrites")){
        try{
          StorageConfig.useNewWriteForwarding = Boolean.parseBoolean(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1); 
	}       
      }else if(line[0].equalsIgnoreCase("useNetty")){
        try{
          StorageConfig.useNetty = Boolean.parseBoolean(line[1]);
        } catch(ArrayIndexOutOfBoundsException e){
          System.err.println("Invalid config entry : " + str);
          System.exit(-1);        
        }
      }else{
        System.out.println("#unrecognized entry " + str);
      }
      
    }

  }
    

  
  public static void addServer(int sId, Set<Integer> syncServers){
    serverMap.put(sId, syncServers);
  }

  
  public static void addClient(int cId, int wServerId, int rServerId, Set<Integer> syncServers){
    Client2WriteServerMap.put(cId, wServerId);
    Client2ReadServerMap.put(cId, rServerId);
    Client2SyncServerMap.put(cId, syncServers);
  }
  
  public static void reset(){

    serverMap.clear();
    Client2WriteServerMap.clear();
    Client2ReadServerMap.clear();
    Client2SyncServerMap.clear();
  }
  
  public static Set<Integer> getClientIdSet(){
    return Client2WriteServerMap.keySet();
  }
  
  public static int numClients(){
    return getClientIdSet().size();
  }

  public static Set<Integer> getServerIdSet(){
    return serverMap.keySet();
  }
  public static int numServers(){
    return serverMap.keySet().size();
  }
  

}
