package code.untrustedstorage.writeanyreadany.client;

import java.util.Collection;
import java.util.LinkedList;

import code.simulator.Hash;

public class AccessStat {
  long receivedBytes;
  long sentBytes;
  LinkedList<Hash> hashes;
  boolean success;

  /**
   * @param receivedBytes
   * @param sentBytes
   * @param hashString
   */
  public AccessStat(long sentBytes, long receivedBytes, LinkedList<Hash> hashes) {
    this.receivedBytes = receivedBytes;
    this.sentBytes = sentBytes;
    this.hashes = new LinkedList<Hash>(hashes);
    this.success = false;
  }

  /**
   * @param receivedBytes
   * @param sentBytes
   */
  public AccessStat(long sentBytes, long receivedBytes) {
    this.receivedBytes = receivedBytes;
    this.sentBytes = sentBytes;
    hashes = new LinkedList<Hash>();
  }

  public void addReadStat(AccessStat rs)
  {
    this.receivedBytes += rs.receivedBytes;
    this.sentBytes += rs.sentBytes;
    hashes.addAll(rs.hashes);
  }

  public void addHash(Hash hash){
    this.hashes.add(hash);
  }

  public void setSuccess(boolean suc){
    this.success = suc;
  }

  public boolean getSuccess(){
    return this.success;
  }

  public String getHashString(){
    String ret = "";
    for(Hash h: hashes){
      ret += h + " ";
    }
    return ret;
  }
}
