package code.untrustedstorage.writeanyreadany.client;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

import code.ObjId;
import code.branchDetecting.BranchID;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.simulator.IrisObject;
import code.untrustedstorage.writeanyreadany.NamespaceLayout;

public class BeaconMonitor extends Thread{

  private ClientNode clientNode;
  private long beaconInterval;
  private Set<ObjId> beaconObjIdSet;
  private static long delta = 500;
  
  
  public BeaconMonitor(Set<Integer> clientSet, ClientNode node, long beaconInterval){
    assert false : "WE DON'T USE BeaconMonitor any more";
    
    this.setDaemon(true);
    clientNode = node;
    this.beaconInterval = beaconInterval;
    beaconObjIdSet = new HashSet<ObjId>();
    for(Integer bid : clientSet){
      if(bid.equals((int)clientNode.getID().getIDint())){
        continue;
      }
      beaconObjIdSet.add(new ObjId(NamespaceLayout.getBeaconObj(bid)));
    }
  }
  
  private void raiseAlert(ObjId o){
    //XXX beacon is expired.
  }
  
  public void run(){
    long startTime = System.currentTimeMillis();
    while(true){
      
      long ct = System.currentTimeMillis();
      for(ObjId beaconObj : beaconObjIdSet){
        LinkedList<Object> l = null;
        try{
          l = clientNode.read(beaconObj);
        }catch(DataNotFound e){
          e.printStackTrace();
          System.exit(-1);
        }
        long t;
        if(l.size() <= 0){
          t = startTime;
        } else {
          t = (Long) l.getFirst();
        }
        
        if(ct-t > 2*beaconInterval + delta){
          raiseAlert(beaconObj);
        }        
      }
      
      try{
        sleep(beaconInterval);
      }catch(InterruptedException e){
        e.printStackTrace();
      }
      
    }
    
  }
  
  
}
