package code.untrustedstorage.writeanyreadany.client;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.Map.Entry;

import code.ObjId;
import code.simulator.IrisDataObject;
import code.simulator.NamespaceWatch;
import code.simulator.SyncStatus;
import code.simulator.store.StoreEntry;
import code.untrustedstorage.writeanyreadany.NamespaceLayout;
import code.untrustedstorage.writeanyreadany.StorageConfig;

public class BeaconWatcher implements NamespaceWatch{

  Hashtable<Integer, Long> beaconMap;
  ClientNode cn;

  public BeaconWatcher(ClientNode node, Set<Integer> clientIdSet){
    this.cn = node;
    beaconMap = new Hashtable<Integer, Long>();
    long ctime = System.currentTimeMillis();
    for(Integer cid : clientIdSet){
      beaconMap.put(cid, ctime);
    }
  }
  
  private void updateBeaconState(int nodeid, long time){
    assert beaconMap.get(nodeid)  < time;
    beaconMap.put(nodeid, time);
  }
  
  private boolean checkWithServer(int cid, long ctime){
    
    try{
      LinkedList<Object> l = cn.read(new ObjId(NamespaceLayout.getBeaconObj(cid)));
      assert l.size() <= 1;
      long beaconTime = (Long)l.getFirst();
      if(ctime - beaconTime > StorageConfig.BeaconInterval){
        return false;
      } else {
        return true;
      }
    }catch(DataNotFound e){
      e.printStackTrace();
      return false;
    }
  }
  
  private void beaconExpired(int cid){
    
    SyncStatus ss = cn.syncTo(cid);
    
    //XXX Notify Application
  }
  
  public boolean checkBeacon(){
    long interval = StorageConfig.BeaconInterval;
    long ctime = System.currentTimeMillis();
    for(Entry<Integer, Long> entry : beaconMap.entrySet()){
      
      long lastBeaconTime = entry.getValue();
      if(ctime - lastBeaconTime >interval){
        if(!checkWithServer(entry.getKey(), ctime)){
          beaconExpired(entry.getKey());
          return false;
        }
      }                  
    }
    
    return true;
    
    
  }
  
  
  public void notifyCheckpoint(int epoch){
    // TODO Auto-generated method stub

  }

  public void notifyWrite(int epoch, ObjId o, StoreEntry se){
    
    assert se.getData() instanceof IrisDataObject;
    IrisDataObject beaconObj = (IrisDataObject)se.getData();
    int cid = NamespaceLayout.getServerIdFromBeaconObjId(o);
    updateBeaconState(cid, (Long)beaconObj.getObject());
    System.out.println("Beacon received : " + cid + ", beacon time: " + (Long)beaconObj.getObject() );
    

  }

}
