package code.untrustedstorage.writeanyreadany.client;

import code.ObjId;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.untrustedstorage.writeanyreadany.NamespaceLayout;

public class BeaconWriter extends Thread{

  private ClientNode clientNode;
  private long beaconInterval;
  private ObjId beaconObjId;
  
  public BeaconWriter(ClientNode node, long interval){
    this.clientNode = node;
    this.beaconInterval = interval;
    this.setDaemon(true);
    this.setName("Beacon Writer for node " + node.getID());
    beaconObjId = new ObjId(NamespaceLayout.getBeaconObj((int)clientNode.getID().getIDint()));
  }
  
  public void run(){
    
    while(true){
      clientNode.write(beaconObjId, System.currentTimeMillis());
      
      try{
        sleep(beaconInterval);
      }catch(InterruptedException e){
      }
      
      
    }
    
  }
  
  
}
