package code.untrustedstorage.writeanyreadany.client;

import java.util.Collection;
import java.util.Iterator;

import code.AcceptVV;
import code.branchDetecting.BranchID;
import code.simulator.IrisNode;
import code.simulator.SimPreciseInv;
import code.untrustedstorage.writeanyreadany.CachingPolicy;

/**
 * Client discards all bodies but ones for writes it issued
 * @author sangmin
 *
 */
public class ClientCachingPolicy implements CachingPolicy{

  public void cache(IrisNode irisNode, AcceptVV oldCommitCut,
      AcceptVV newCommitCut){
    BranchID myId = irisNode.getBranchID();

    if(newCommitCut.greaterThan(oldCommitCut)){
      Collection<SimPreciseInv> newlyCommitedWrites = irisNode.commitCutAdvanced(oldCommitCut, newCommitCut);
      Iterator<SimPreciseInv> iter = newlyCommitedWrites.iterator();
      while(iter.hasNext()){
        SimPreciseInv spi = iter.next();
        if(!spi.getNodeId().equals(myId)){
          irisNode.removeBody(spi.getData().getHash());
        }
      }
    }

  }

}
