package code.untrustedstorage.writeanyreadany.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

import code.untrustedstorage.writeanyreadany.client.ServerChooserInterface.OpType;

/**
 * Class to maintain the persistent iterator over the various servers that we can use to 
 * serve our read requess
 * @author princem
 *
 */
public class ClientConnectionManager {

  private IrisClientServerConnection readCurConnection = null;
  private IrisClientServerConnection writeCurConnection = null;
  private HashSet<Integer> readServers;
  private HashSet<Integer> writeServers;
  private Iterator<Integer> readIter;
  private Iterator<Integer> writeIter;

  public ClientConnectionManager(int primaryWriteServerId, int primaryReadServerId){
    try {
      writeCurConnection = new IrisClientServerConnection(primaryWriteServerId);
    } catch (Exception e) {
      e.printStackTrace();
    }
    if(primaryWriteServerId == primaryReadServerId){
      readCurConnection = writeCurConnection;
    }else{
      try {
        readCurConnection = new IrisClientServerConnection(primaryReadServerId);
      } catch (Exception e) {
        e.printStackTrace();
      }
    }

    readServers = new HashSet<Integer>();
    writeServers = new HashSet<Integer>();
  }

  /**
   * returns null if no more servers to iterate over
   * @return
   */
  synchronized public IrisClientServerConnection getNextConnection(OpType opType){
    Iterator<Integer> iter;
    IrisClientServerConnection otherCon;
    if(opType.equals(OpType.Read)){
      iter = readIter;
      otherCon = writeCurConnection;
    }else{
      iter = writeIter;
      otherCon = readCurConnection;
    }
    while(iter.hasNext()){
      int nextServer = iter.next();
      try {
        IrisClientServerConnection con;
        // see if the otherCon is connected--if so, reuse that so that we don't open two 
        // connections to the same node
        if(otherCon != null && otherCon.getServerId() == nextServer && otherCon.isConnected()){
          con = otherCon;
        }else{
          con = new IrisClientServerConnection(nextServer);
        }
        if(opType.equals(OpType.Read)){
          readCurConnection = con;
        }else{
          writeCurConnection = con;
        }
        return con;
      } catch (UnknownHostException e) {
      } catch (IOException e) {
      }
    }
    return null;
  }

  synchronized private void createIter(OpType opType){
    if(opType.equals(OpType.Read)){
      readIter = readServers.iterator();
    }else{
      writeIter = writeServers.iterator();
    }
  }

  /**
   * set up the persistent iterator to iterate over these servers and returns the next successful server
   * @param servers
   * @return
   */
  synchronized public IrisClientServerConnection getNextConnection(Collection<Integer> servers, OpType opType){
    HashSet<Integer> localServers;
    IrisClientServerConnection curCon;
    if(opType.equals(OpType.Read)){
      localServers = readServers;
      curCon = readCurConnection;
    }else{
      localServers = writeServers;
      curCon = writeCurConnection;
    }
    localServers.clear();
    localServers.addAll(servers);

    //reuse the old connection if it is still connected
    if(curCon.isConnected() && localServers.contains(curCon.getServerId())){
      localServers.remove(curCon.getServerId());
      createIter(opType);
      return curCon;
    }else{
      createIter(opType);
      return getNextConnection(opType);
    }
  }

  synchronized public IrisClientServerConnection getConnection(int server) throws UnknownHostException, IOException{
    return new IrisClientServerConnection(server);
  }
}
