package code.untrustedstorage.writeanyreadany.client;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Random;

import code.Config;
import code.NodeId;

public class ClientNodeTraceExecutor{
  
  String tracefile;
  Hashtable<Integer, ObjectOutputStream> outputStreamMap;
  Hashtable<Integer, ObjectInputStream> inputStreamMap;
  
  public ClientNodeTraceExecutor(String tracefile, String irisConfigFile){
    
    this.tracefile = tracefile;
    Config.readConfig(irisConfigFile);
    
    outputStreamMap = new Hashtable<Integer, ObjectOutputStream>();
    inputStreamMap = new Hashtable<Integer, ObjectInputStream>();
    
  }
  
  public ClientNodeTraceExecutor(String tracefile){
    
    this.tracefile = tracefile;
//    Config.readConfig(irisConfigFile);
    
    outputStreamMap = new Hashtable<Integer, ObjectOutputStream>();
    inputStreamMap = new Hashtable<Integer, ObjectInputStream>();
    
  }
  
  public void start() throws IOException, ClassNotFoundException{
    
    FileReader f1 = new FileReader(tracefile);
    BufferedReader br = new BufferedReader(f1);

    String line;
    int n = 0;
    while((line=br.readLine()) != null){
      System.out.println("Executing " + line + " : Have executed " + n++ + " command(s).");
      String[] cmd = line.split("\\s+");
      int cid = Integer.parseInt(cmd[0]);
      String cmdToSend = line.substring(line.indexOf(" ") +1);
      if(outputStreamMap.containsKey(cid)){
        outputStreamMap.get(cid).writeObject(cmdToSend);
        
        inputStreamMap.get(cid).readObject();
//        assert ack;
        
      } else {
        Socket s = new Socket(Config.getDNS(new NodeId(cid)), ClientNodeTraceListener.LISTEN_PORT_BASE + cid );
        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
        oos.writeObject(cmdToSend);
        ois.readObject();
//        assert ack;
        outputStreamMap.put(cid, oos);
        inputStreamMap.put(cid, ois);
        
      }
    }
    System.out.println("DONE! Have executed " + n + " command(s).");
    
  }
  
  static public void generateTrace(String outputF, float readRatio, int startClientNodeId, int numClients, int numOperations) throws IOException{
  
    FileWriter fw = new FileWriter(outputF);
    Random r = new Random();
    for(int i =0; i < numOperations; i++){
      String cmd = "";
      int cid = startClientNodeId + r.nextInt(numClients);
      cmd += cid;
      if(r.nextFloat()<readRatio){
        cmd += " r /"+r.nextInt(100)+"\n";
      } else {
        cmd += " w /"+r.nextInt(100)+"\n";
      }
      
      
      fw.write(cmd);      
      
    }
    fw.flush();
    fw.close();
        
  }
  
  static public void main(String[] args) throws IOException, ClassNotFoundException{
    
    if(args[0].equalsIgnoreCase("-create")){
      String outputfile = args[1];
      float readRatio = Float.parseFloat(args[2]);
      int startClientNodeId = Integer.parseInt(args[3]);
      int numClients = Integer.parseInt(args[4]);
      int numOperations = Integer.parseInt(args[5]);
      
      generateTrace(outputfile, readRatio, startClientNodeId, numClients, numOperations);
      return;
      
    }
    
    String USAGE = "Usage : java " + ClientNodeTraceExecutor.class.getCanonicalName() +
    " <Iris Configurtaion File Path> <Trace File Path>";

    if(args.length < 2){
      System.err.println(USAGE);
      System.exit(-1);
    }
    
    String irisConfigFile = args[0];
    String tracefile = args[1];
    
    ClientNodeTraceExecutor cnte = new ClientNodeTraceExecutor(tracefile, irisConfigFile);
    cnte.start();
      
  }
  
  

}
