package code.untrustedstorage.writeanyreadany.client;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.NotBoundException;

import code.Config;
import code.ObjId;
import code.untrustedstorage.writeanyreadany.StorageConfig;

public class ClientNodeTraceListener extends Thread{

  public final static int LISTEN_PORT_BASE = 5432;
  public final static int DATASIZE = 1024 * 1024;
  
  ClientNode cn;
  byte[] data;
  
  public ClientNodeTraceListener(ClientNode c){
    cn = c;
    
    data = new byte[DATASIZE];
  }
  
  private boolean processCmd(String cmd) throws DataNotFound{
    String[] line = cmd.split("\\s+");
    
    if(line[0].equalsIgnoreCase("r")){
      cn.read(new ObjId(line[1]));
    } else if(line[0].equalsIgnoreCase("w")){
      cn.write(new ObjId(line[1]), data);
    } else if(line[0].equalsIgnoreCase("q")){
      return false;
    }
    return true;
    
  }
  public void run(){
    while(true){
      try{
        ServerSocket ss = new ServerSocket(LISTEN_PORT_BASE + (int)cn.getID().getIDint());
        Socket connection = ss.accept();

        ObjectInputStream inputStream = new ObjectInputStream(connection.getInputStream());
        ObjectOutputStream outputStream = new ObjectOutputStream(connection.getOutputStream());


        while(true){
          String command = null;
          try{
            command = (String)inputStream.readObject();
          }catch(ClassNotFoundException e){
            // TODO Auto-generated catch block
            e.printStackTrace();
          }

          outputStream.writeObject("ack");

          if(!processCmd(command)){
            System.out.println("Shutting down");
            System.exit(0);
            break;
          }

        }


      }catch(EOFException e){        
        
      }catch(DataNotFound e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        System.exit(-1);
      }catch(IOException e){
        
      }
    }
    
    
  }
  
  static public void main(String[] args) throws IOException, NotBoundException{
    String USAGE = "Usage : java " + ClientNodeTraceListener.class.getCanonicalName() +
    " <Iris Configurtaion File Path> <Storage Config File Path> <my iris id>";

    if(args.length < 3){
      System.err.println(USAGE);
      System.exit(-1);
    }
    
    int myId = Integer.parseInt(args[2]);
    String irisConfigFileName = args[0];
    String storageConfigFileName = args[1];
    
    if(!(new File(irisConfigFileName)).exists()){
      System.err.println("Iris Config file is not found : " + irisConfigFileName);
      System.err.println(USAGE);
      System.exit(-1);
    }
    if(!(new File(storageConfigFileName)).exists()){
      System.err.println("Storage Config file is not found : " + storageConfigFileName);
      System.err.println(USAGE);
      System.exit(-1);
    }

    Config.readConfig(irisConfigFileName);
    StorageConfig.readConfig(storageConfigFileName);
    
    ClientNode cn = new ClientNode(myId,
        StorageConfig.Client2WriteServerMap.get(myId),
        StorageConfig.Client2ReadServerMap.get(myId),
        StorageConfig.Client2SyncServerMap.get(myId),
        StorageConfig.getClientIdSet(), 
        StorageConfig.getServerIdSet());
    
    (new ClientNodeTraceListener(cn)).start();
    
  }
  
  
  
}
