package code.untrustedstorage.writeanyreadany.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

import code.lasr.db.DbException;
import code.lasr.db.DbTransaction;
import code.lasr.db.TxnFailedException;
import code.simulator.agreement.Tuple;
import code.simulator.irisnetty.IrisNetworkQueue;
import code.simulator.irisnetty.NetworkHandler;
import code.simulator.netty.NettyTCPReceiver;

import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.CounterVV;
import code.Env;
import code.NodeId;
import code.ObjId;
import code.SubscriptionSet;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.security.SangminConfig.DebugLevel;
import code.serialization.IrisInputStream;
import code.serialization.IrisObjectInputStream;
import code.serialization.IrisObjectOutputStream;
import code.serialization.IrisOutputStream;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.IrisDataObject;
import code.simulator.IrisHashObject;
import code.simulator.IrisNode;
import code.simulator.IrisObject;
import code.simulator.NamespaceWatch;
import code.simulator.NodeFactory;
import code.simulator.SimPreciseInv;
import code.simulator.SyncRequest;
import code.simulator.SyncStatus;
import code.simulator.netty.NettyTCPSender;
import code.simulator.netty.NetworkQueue;
import code.simulator.persistentLog.PersistentStore;
import code.simulator.store.BodyStore;
import code.simulator.store.BodyStoreInterface;
import code.simulator.store.PersistentBodyStore;
import code.simulator.store.StoreEntry;
import code.untrustedstorage.writeanyreadany.BodyRequestData;
import code.untrustedstorage.writeanyreadany.CommitCutFilter;
import code.untrustedstorage.writeanyreadany.NamespaceLayout;
import code.untrustedstorage.writeanyreadany.NewWriteRequestData;
import code.untrustedstorage.writeanyreadany.P2PBodyRequestData;
import code.untrustedstorage.writeanyreadany.Reply;
import code.untrustedstorage.writeanyreadany.Request;
import code.untrustedstorage.writeanyreadany.S3Inval;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.WatcherForLatency;
import code.untrustedstorage.writeanyreadany.Request.RequestType;
import code.untrustedstorage.writeanyreadany.client.ClientNodeWrapper.IDPair;
import code.untrustedstorage.writeanyreadany.client.ServerChooserInterface.OpType;
import code.untrustedstorage.writeanyreadany.server.ServerListener;

/**
 * tracks the inconsistency/staleness information
 * @author princem
 *
 */
public class ConsClientNodeWrapper extends ClientNodeWrapper{
  private int consWriteCount = 0;
  private CounterVV cvv;
  
  public ConsClientNodeWrapper(int myId, int configId, int primaryWriteServerId, int primaryReadServerId, 
      Set<Integer> syncServerIdSet, Set<Integer> clientIdSet, Set<Integer> serverIdSet, int size) 
  throws UnknownHostException, NotBoundException, IOException{
    super(myId, configId, primaryWriteServerId, primaryReadServerId, syncServerIdSet, clientIdSet, serverIdSet, size);
   cvv = new CounterVV();
  }
  
  public ConsClientNodeWrapper(int myId, int primaryWriteServerId, int primaryReadServerId, 
	      Set<Integer> syncServerIdSet, Set<Integer> clientIdSet, Set<Integer> serverIdSet, int size) 
	  throws UnknownHostException, NotBoundException, IOException{
	    super(myId, myId, primaryWriteServerId, primaryReadServerId, syncServerIdSet, clientIdSet, serverIdSet, size);
	   cvv = new CounterVV();
	  }

  @Override
  public LinkedList<Object> read(ObjId objId) throws DataNotFound{
    LinkedList<Object> ret = super.read(objId);
    try{
      if(ret != null){
        for(Object o: ret){
          assert o instanceof byte[]: o.getClass().getCanonicalName() ;
          byte[] buf = ((byte[])o);
          ByteArrayInputStream bs = new ByteArrayInputStream(buf);
          IrisInputStream iis = new IrisInputStream(bs);
          byte[] hashbytes = new byte[3];
          iis.readFully(hashbytes);
          AcceptVV vv = SerializationHelper.readVV(iis);
          this.cvv.addMaxVV(vv);
        }
      }
    }catch(IOException e){
      e.printStackTrace();
      assert false;
    }
    return ret;
  }
  
  // <wait for PRELOAD_TIME or for specified number of secs since the start of PRELOAD> <wait for sometime> <execute> <wait to be killed>
  //
  // Usage: ClientNodeWrapper <myIrisId> <Iris_ConfigFile> <StorageConfigFile>
  public static void main(String[] args) {

	IDPair idPair = initConfigs(args);
	int myId = idPair.id;
	int configIdx = idPair.irisConfigIdx;

    Tuple<Integer, Integer> writeRange;
    if(StorageConfig.clientWriteRange.containsKey(myId)){
      writeRange = StorageConfig.clientWriteRange.get(myId);
    }else{
      writeRange = new Tuple<Integer, Integer>(0, StorageConfig.numObjs);
    }

    ConsClientNodeWrapper cn = null;
    try{
      cn = new ConsClientNodeWrapper(myId, configIdx,
          StorageConfig.Client2WriteServerMap.get(myId),
          StorageConfig.Client2ReadServerMap.get(myId),
          StorageConfig.Client2SyncServerMap.get(myId),
          StorageConfig.getClientIdSet(), 
          StorageConfig.getServerIdSet(), 
          StorageConfig.objSize 
          );
    }catch(Exception e2){
      e2.printStackTrace();
      System.exit(-1);
    }

    cn.preload(writeRange);

    Env.logWrite("Begin normal execution.");

    cn.issueRequests(writeRange);

  }
  
  @Override
  public String getVV(){
    return new AcceptVV(cvv).toShortString();
  }
  
  @Override
  public byte[] getData(){
    byte[] data = super.getData();
    
    // create a new as for this write
    AcceptStamp as = new AcceptStamp(this.consWriteCount++, clientNode.getID());
    // update cvv
    this.cvv.addMaxAS(as);
    
    ByteArrayOutputStream bs = new ByteArrayOutputStream(40);
    IrisOutputStream ios = new IrisOutputStream(bs);
    try{
      SerializationHelper.writeVV(ios, new AcceptVV(cvv));
      ios.flush();
      byte[] buf = bs.toByteArray();
      System.arraycopy(buf, 0, data, 3, buf.length);
    }catch(IOException e){
      e.printStackTrace();
      assert false;
    }
    
    return data;
  }
  

}

