package code.untrustedstorage.writeanyreadany.client;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

import code.Config;
import code.NodeId;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
import code.untrustedstorage.writeanyreadany.StorageConfig;

public class IrisClientServerConnection {
	private final int serverId;
	private final Socket socket;
	private final IrisInputStream iis;
	private final IrisOutputStream ios;
	private boolean connected = false;
	
	/**
	 * @param iis
	 * @param ios
	 * @param connected
	 * @throws IOException 
	 * @throws UnknownHostException 
	 */
	public IrisClientServerConnection(int serverId) throws UnknownHostException, IOException {
		socket = new Socket(Config.getDNS(new NodeId(serverId)),
				StorageConfig.ServerTCPListenPort + serverId);
		socket.setTcpNoDelay(true);
		socket.setSoTimeout(10000);
		socket.setSendBufferSize(1024*1024*2);
		socket.setReceiveBufferSize(1024*1024*2);
		ios = new IrisOutputStream(socket.getOutputStream());
		iis = new IrisInputStream(socket.getInputStream());
		this.serverId = serverId;  
		this.connected = true;
	}

	/**
	 * @return the connected
	 */
	public boolean isConnected() {
		return connected && (socket!= null) && socket.isConnected();
	}

	/**
	 * @param connected the connected to set
	 */
	public void setConnected(boolean connected) {
		assert socket != null && socket.isConnected();
		this.connected = connected;
	}

	/**
	 * @return the serverId
	 */
	public int getServerId() {
		return serverId;
	}

	/**
	 * @return the socket
	 */
	public Socket getSocket() {
		return socket;
	}

	/**
	 * @return the iis
	 */
	public IrisInputStream getIis() {
		return iis;
	}

	/**
	 * @return the ios
	 */
	public IrisOutputStream getIos() {
		return ios;
	}

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "IrisClientServerConnection [connected=" + connected + ", serverId="
        + serverId + "]";
  }
	
}
