package code.untrustedstorage.writeanyreadany.client;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

import code.branchDetecting.BranchID;
import code.security.SangminConfig;

public class ServerChooser implements ServerChooserInterface{
  LinkedList<Integer> readServers, writeServers;
  boolean p2pMode = false;
  public static Timer timer = new Timer();
  LinkedList<BranchID> syncServers;
  LinkedList<BranchID> syncClients;
  

  public ServerChooser(Collection<Integer> readServers, 
      Collection<Integer> writeServers, 
      Collection<BranchID> syncServers, 
      Collection<BranchID> syncClients){
    this.readServers = new LinkedList<Integer>(readServers);
    this.writeServers = new LinkedList<Integer>(writeServers);
    this.syncServers = new LinkedList<BranchID>(syncServers);
    this.syncClients = new LinkedList<BranchID>(syncClients);
  }

  synchronized public LinkedList<Integer> getServers(OpType optype) {
    if(!p2pMode){
    LinkedList<Integer> relevantList = ((optype==OpType.Read)?readServers:writeServers);
    LinkedList<Integer> temp = new LinkedList<Integer>(relevantList);
    Collections.shuffle(temp);
    return temp;
    }else{
      return new LinkedList<Integer>();
    }
  }

  synchronized public void notifyAllServersFailed() {
    if(!p2pMode){
      p2pMode = true;
      System.out.println("moving to p2p mode");
      timer.schedule(new TimerTask(){
        public void run(){
          resetP2PMode();
        }
      }, SangminConfig.p2pModeTime);
    }
  }
  
  synchronized private void resetP2PMode(){
      System.out.println("moving to client-server mode");
    p2pMode = false;
  }
  

  synchronized public Collection<BranchID> getSyncServers(){
    if(p2pMode){
      return syncClients;
    }else{
      return syncServers;
    }
  }

}
