package code.untrustedstorage.writeanyreadany.client;

import java.util.Collection;
import java.util.LinkedList;

import code.branchDetecting.BranchID;

public interface ServerChooserInterface {
  public enum OpType {Read, Write};

  /**
   * returns the list of servers in a random order to ensure that different nodes are likely to 
   * use different servers in a steady state.
   * @param optype
   * @return
   */
  LinkedList<Integer> getServers(OpType optype);

  /**
   * notify the serverChooser that all the nodes have failed.
   * @param optype
   */
  void notifyAllServersFailed();

  /**
   * returns the list of servers in a random order to ensure that different nodes are likely to 
   * use different servers in a steady state.
   * @param optype
   * @return
   */
  Collection<BranchID> getSyncServers();
}
