package code.untrustedstorage.writeanyreadany.server;

import java.util.Collection;
import java.util.TreeSet;

import code.AcceptVV;
import code.ObjId;
import code.branchDetecting.BranchID;
import code.simulator.Certificate;
import code.simulator.IrisNode;
import code.simulator.SimPreciseInv;
import code.simulator.agreement.Tuple;
import code.simulator.protocolFilters.SyncFilter;
import code.simulator.store.StoreEntry;

public class CommitFilter implements SyncFilter{

  CommitManager commitManager;
  
  private int numTempWrites;
  
  public CommitFilter(CommitManager cm){
    numTempWrites = 0;
    commitManager = cm;
  }
  
  private synchronized void updateUncommitedWrites(int numNewWrites){
    
    commitManager.newWritesReceived(numNewWrites);
    
  }
  
  public void notifyEpochSync(IrisNode myNode, Certificate cert)
      throws Exception{
    // TODO Auto-generated method stub

  }

  public void syncOver(IrisNode myNode, boolean success) throws Exception{
    
    if(success){
      updateUncommitedWrites(numTempWrites);
    }
    
    numTempWrites = 0;
  }

  public boolean notifySync(IrisNode myNode, AcceptVV myCVV,
      BranchID otherNodeId, TreeSet<SimPreciseInv> newUpdates,
      Collection<Tuple<ObjId, TreeSet<StoreEntry>>> addedEntries)
      throws Exception{
    assert numTempWrites == 0;
    numTempWrites = newUpdates.size();
    return true;
  }

}
