package code.untrustedstorage.writeanyreadany.server;

import code.ObjId;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.simulator.SimPreciseInv;
import code.simulator.SyncStatus;
import code.untrustedstorage.writeanyreadany.NamespaceLayout;
import code.untrustedstorage.writeanyreadany.StorageConfig;


public class CommitManager {
  
  final private IrisNode irisNode;
  final private ObjId commitObjId;
  private Thread commitThread;
  
  private boolean commitNeeded = false;
  private int uncommitedWrites;
  private boolean immediateCommit = false;
  private long lastTimeCommited = 0L; // when the most recent "force" is written

  public CommitManager(IrisNode irisNode){
    this.irisNode = irisNode;
    commitObjId = new ObjId(NamespaceLayout.getCommitObjID(irisNode.getBranchID()));
    uncommitedWrites = 0;
  }

  public void setCommitThread(CommitThread ct){
    commitThread = ct;
  }

  synchronized boolean isCommitNeeded(){
    return commitNeeded;
  }
  
  synchronized boolean isImmediateCommitNeeded(){
    return immediateCommit;
  }
  
  synchronized void newWritesReceived(int numNewWrites){
    uncommitedWrites += numNewWrites;
    if(uncommitedWrites > StorageConfig.MaxNumWritesPerCommit){
//      writeCommitObj();
      immediateCommit = true;
      commitThread.interrupt();
    } else {
      commitNeeded = true;
    }
  }
  
  private synchronized void resetStateAfterCommit(){
    lastTimeCommited = System.currentTimeMillis();
    commitNeeded = false;
    immediateCommit = false;
    uncommitedWrites = 0;
  }

  public long writeCommitObj(){
    SimPreciseInv spi = irisNode.write(commitObjId, new IrisDataObject("commit"));
    resetStateAfterCommit();
    try{
	// princem: double check whether the original data object should be passed here or is passing null Ok?
	SyncStatus ss = irisNode.pseudoSync(spi, null);
      assert ss.status == SyncStatus.SyncSuccessful;
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }
    return spi.getAcceptStamp().getLocalClock();
  }

  synchronized long getLastTimeCommitted(){
    return lastTimeCommited;
  }

} 
