package code.untrustedstorage.writeanyreadany.server;

import code.untrustedstorage.writeanyreadany.StorageConfig;


class CommitThread extends Thread{

  private CommitManager commitManager;
  private long commitInterval;

  CommitThread(CommitManager commitManager, long commitInterval){
    this.commitManager = commitManager;
    this.commitInterval = commitInterval;
    commitManager.setCommitThread(this);
    this.setDaemon(true);
    this.setName("CommitThread");
  }

  public void run(){
    assert StorageConfig.useCommit;
    long sleepDuration = commitInterval;

    while(true){

      try{
        sleep(sleepDuration);
      }catch(InterruptedException e){
        if(commitManager.isImmediateCommitNeeded()){
          System.out.println("INTERRUTED DUE TO IMMEDIATE COMMIT!");
        }
      }

      long timeElapsedSinceLastCommit = (System.currentTimeMillis() - commitManager.getLastTimeCommitted());

      if( commitManager.isImmediateCommitNeeded() || 
          (commitManager.isCommitNeeded() && timeElapsedSinceLastCommit > commitInterval) ){
        commitManager.writeCommitObj();
        sleepDuration = commitInterval;
      } else {
        if(commitManager.isCommitNeeded()){
          sleepDuration = commitInterval - timeElapsedSinceLastCommit;
        } else {
          sleepDuration = commitInterval;
        }
      }

    }
  }    

}
