package code.untrustedstorage.writeanyreadany.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;

import code.Env;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.security.SangminConfig.DebugLevel;
import code.serialization.IrisOutputStream;
import code.simulator.IrisDataObject;
import code.simulator.Node;
import code.simulator.SimPreciseInv;
import code.simulator.irisnetty.NetworkHandler;
import code.untrustedstorage.writeanyreadany.NewWriteRequestData;
import code.untrustedstorage.writeanyreadany.Request;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.Request.RequestType;

public class ForwardingQueue implements Runnable {
  Set<BranchID> otherServers; 
  NetworkHandler networkHandler;
  LinkedList<Request> queue;
  ServerListener serverListener;
  boolean shutdown;

  public ForwardingQueue(Set<BranchID> otherServers, NetworkHandler networkHandler, ServerListener serverListener){
    queue = new LinkedList<Request>();
    this.otherServers = otherServers;
    this.networkHandler = networkHandler;
    this.serverListener = serverListener;
    this.shutdown = false;
  }

  synchronized void shutdown(){
    this.shutdown = true;
    this.notifyAll();
  }

  synchronized public void add(Request o){
    queue.addLast(o);
    this.notifyAll();
  }

  synchronized public Request remove(){
    while(queue.isEmpty() && !shutdown){
      try{
        this.wait();
      }catch(InterruptedException e){
      }
    }
    if(queue.isEmpty()){
      return null;
    }
    return queue.removeFirst();
  }


  public void run(){
    ByteArrayOutputStream bs;
    IrisOutputStream tios;
    if(otherServers.size() > 0){
    while(!shutdown){
      Request req = this.remove();
      try{
        if(req != null){
          // process
          assert StorageConfig.useNetty;
          long[] ids = new long[otherServers.size()];
          if(SangminConfig.debugLevel == DebugLevel.Verbose)System.out.println(serverListener.irisNode.getBranchID() + " fwding request " + req);
          int i=0;
          // forward the request
          bs = new ByteArrayOutputStream(1000);
          tios = new IrisOutputStream(bs);
          req.writeToStream(tios, true);
          tios.flush();
          NewWriteRequestData nwrd = (NewWriteRequestData)req.data;
          long receivedBytes = bs.size();
          long bodySize  =nwrd.getData().getUnsafeBytes().length;
          for (BranchID bid : otherServers){
            ids[i++] = bid.getIDint();
            Env.logEvent(System.currentTimeMillis() + " GOSSIP myId: " + serverListener.getId() + " senderId: " + bid.getIDint() +
                " sentBytes: " + 0 + " receivedBytes: " + receivedBytes + " bodyBytes: " + bodySize + " metadataSize: " + (receivedBytes-bodySize));
          }
          networkHandler.send(ids, bs.toByteArray());

        }
      }catch(IOException e){
        e.printStackTrace();
      }

    }
    }
  }
}


