package code.untrustedstorage.writeanyreadany.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import code.Config;
import code.Env;
import code.NodeId;
import code.ObjId;
import code.ResultStats;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.security.SangminConfig.DebugLevel;
import code.serialization.IrisInputStream;
import code.serialization.IrisObjectInputStream;
import code.serialization.IrisObjectOutputStream;
import code.serialization.IrisOutputStream;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.IrisDataObject;
import code.simulator.IrisHashObject;
import code.simulator.IrisNode;
import code.simulator.IrisObject;
import code.simulator.NodeFactory;
import code.simulator.SimPreciseInv;
import code.simulator.SyncStatus;

import code.simulator.agreement.Tuple;
import code.simulator.irisnetty.IrisNetworkQueue;
import code.simulator.irisnetty.NetworkHandler;
import code.simulator.netty.NetworkQueue;
import code.untrustedstorage.writeanyreadany.NewWriteRequestData;
import code.untrustedstorage.writeanyreadany.P2PBodyRequestData;
import code.untrustedstorage.writeanyreadany.Reply;
import code.untrustedstorage.writeanyreadany.Request;
import code.untrustedstorage.writeanyreadany.BodyRequestData;
import code.untrustedstorage.writeanyreadany.S3Inval;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.Request.RequestType;
import code.simulator.Node;

public class ServerListener extends Thread implements NetworkQueue{

  ServerSocket ss;
  IrisNode irisNode;
  public LinkedList<Worker> workerMap;
  //  HashMap<Long, Socket> socketMap; 
  //  HashMap<Long, Tuple<IrisInputStream, IrisOutputStream>> streamMap; 


  NetworkHandler networkHandler;
  Set<BranchID> otherServers;
  private boolean shutdown;
  ForwardingQueue forwardingQueue = null;

  public ServerListener(IrisNode node, Set<BranchID> otherServers, NetworkHandler networkHandler) throws IOException{
    String name = "ServerListener for node " + node.getBranchID().getIDint();
    this.setName(name);
    this.setDaemon(true);
    this.initShutdown();
    ss = new ServerSocket(StorageConfig.ServerTCPListenPort + (int)node.getBranchID().getIDint());
    workerMap = new LinkedList<Worker>();
    irisNode = node;
    this.networkHandler = networkHandler;

    this.otherServers = otherServers;
    System.out.println("OtherServers: " + otherServers);
    if(StorageConfig.S3Emulation){
      this.forwardingQueue = new ForwardingQueue(otherServers, networkHandler, this);
      new Thread(this.forwardingQueue).start();
    }
  }


  public void run(){

    while(!getShutdown()){

      try{
        Socket s = ss.accept();
        s.setTcpNoDelay(true);
        s.setSendBufferSize(1024*1024*2);
        s.setReceiveBufferSize(1024*1024*2);
        Worker w = new Worker(s, this, networkHandler, otherServers);
        workerMap.add(w);
        w.start();
      }catch(IOException e){ 
        e.printStackTrace();
        this.close();
      }

    }
    try{
      ss.close();
    }catch(IOException e){
    }

  }

  private boolean compareShortDigest(byte[] clientDigest, LinkedList<IrisObject> list){
    byte[] myDigest = BodyRequestData.getCompactHashUsingIrisObject(list);

    if(!Arrays.equals(myDigest, clientDigest)){
      return false;
    } else {
      return true;
    }
  }

  //<<<<<<< .mine
  //  
  //  public Worker(Socket s, IrisNode node){
  //    this.setDaemon(true);
  //    this.setName("Worker of " +node.getBranchID().getIDint());
  //    socket = s;
  //    irisNode = node;
  //    
  //    namedecided = false;
  //  }
  //  
  //=======
  //>>>>>>> .r2359
  private LinkedList<IrisObject> bodyRequestedFromClient(ObjId oid, byte[] clientDigest){

    if(StorageConfig.S3Emulation){
      assert clientDigest == null;
      LinkedList<IrisObject> l = irisNode.read(oid);
      assert l != null && l.size() > 0: oid;
      return l;      
    } else {
      LinkedList<IrisObject> list = irisNode.efficientRead(oid);
      // the first cheap read and the following checks reduce 
      // the probability that the second 
      // expensive read doesn't match the client's requested bodies.
      if(list.size() > 0 && (compareShortDigest(clientDigest, list))) { 
        LinkedList<IrisObject> body_list = irisNode.immutableRead(list);
        if(body_list != null)
        {
          // double check the short digest to avoid a race condition
          // where other thread may have updated this object in the meantime
          if((compareShortDigest(clientDigest, body_list))){
            return body_list;
          }
        }else{
          assert false: "This condition shouldn't occur without garbage collection";
        }
      }

      list.clear();
      return list;      
    }

  }

  //try to obtain all bodies and if any can't be obtained then return empty list
  private LinkedList<IrisObject> bodyRequestedFromClient(ObjId oid, LinkedList<IrisHashObject> clientHash){
    LinkedList<IrisObject> body_list = irisNode.immutableRead(new LinkedList<IrisObject>(clientHash));

    if(body_list!=null && body_list.size() > 0){
      return body_list;
    }
    else{
      return new LinkedList<IrisObject>();
    }
  }



  private boolean processNewWrites(SimPreciseInv spi, IrisObject io, boolean fwd){

    SyncStatus ss = null;
    assert io instanceof IrisDataObject;
    try{
      ss = irisNode.pseudoSync(spi, (IrisDataObject)io, true);

    }catch(Exception e){
      System.err.println("NEW WRITE PSEUDOSYNC FAILED");
      e.printStackTrace();
      System.exit(-1);
    }

    if(ss != null && ss.status == SyncStatus.SyncSuccessful){
      return true;
    }else if(ss != null && ss.status == SyncStatus.NetworkError){
      return false;
    }

    // try a sync to see if we are missing a few writes that can be received 
    // via a sync
    // should only be tried for non-forwarded writes
    if(!fwd){
      try{
        ss = irisNode.exponentialBackoffSync((BranchID)spi.getNodeId(), irisNode.getCurrentVV());
      }catch(Exception e){
        System.err.println("NEW WRITE SYNC FAILED");
        e.printStackTrace();
        assert false;
      }

      if(ss != null && ss.status == SyncStatus.SyncSuccessful){
        return true;
      }
    }
    return false;
  }
  
  synchronized SimPreciseInv handleVanillaWriteReq(S3Inval s3inval){
    SimPreciseInv spi = irisNode.write(s3inval.getObjId(), s3inval.getValue());
    if(SangminConfig.separateBodies){
      spi = spi.cloneWithNewNodeId(spi.getNodeId());
      spi.replaceIrisObject(s3inval.getValue());
    }
    if(StorageConfig.useNewWriteForwarding
        && this.networkHandler != null && StorageConfig.S3Emulation && 
       otherServers.size() > 0){
      // create an appropriate req
      assert otherServers.size() == 1;
      BranchID nextServer = otherServers.iterator().next();
      if(SangminConfig.debugLevel==DebugLevel.Verbose)System.out.println("forwarding write: " + spi + " to " + otherServers  );
      if(nextServer.equals(spi.getNodeId())){
        if(SangminConfig.debugLevel==DebugLevel.Verbose)System.out.println("skipping fwding");
        return spi;
      }
      Request req = new Request(RequestType.NEW_WRITES, new NewWriteRequestData((SimPreciseInv)spi, 
          (IrisDataObject)((SimPreciseInv)spi).getData()));
      this.forwardingQueue.add(req);
    }
    return spi;
  }

  

  Tuple<Reply, SimPreciseInv> processRequest(Request req, boolean fwd){
    Reply rep;
    SimPreciseInv spi = null;
    if(req.type == RequestType.NEW_WRITES){
      long t1 = System.currentTimeMillis();

      Hash hash = null;
      if(StorageConfig.S3Emulation && !fwd){
        S3Inval s3inval = (S3Inval)req.data;
        /*        if(SangminConfig.hackedSignature){
          try{
            s3inval.getValue().verify();
          }catch(IOException e){
            e.printStackTrace();
            assert false: "verification of hackedSignature failed";
          }
	  }*/
        //hash = s3inval.getValue().getHash();
        spi = this.handleVanillaWriteReq(s3inval);
        rep  = new Reply(req.type, true);

      } else {
        NewWriteRequestData nwrd = (NewWriteRequestData)req.data;
        spi = nwrd.getInval();
        //prince: hack to off load some work
        hash = nwrd.getData().getHash();
        //        spi.replaceIrisObject(nwrd.getData());
        boolean res = processNewWrites(spi, nwrd.getData(), fwd);
        if(SangminConfig.echoWrittenObject){
          rep = new Reply(req.type, new Tuple<Boolean, IrisDataObject>(res, nwrd.getData()));
        }else{
          rep = new Reply(req.type, res);
        }
      }

      if(SangminConfig.fineGrainedTracking)System.out.println( hash + " " + irisNode.getBranchID() + " NEW_WRITE PROCESS TIME " + (System.currentTimeMillis() - t1));

    } else if (req.type == RequestType.REQUEST_BODY ){
      long t1 = System.currentTimeMillis();

      BodyRequestData brd = (BodyRequestData)req.data;
      LinkedList<IrisObject> res = bodyRequestedFromClient(brd.getObjId(), brd.getDigest());
      assert res != null;
      rep = new Reply(req.type, res);

      Env.logWrite(brd.getObjId() + " " + irisNode.getBranchID() + " GET BODY PROCESS TIME " + (System.currentTimeMillis() - t1));
      if(SangminConfig.fineGrainedTracking)System.out.println(brd.getObjId() + " " + irisNode.getBranchID() + " GET BODY PROCESS TIME " + (System.currentTimeMillis() - t1));


    } else if (req.type == RequestType.REQUEST_P2P_BODY){
      long t1 = System.currentTimeMillis();

      P2PBodyRequestData brd = (P2PBodyRequestData)req.data;
      LinkedList<IrisObject> res = bodyRequestedFromClient(brd.getObjId(), brd.getHashes());
      assert res != null;
      rep = new Reply(req.type, res);

      Env.logWrite(brd.getObjId() + " " + irisNode.getBranchID() + " GET BODY PROCESS TIME " + (System.currentTimeMillis() - t1));
      if(SangminConfig.fineGrainedTracking)System.out.println(brd.getObjId() + " " + irisNode.getBranchID() + " GET BODY PROCESS TIME " + (System.currentTimeMillis() - t1));


    } else {
      assert false;
      rep = null;
    }

    return new Tuple<Reply, SimPreciseInv>(rep, spi);
  }

  public void addWork(byte[] msg){
    Request req = new Request();
    IrisInputStream ois;
    try{
      ois = new IrisInputStream(new ByteArrayInputStream(msg));
      req.readFromStream(ois, true);
    }catch(IOException e){
      e.printStackTrace();
      System.exit(-1);
    }
    if(SangminConfig.debugLevel == DebugLevel.Verbose)System.out.println(this.irisNode.getBranchID() + " received NEW WRITE REQ RECEIVED BY FORWARDING" + req);
    
    if(StorageConfig.S3Emulation && otherServers.size() > 0){
      //forward writes
      assert req.type == Request.RequestType.NEW_WRITES;
      NewWriteRequestData nwrd = (NewWriteRequestData)req.data;
      SimPreciseInv spi = nwrd.getInval();
      assert otherServers.size() == 1;
      BranchID nextServer = otherServers.iterator().next();
      if(nextServer.getIDint() != spi.getNodeId().getIDint()){
        // forward writes only if the next server is not the creator
        this.forwardingQueue.add(req);
      }
    }
    Reply rep = processRequest(req, true).getKey();
    if(rep.getData() != Boolean.TRUE){
      if(SangminConfig.debugLevel == DebugLevel.Verbose)System.out.println("forwarded request was rejected");
      //processRequest(req, true);
    }
  }


  synchronized private void setShutdown(){
    this.shutdown = true;
  }

  synchronized private void initShutdown(){
    this.shutdown = false;
  }

  synchronized private boolean getShutdown(){
    return shutdown;
  }

  public void close(){
    this.setShutdown();
    if(this.forwardingQueue != null){
      this.forwardingQueue.shutdown();
    }
    try{
      this.ss.close();
    }catch(IOException e){
      e.printStackTrace();
    }
    for(Worker w: this.workerMap){
      w.shutdown();
    }
  }

}

class Worker extends Thread{

  private boolean shutdown = false;
  Socket socket;
  ServerListener serverListener;
  BranchID myID;
  private boolean namedecided;

  NetworkHandler networkHandler;
  Set<BranchID> otherServers;

  public Worker(Socket s, ServerListener sl, NetworkHandler netHandler, Set<BranchID> otherServers){
    this.setDaemon(true);
    myID = sl.irisNode.getBranchID();
    this.setName("Worker of " + myID);
    socket = s;
    serverListener = sl;
    namedecided = false;
    networkHandler = netHandler;
    this.otherServers = otherServers;
  }

  public void shutdown(){
    this.shutdown = true;
    try{
      socket.close();
    }catch(IOException e){
      e.printStackTrace();
    }
  }

  @SuppressWarnings("unchecked")
  public void run(){
    IrisInputStream ois;
    IrisOutputStream ios;

    long startSend = 0;
    try{
      if(!SangminConfig.useByteArraysForIO){
        ois = new IrisInputStream(socket.getInputStream());
        ios = new IrisOutputStream(socket.getOutputStream());
      }
      while(!shutdown){        
        Request req = new Request();
        if(SangminConfig.useByteArraysForIO){
          byte []buf = SerializationHelper.getBufWithoutLength(socket.getInputStream());
          ois = new IrisInputStream(new ByteArrayInputStream(buf));
        }else{
          startSend = ios.getBytes();
        }    	  
        req.readFromStream(ois, true);
        long t1 = System.currentTimeMillis();

        if(SangminConfig.debugLevel == DebugLevel.Verbose || myID.getIDint() > 3)System.out.println(System.currentTimeMillis() + " serverListener read request " + req);
        if(!namedecided){ // sets the name of this thread
          if(req.data instanceof SimPreciseInv){
            SimPreciseInv spi = (SimPreciseInv)req.data;
            this.setName("Worker of " +myID.getIDint() + " connected to " + spi.getNodeId());
            namedecided = true;
          }
        }

        // process the request
        Tuple<Reply, SimPreciseInv> prRep = serverListener.processRequest(req, false);
        Reply rep = prRep.getKey();
        long tt = System.currentTimeMillis();

        assert rep.getType() == req.type;
        String tmpStr;

        ByteArrayOutputStream bs;
        if(SangminConfig.useByteArraysForIO){
          bs = new ByteArrayOutputStream(40);
          ios = new IrisOutputStream(bs);
        }
        rep.writeToStream(ios, false);
        ios.flush();
        if(SangminConfig.debugLevel == DebugLevel.Verbose)System.out.println(System.currentTimeMillis() + " serverListener sent reply " + rep); 
        if(SangminConfig.useByteArraysForIO){
          socket.getOutputStream().write(SerializationHelper.getBufWithLength(bs.toByteArray()));
        }
        long fullsize = ios.getBytes()-startSend;
        if(rep.getType() == RequestType.NEW_WRITES){         
          Env.logWrite(myID + " sent " + fullsize + " as NewWriteReply to some client");
          tmpStr = "NEW_WRITE";
          if(SangminConfig.debugLevel == DebugLevel.Verbose)System.out.println(this.serverListener.irisNode.getBranchID() + " received " + req + " directly from client; \n reply" + rep);
        } else {
          long bodysize = 0;
          LinkedList<IrisDataObject> res = (LinkedList<IrisDataObject>) rep.getData();
          for(IrisDataObject ido:res){
            bodysize += ido.getUnsafeBytes().length + 1 /* for length*/ + 2/**/;
          }

          Env.logWrite(myID + " sent " + (fullsize-bodysize) + " as BodyReply-metadata to some client");
          Env.logWrite(myID + " sent " + bodysize + " as BodyReply-bodies to some client");
          tmpStr = "BODY_REQ";
        }
	long tt1 = System.currentTimeMillis();
        if(SangminConfig.fineGrainedTracking)System.out.println("TIME SPENT FOR REQUEST PROCESS " + tmpStr + " " + (tt1-t1) +  " " + (tt-t1));
        // forwarding new write request to other servers
        if(StorageConfig.useNewWriteForwarding
            && req.type == RequestType.NEW_WRITES && this.networkHandler != null && !StorageConfig.S3Emulation && 
	   otherServers.size() > 0){
          assert StorageConfig.useNetty;
          long[] ids = new long[otherServers.size()];
          if(SangminConfig.debugLevel == DebugLevel.Verbose)System.out.println(serverListener.irisNode.getBranchID() + " fwding request " + req);
          int i=0;
          // forward the request
          bs = new ByteArrayOutputStream((int)fullsize);
          IrisOutputStream tios = new IrisOutputStream(bs);
          req.writeToStream(tios, true);
          tios.flush();
          NewWriteRequestData nwrd = (NewWriteRequestData)req.data;
          long receivedBytes = bs.size();
          long bodySize  =nwrd.getData().getUnsafeBytes().length;
          for (BranchID bid : otherServers){
            ids[i++] = bid.getIDint();
            Env.logEvent(System.currentTimeMillis() + " GOSSIP myId: " + myID + " senderId: " + bid.getIDint() +
                " sentBytes: " + 0 + " receivedBytes: " + receivedBytes + " bodyBytes: " + bodySize + " metadataSize: " + (receivedBytes-bodySize));
          }
          networkHandler.send(ids, bs.toByteArray());

        }

      }

    } catch (Exception e){
      e.printStackTrace();
      try{
        socket.close();
      }catch(IOException e1){
      }
      System.err.println("MY Node ID " + myID);
      return;
    }

    try{
      socket.close();
    }catch(IOException e){
      e.printStackTrace();
    }
  }


}
