package code.untrustedstorage.writeanyreadany.unit;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.LinkedList;

import code.NoSuchEntryException;
import code.ObjId;
import code.simulator.IrisDataObject;
import code.simulator.IrisHashObject;
import code.simulator.IrisNode;
import code.simulator.IrisObject;
import code.simulator.NodeFactory;
import code.simulator.SimPreciseInv;
import code.simulator.SyncStatus;
import code.untrustedstorage.writeanyreadany.CommitCutFilter;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.client.ClientCachingPolicy;
import code.untrustedstorage.writeanyreadany.server.CommitManager;
import code.untrustedstorage.writeanyreadany.server.ServerNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CommitCutFilterUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public CommitCutFilterUnit (final String s) {
    super (s);
  }
  protected void setUp() throws Exception{
    super.setUp();
    SimpleUnit.makeIrisConfig(0, 10);
    
  }

  public void NONtestPseudoSync(){
    HashSet<Integer> s = new HashSet<Integer>();
    s.add(0);
    s.add(1);
    s.add(2);
    
    StorageConfig.CommitQuorumSize = 2;
    CommitCutFilter ccf = new CommitCutFilter(null);
    
    IrisNode irisNode_0 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(0));
    IrisNode irisNode_1 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(1));
    IrisNode irisNode_2 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(2));
    
    CommitManager cm_0 = new CommitManager(irisNode_0);
    CommitManager cm_1 = new CommitManager(irisNode_1);
//    CommitManager cm_2 = new CommitManager(irisNode_2);
    
    IrisNode client = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(3));
    irisNode_0.addSyncFilter(ccf);
    
    ObjId oid = new ObjId("/test");
    client.write(oid, new IrisDataObject("test"));
    
    try{
      irisNode_0.exponentialBackoffSync(client);
      cm_0.writeCommitObj();
      irisNode_1.exponentialBackoffSync(irisNode_0);
      cm_1.writeCommitObj();
      
    }catch(Exception e){
      e.printStackTrace();
    }
    
    try{
      long ts = ccf.getCommitCut().getStampByServer(client.getBranchID());
      assert ts == 0;
    }catch(NoSuchEntryException e){
      // TODO Auto-generated catch block
      assert false;
    }
    
    
  }
  public void testCommitCutFilter(){
    HashSet<Integer> s = new HashSet<Integer>();
    s.add(0);
    s.add(1);
    s.add(2);
    
    CommitCutFilter ccf = new CommitCutFilter(null);
    
    IrisNode irisNode_0 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(0));
    IrisNode irisNode_1 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(1));
    IrisNode irisNode_2 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(2));
    
    IrisNode irisNode_c0 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(5));
    IrisNode irisNode_c1 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(6));
//    IrisNode irisNode_c2 = (IrisNode) NodeFactory.createIrisNode(NodeFactory.createNodeId(7));
    
    
    CommitManager cm_0 = new CommitManager(irisNode_0);
    CommitManager cm_1 = new CommitManager(irisNode_1);
    CommitManager cm_2 = new CommitManager(irisNode_2);
    
    
    irisNode_c0.addSyncFilter(ccf);
    
    ObjId oid = new ObjId("/test");
    irisNode_c0.write(oid, new IrisDataObject("test"));
    
    try{
      irisNode_0.exponentialBackoffSync(irisNode_c0);
      cm_0.writeCommitObj();
      
      irisNode_1.exponentialBackoffSync(irisNode_0);
      cm_1.writeCommitObj();
      
      irisNode_2.exponentialBackoffSync(irisNode_1);
      cm_2.writeCommitObj();
      
      irisNode_0.exponentialBackoffSync(irisNode_2);
      irisNode_c0.exponentialBackoffSync(irisNode_0);
      
      
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
    try{
      long ts = ccf.getCommitCut().getStampByServer(irisNode_c0.getBranchID());
      assert ts == 0;
    }catch(NoSuchEntryException e){
      // TODO Auto-generated catch block
      assert false;
    }
    
    ObjId oid2 = new ObjId("/test2");
    SimPreciseInv spi = irisNode_c1.write(oid2, new IrisDataObject("test2"));
    irisNode_c1.removeBody(spi.getData().getHash());
    
    try{
      SyncStatus ss = irisNode_c0.exponentialBackoffSync(irisNode_c1);
      assert ss.status == SyncStatus.SyncFilterReject;
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    
    //
    // Check if ClientCachingPolicy cleans up bodies for committed writes
    //
    
    CommitCutFilter ccf1 = new CommitCutFilter(new ClientCachingPolicy());
    irisNode_c1.addSyncFilter(ccf1);
    try{
      SyncStatus ss = irisNode_c1.exponentialBackoffSync(irisNode_0);
      assert ss.status == SyncStatus.SyncSuccessful;
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
    LinkedList<IrisObject> l = irisNode_c1.read(oid);
    assert l.getFirst() instanceof IrisHashObject;
    
    
    
  }
  
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "/test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(CommitCutFilterUnit.class);
    return suite;
  }
  
  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "/test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "CommitCutFilterUnit";
    System.err.print(name + " self test begins...\n");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }
}
