package code.untrustedstorage.writeanyreadany.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

import code.Env;
import code.LatencyWatcher;
import code.ObjId;
import code.ResultStats;
import code.lasr.db.DbException;
import code.lasr.db.DbTransaction;
import code.lasr.db.TxnFailedException;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.simulator.IrisObject;
import code.simulator.Node;
import code.simulator.NodeFactory;
import code.simulator.SimPreciseInv;
import code.simulator.persistentLog.PersistentStore;
import code.simulator.store.BodyStoreInterface;
import code.simulator.store.PersistentBodyStore;
import code.untrustedstorage.writeanyreadany.Reply;
import code.untrustedstorage.writeanyreadany.client.ClientNode;
import code.untrustedstorage.writeanyreadany.client.ClientNodeWrapper;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.Request.RequestType;
import code.security.SangminConfig;

public class IrisWriteLatencyTest{

  private final static int NUM = 1000;
  static PersistentStore pe = null;
  static BodyStoreInterface bodyStore = null;
  
  public static void readTest(IrisNode irisNode, int datasize){
    
    ResultStats stats = new ResultStats();

    long t1, t2;
    byte[] data = new byte[datasize];
    for(int n=0; n<NUM; n++){
      ObjId oid = new ObjId("/" + String.format("%19d", n));
      for(int i=0; i < 3; i++){
	  data[i] = (byte) (i+n);
      }
      t1 = System.nanoTime();
      LinkedList<IrisObject> irso = irisNode.read(oid);
      assert irso.size() ==1: oid + "  " + irso;
      assert irso.getFirst() instanceof IrisDataObject;
      t2 = System.nanoTime();
      stats.enter(t2-t1);
      IrisDataObject ido = (IrisDataObject)irso.getFirst();
      //      assert Arrays.equals(data, ido.getUnsafeBytes()): n + " " + oid + "\n data:" + Arrays.toString(data) +"\n read data:" + Arrays.toString(ido.getUnsafeBytes());
    }
    System.out.println(LatencyWatcher.getSummary());
    System.out.println("###### IRIS READ TIME!!");
    System.out.println(stats.getSummary(1));
    System.out.println(stats.getAverage90());
  }

  public static void writeTest(IrisNode irisNode, int datasize){
    if(SangminConfig.hackedStore){
      String dbPath = SangminConfig.configFile+1;//Config.getLocalStore(branchId);
      System.out.println("dbPath for node " + 1 + " is " + dbPath);
      try{
        pe = new PersistentStore(dbPath, SangminConfig.BDBCacheSize, true, SangminConfig.syncToDisk);
        bodyStore = new PersistentBodyStore(pe);
      }catch(DbException e){
        e.printStackTrace();
        assert false;
      }catch(IOException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      } 
    }
    ResultStats stats = new ResultStats();
    long t1, t2;
    //    LinkedList l = new LinkedList();
    byte[] data = new byte[datasize];
    if(SangminConfig.hackedHash || SangminConfig.hackedSignature){
      ClientNodeWrapper.byteArray = data;
      try{
        ClientNodeWrapper.cachedIrisDataObject = IrisDataObject.createIrisDataObject(data, 0);
      }catch(IOException e){
        e.printStackTrace();
      }
    }
    for(int n=0; n<NUM; n++){
      ObjId oid = new ObjId("/" + String.format("%19d", n)); 
	//      for(int i=0; i < datasize; i++){
      for(int i=0; i < 3; i++){
	  data[i] = (byte) (i+n);
      }
      //      l.add(data);
      //      if(l.size() == 100){
      //  l.removeFirst();
      //}
      
      IrisDataObject ido = null;
      t1 = System.nanoTime();
      if(SangminConfig.hackedSignature || SangminConfig.hackedHash){
	  try{
	      ido = IrisDataObject.createIrisDataObject((byte[])data, 0);
	      // ido = IrisDataObject.createIrisDataObject(ClientNode.byteArray, (byte[])data, 0);
	  }catch(IOException e){
	      e.printStackTrace();
	      assert false;
	  }                              
      }else{
	  ido = new IrisDataObject((byte[])data);     
      }
      
      if(!StorageConfig.S3Emulation){
        SimPreciseInv spi = irisNode.write(oid, ido);
      }else if(SangminConfig.hackedStore){
        DbTransaction txn = pe.getDB().newTransaction();
        bodyStore.addBody(txn, ido);
        try{
          txn.sync();
        }catch(TxnFailedException e){
          e.printStackTrace();
          txn.abort();
        }
      }
      //      System.out.println("writing " + oid  + " " + ido);
      t2 = System.nanoTime();
      stats.enter(t2-t1);
//      try{
//        Thread.sleep(250);
//        }catch(Exception e){
//            
//        }
    }
    System.out.println(LatencyWatcher.getSummary());
    System.out.println("###### IRIS WRITE TIME!!");
    System.out.println(stats.getSummary(1));
    System.out.println(stats.getAverage90());
  }

//  public static void serializatoinTest(int datasize) throws IOException, ClassNotFoundException{
//
//    byte[] data = new byte[datasize];
//    for(int i=0; i < datasize; i++){
//      data[i] = (byte)i;
//    }
//
//    IrisDataObject ido = new IrisDataObject(data);
//    LinkedList<IrisDataObject> ll = new LinkedList<IrisDataObject>();
//    ll.add(ido);
//
//    Reply rep = new Reply(RequestType.REQUEST_BODY, ll);
//
//    ResultStats stats1 = new ResultStats();
//    ResultStats stats2 = new ResultStats();
//    for(int i=0; i<1; i++){
//
//      ByteArrayOutputStream baos = new ByteArrayOutputStream();
//      IrisOutputStream ios = new IrisOutputStream(baos);
//      rep.writeExternal(ios);
//      ios.flush();
//
//      byte[] b = baos.toByteArray();
//
//      ByteArrayInputStream bais = new ByteArrayInputStream(b);  
//
//      Reply rep2 = new Reply();
//      long t1 = System.nanoTime();
//
//      rep2.readExternal(new IrisInputStream(bais));
//
//
//      stats1.enter((System.nanoTime() - t1));
//      if(!rep2.equals(rep)){
//        System.err.println("REP2 WRONG");
//        System.exit(-1);
//      }
//      
//      ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
//      rep.writeToStream(baos2);
//      baos2.flush();
//
//      byte[] b2 = baos2.toByteArray();
//      ByteArrayInputStream bais2 = new ByteArrayInputStream(b2);
//
//      Reply rep3 = new Reply();
//      long t2 = System.nanoTime();
//      rep3.readFromStream(bais2);
//      stats2.enter((System.nanoTime() - t2));
//      if(!rep3.equals(rep)){
//        System.err.println("REP3 WRONG");
//        System.exit(-1);
//      }
//
//    }
//    
//    System.out.println(stats1.getAverage90());
//    System.out.println(stats1.getSummary(0));
//    System.out.println(stats2.getAverage90());
//    System.out.println(stats2.getSummary(0));
//
//  }

  public static void main(String[] args) throws IOException, ClassNotFoundException{

      System.out.println("doing NUM " + NUM + " writes");
    SangminConfig.hackedHash = false;SangminConfig.hackedStore = false;SangminConfig.hackedSignature = false;Node.enableSecurity = true;Node.useSignature=true;
    ResultStats.logData = true;
    if(args.length > 0){
      StorageConfig.readConfig(args[0]);
    }
    int datasize = StorageConfig.objSize;
    SimpleUnit.makeIrisConfig(0, 1);

    IrisNode.measureTime = true;
    IrisNode irisNode = (IrisNode) NodeFactory.createIrisNode(
        NodeFactory.createNodeId(0));

    try{
    Thread.sleep(2000);
    }catch(Exception e){
	
    }
    Env.logWrite("Write started");
    writeTest(irisNode, datasize);
    System.out.println("Write finished");
    try{
    Thread.sleep(2000);
    }catch(Exception e){
	
    }
    Env.logWrite("Read started");
     /*   readTest(irisNode, datasize);
    try{
    Thread.sleep(2000);
    }catch(Exception e){
	
    }*/
  }

}
