package code.untrustedstorage.writeanyreadany.unit;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;

import code.Config;
import code.NodeId;
import code.ObjId;
import code.branchDetecting.BranchID;
import code.simulator.Node;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.client.ClientNode;
import code.untrustedstorage.writeanyreadany.client.DataNotFound;
import code.untrustedstorage.writeanyreadany.server.ServerNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class S3EmulUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public S3EmulUnit (final String s) {
    super (s);
  }
  
  protected void setUp() throws Exception{
    super.setUp();
    makeIrisConfig(0, 30);    
  }

  public static void makeIrisConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";
    
    for(int i = 0; i < total; i++){
      
      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
                              NODE_1_IP,
                            port++,
                            port++,
                            port++,
                            port++,
                            port++,
                            "/test" + File.separatorChar + "local-" + 
                            NODE_1_ID + ".db",
                            "/*",
                            -1L,
                            NODE_1_IP,
                            port++,
                            port++,
                            -1,
                            Config.CACHE_SIZE_BYTES_DEFAULT,
                            Config.MAX_LOG_DISK_SIZE_BYTES,
                            Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();
  }
  
  public void testSimple1(){
    StorageConfig.useBeacon = false;
    StorageConfig.useCommit = false;
    StorageConfig.S3Emulation = true;
    Node.useSignature = false;
    Node.enableSecurity = false;
    
    StorageConfig.ClientServerSyncInterval = -1L;
    
    HashSet<Integer> s = new HashSet<Integer>();
    s.add(0);
    s.add(1);
    s.add(2);
    s.add(3);

    StorageConfig.addServer(0, s);
    StorageConfig.addServer(1, s);  
    StorageConfig.addServer(2, s);
    StorageConfig.addServer(3, s);
    
    HashSet<Integer> st0 = new HashSet<Integer>();
    st0.add(0);
    StorageConfig.addClient(4, 0, 0, st0);
    HashSet<Integer> st1 = new HashSet<Integer>();
    st1.add(2);
    StorageConfig.addClient(5, 2, 2, st1);
    
    System.out.println("Configurtaion done.");
    Set<Integer> serverSet = StorageConfig.getServerIdSet();
    ServerNode[] serverNodes = new ServerNode[serverSet.size()];
    for(Integer serverid : serverSet){
      try{
        serverNodes[serverid] =
          new ServerNode(new BranchID(serverid),
            StorageConfig.serverMap.get(serverid));
        serverNodes[serverid].start();
      }catch(Exception e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }
    }
    System.out.println("Servers Created..");
//    for(Integer serverid : serverSet){
//      serverNodes[serverid].start();
//    }
    System.out.println("Servers Started..");
    HashMap<Integer, ClientNode> clientMap = new HashMap<Integer, ClientNode>();
    for(Integer clientid : StorageConfig.getClientIdSet()){
      try{
        ClientNode c = new ClientNode(clientid, 
            StorageConfig.Client2WriteServerMap.get(clientid),
            StorageConfig.Client2ReadServerMap.get(clientid),
            StorageConfig.Client2SyncServerMap.get(clientid),
            StorageConfig.getClientIdSet(), 
            StorageConfig.getServerIdSet());
        clientMap.put(clientid, c);
        
      }catch(Exception e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }
    }
    
    System.out.println("Clients Created..");
    
    
    Random r= new Random();
    ObjId oid;
    int numObj = StorageConfig.numObjs;
    float readRatio = StorageConfig.readRatio;
    byte[] data = new byte[StorageConfig.objSize];
    
    long sleepDuration = StorageConfig.ClientWriteInterval;
    long t1;
    long t2;
    while(true){
      t1 = System.currentTimeMillis();
      oid = new ObjId("/" + r.nextInt(numObj));
      if(r.nextFloat() < readRatio){
        try{
          clientMap.get(4).read(oid);
        }catch(DataNotFound e){
        }
      } else {
        data[0] = (byte) t1;
        clientMap.get(4).write(oid, data);
      }
      t2 = System.currentTimeMillis();
      sleepDuration = StorageConfig.ClientWriteInterval - ( t2 - t1);
      if(sleepDuration>0)
      try{
        Thread.sleep(sleepDuration);
      }catch(InterruptedException e){
      }
    }

  }
  
 
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "/test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(S3EmulUnit.class);
    return suite;
  }
  
  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "/test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "S3EmulUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }
}
