package code.untrustedstorage.writeanyreadany.unit;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;

import code.Config;
import code.NodeId;
import code.ObjId;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.simulator.Node;
import code.simulator.SyncRequest;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.client.ClientNode;
import code.untrustedstorage.writeanyreadany.client.ClientNodeWrapper;
import code.untrustedstorage.writeanyreadany.client.DataNotFound;
import code.untrustedstorage.writeanyreadany.server.ServerNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SimpleUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public SimpleUnit (final String s) {
    super (s);
  }
  
  protected void setUp() throws Exception{
    super.setUp();
    makeIrisConfig(0, 30);
    try{
      Thread.sleep(2000);
    }catch(Exception e){
    }
  }
  
  
  public static void makeIrisConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9921;
    String NODE_1_IP = "localhost";
    
    for(int i = 0; i < total; i++){
      
      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
                              NODE_1_IP,
                            port++,
                            port++,
                            port++,
                            port++,
                            port++,
                            "/test" + File.separatorChar + "local-" + 
                            NODE_1_ID + ".db",
                            "/*",
                            -1L,
                            NODE_1_IP,
                            port++,
                            port++,
                            -1,
                            Config.CACHE_SIZE_BYTES_DEFAULT,
                            Config.MAX_LOG_DISK_SIZE_BYTES,
                            Config.MAX_LOG_MEM_SIZE_BYTES);
    }

    Config.readKeys();
  }
  

  public void testSimple1(){

    int numOps = 40;
    StorageConfig.useBeacon = false;
    StorageConfig.useClientBodyCleanup = false;
    StorageConfig.useCommit = false;
    StorageConfig.NoBodyOnClientServerSync = true;
    StorageConfig.ClientServerSyncInterval = 5000;
//    SangminConfig.BodyConfig = SyncRequest.CheckpointBodies|SyncRequest.UncommittedLastBodies;
//    SangminConfig.BodyConfig = SyncRequest.NoBodies;
    Node.useSignature = true;
    Node.enableSecurity = true;
    SangminConfig.useHash = true;
    SangminConfig.usePersistentStore = false;
    
    StorageConfig.S3Emulation = false;
    SangminConfig.hackedHash = false;
    SangminConfig.hackedSignature = false;
    
    StorageConfig.simulateSSPartition = false;
    StorageConfig.firstSSPartitionStart = 20000;
    StorageConfig.firstSSPartitionEnd = 40000;
    
    StorageConfig.simulateClientPartition = false;
    StorageConfig.firstClientPartitionStart = 20000;
    StorageConfig.firstClientPartitionEnd = 40000;
    
    HashSet<Integer> s = new HashSet<Integer>();
    s.add(0);
    s.add(2);
//    s.add(2);
//    StorageConfig.addServers(s);
    
    StorageConfig.addServer(0, s);
    StorageConfig.addServer(2, s);
    
    HashSet<Integer> st0 = new HashSet<Integer>();
    st0.add(0);
    StorageConfig.addClient(6, 0, 0, st0);
    HashSet<Integer> st1 = new HashSet<Integer>();
    st1.add(2);
    StorageConfig.addClient(7, 2, 2, st1);
    
    System.out.println("Configuration done.");
    Set<Integer> serverSet = StorageConfig.getServerIdSet();
    LinkedList<ServerNode> serverNodes = new LinkedList<ServerNode>();
    for(Integer serverid : serverSet){
      try{
        serverNodes.add(
          new ServerNode(new BranchID(serverid),
            StorageConfig.serverMap.get(serverid)));
//        serverNodes[serverid].start();
        Thread.sleep(1000);
      }catch(Exception e){
        e.printStackTrace();
        assert false;
      }
    }
    
    System.out.println("Servers Created..");
    for(ServerNode serverNode : serverNodes){
      serverNode.start();
    }
    
    System.out.println("Servers Started..");
    HashMap<Integer, ClientNode> clientMap = new HashMap<Integer, ClientNode>();
    for(Integer clientid : StorageConfig.getClientIdSet()){
      try{
//        clientMap.put(clientid, new ClientNode(clientid, StorageConfig.getClient2ServerMap().get(clientid),serverSet, StorageConfig.getClient2ServerMap().keySet() ));
        ClientNode c = new ClientNode(clientid, 
            StorageConfig.Client2WriteServerMap.get(clientid),
            StorageConfig.Client2ReadServerMap.get(clientid),
            StorageConfig.Client2SyncServerMap.get(clientid),
            StorageConfig.getClientIdSet(), 
            StorageConfig.getServerIdSet());
        clientMap.put(clientid, c);
        
      }catch(Exception e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }
    }
//    System.out.println( "BODY CONFIG : " + Config.getBodyConfig(new NodeId(6)));
    System.out.println("Clients Created..");

    //ObjId testoid = new ObjId("/1");
    ObjId testoid = new ObjId(ClientNodeWrapper.getKeyString(1));
    StorageConfig.objSize = 3;
    byte[] data = new byte[StorageConfig.objSize];
    for(int i=0; i<data.length; i++){
      data[i] = (byte)i;
    }
//    clientMap.get(6).write(testoid, data);
    byte[] b = new byte[1];
    b[0] = 127;
    clientMap.get(7).write(testoid, b);
    try{
//      LinkedList<Object> a = clientMap.get(6).read(testoid);
      //assert Arrays.equals(data, (byte[]) a.getFirst());
//      System.out.println("my read : " + a);
      Thread.sleep(2000);
      b[0] = 0;
      boolean quit = false;
      int count = 0;
      while(count < numOps){
        count++;
        b[0] += 1;
//        clientMap.get(6).write(testoid, data);
        clientMap.get(6).write(testoid, b);
        Thread.sleep(2000);
        
        LinkedList<Object> l = clientMap.get(7).read(testoid);
//        assert Arrays.equals(data, (byte[]) l.getFirst());
        if(l.size() > 0){
          System.out.println("read : " + ((byte[])l.getFirst())[0]);
        } else {
          System.out.println("read : [ ]");
        }
        Thread.sleep(2000);
//        if(l.size()>0){
//          break;
//        }
        if(quit){
          break;
        }
        
      }
    }catch(DataNotFound e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }catch(InterruptedException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    for(ClientNode cn:clientMap.values()){
      cn.shutdown();
    }
    for(ServerNode sn: serverNodes){
      sn.shutdown();
    }
  }
  
  public void testFailover(){

    int numOps = 40;
    StorageConfig.useBeacon = false;
    StorageConfig.useClientBodyCleanup = false;
    StorageConfig.useCommit = false;
    StorageConfig.NoBodyOnClientServerSync = true;
    StorageConfig.ClientServerSyncInterval = 5000;
//    SangminConfig.BodyConfig = SyncRequest.CheckpointBodies|SyncRequest.UncommittedLastBodies;
//    SangminConfig.BodyConfig = SyncRequest.NoBodies;
    Node.useSignature = true;
    Node.enableSecurity = true;
    SangminConfig.useHash = true;
    SangminConfig.usePersistentStore = false;
    
    StorageConfig.S3Emulation = false;
    SangminConfig.hackedHash = false;
    SangminConfig.hackedSignature = false;
    
    StorageConfig.simulateSSPartition = false;
    StorageConfig.firstSSPartitionStart = 20000;
    StorageConfig.firstSSPartitionEnd = 40000;
    
    StorageConfig.simulateClientPartition = false;
    StorageConfig.firstClientPartitionStart = 20000;
    StorageConfig.firstClientPartitionEnd = 40000;
    
    HashSet<Integer> s = new HashSet<Integer>();
    s.add(0);
    s.add(2);
//    s.add(2);
//    StorageConfig.addServers(s);
    
    StorageConfig.addServer(0, s);
    StorageConfig.addServer(2, s);
    
    HashSet<Integer> st0 = new HashSet<Integer>();
    st0.add(0);
    StorageConfig.addClient(6, 0, 0, st0);
    HashSet<Integer> st1 = new HashSet<Integer>();
    st1.add(2);
    StorageConfig.addClient(7, 2, 2, st1);
    
    System.out.println("Configuration done.");
    Set<Integer> serverSet = StorageConfig.getServerIdSet();
    LinkedList<ServerNode> serverNodes = new LinkedList<ServerNode>();
    for(Integer serverid : serverSet){
      try{
        serverNodes.add(
          new ServerNode(new BranchID(serverid),
            StorageConfig.serverMap.get(serverid)));
        try{
          Thread.sleep(1000);
        }catch(Exception e){
        }
      }catch(Exception e){
        e.printStackTrace();
        assert false;
      }
    }
    
    long starttime = System.currentTimeMillis();
    
    System.out.println("Servers Created..");
    for(ServerNode serverNode : serverNodes){
      serverNode.start();
    }
    
    System.out.println("Servers Started..");
    HashMap<Integer, ClientNode> clientMap = new HashMap<Integer, ClientNode>();
    for(Integer clientid : StorageConfig.getClientIdSet()){
      try{
//        clientMap.put(clientid, new ClientNode(clientid, StorageConfig.getClient2ServerMap().get(clientid),serverSet, StorageConfig.getClient2ServerMap().keySet() ));
        ClientNode c = new ClientNode(clientid, 
            StorageConfig.Client2WriteServerMap.get(clientid),
            StorageConfig.Client2ReadServerMap.get(clientid),
            StorageConfig.Client2SyncServerMap.get(clientid),
            StorageConfig.getClientIdSet(), 
            StorageConfig.getServerIdSet());
        clientMap.put(clientid, c);
        
      }catch(Exception e){
        e.printStackTrace();
        assert false;
      }
    }
//    System.out.println( "BODY CONFIG : " + Config.getBodyConfig(new NodeId(6)));
    System.out.println("Clients Created..");

    //ObjId testoid = new ObjId("/1");
    ObjId testoid = new ObjId(ClientNodeWrapper.getKeyString(1));
    StorageConfig.objSize = 3;
    byte[] data = new byte[StorageConfig.objSize];
    for(int i=0; i<data.length; i++){
      data[i] = (byte)i;
    }
    byte[] b = new byte[1];
    b[0] = 127;
    clientMap.get(7).write(testoid, b);
    try{
      try{
        Thread.sleep(2000);
      }catch(Exception e1){

      }
      b[0] = 0;
      int count = 0;
      while(count < numOps){
        b[0] += 1;
        count++;
        if(count == 5){
          System.out.println("shutting down servers........");
          ServerNode serverNode = serverNodes.getFirst();
          serverNode.shutdown();
          System.out.println("shutdown " + serverNode + " complete........");
          try{
            Thread.sleep(30000);
          }catch(Exception e){
          }

        }
        clientMap.get(6).write(testoid, b);
        try{
          Thread.sleep(2000);
        }catch(Exception e){
        }
        
        LinkedList<Object> l = clientMap.get(7).read(testoid);
        if(l.size() > 0){
          System.out.println("read : " + ((byte[])l.getFirst())[0]);
        } else {
          System.out.println("read : [ ]");
        }
        try{
          Thread.sleep(2000);
        }catch(Exception e){
        }
        
      }
    }catch(DataNotFound e){
      e.printStackTrace();
      assert false;
    }
    
    for(ClientNode cn:clientMap.values()){
      cn.shutdown();
    }
    for(ServerNode sn: serverNodes){
      sn.shutdown();
    }
  }
  
  public void testp2p(){

    int numOps = 40;
    StorageConfig.useBeacon = false;
    StorageConfig.useClientBodyCleanup = false;
    StorageConfig.useCommit = false;
    StorageConfig.NoBodyOnClientServerSync = true;
    StorageConfig.ClientServerSyncInterval = 5000;
//    SangminConfig.BodyConfig = SyncRequest.CheckpointBodies|SyncRequest.UncommittedLastBodies;
//    SangminConfig.BodyConfig = SyncRequest.NoBodies;
    Node.useSignature = true;
    Node.enableSecurity = true;
    SangminConfig.useHash = true;
    SangminConfig.usePersistentStore = false;
    
    StorageConfig.S3Emulation = false;
    SangminConfig.hackedHash = false;
    SangminConfig.hackedSignature = false;
    
    StorageConfig.simulateSSPartition = false;
    StorageConfig.firstSSPartitionStart = 20000000;
    StorageConfig.firstSSPartitionEnd = 400000000;
    
    StorageConfig.simulateClientPartition = false;
    StorageConfig.firstClientPartitionStart = 200000000;
    StorageConfig.firstClientPartitionEnd = 400000000;
    
    HashSet<Integer> s = new HashSet<Integer>();
    s.add(0);
    s.add(2);
    
    StorageConfig.addServer(0, s);
    StorageConfig.addServer(2, s);
    
    HashSet<Integer> st0 = new HashSet<Integer>();
    st0.add(0);
    StorageConfig.addClient(6, 0, 0, st0);
    HashSet<Integer> st1 = new HashSet<Integer>();
    st1.add(2);
    StorageConfig.addClient(7, 2, 2, st1);
    
    System.out.println("Configuration done.");
    Set<Integer> serverSet = StorageConfig.getServerIdSet();
    LinkedList<ServerNode> serverNodes = new LinkedList<ServerNode>();
    for(Integer serverid : serverSet){
      try{
        serverNodes.add(
          new ServerNode(new BranchID(serverid),
            StorageConfig.serverMap.get(serverid)));
        try{
          Thread.sleep(1000);
        }catch(Exception e){
        }
      }catch(Exception e){
        e.printStackTrace();
        assert false;
      }
    }
    
    System.out.println("Servers Created..");
    for(ServerNode serverNode : serverNodes){
      serverNode.start();
    }
    
    System.out.println("Servers Started..");
    HashMap<Integer, ClientNode> clientMap = new HashMap<Integer, ClientNode>();
    for(Integer clientid : StorageConfig.getClientIdSet()){
      try{
        ClientNode c = new ClientNode(clientid, 
            StorageConfig.Client2WriteServerMap.get(clientid),
            StorageConfig.Client2ReadServerMap.get(clientid),
            StorageConfig.Client2SyncServerMap.get(clientid),
            StorageConfig.getClientIdSet(), 
            StorageConfig.getServerIdSet());
        clientMap.put(clientid, c);
        
      }catch(Exception e){
        e.printStackTrace();
        assert false;
      }
    }
    System.out.println("Clients Created..");

    ObjId testoid = new ObjId(ClientNodeWrapper.getKeyString(1));
    byte[] b = new byte[1];
    b[0] = 127;
    clientMap.get(7).write(testoid, b);
    try{
      Thread.sleep(2000);
    }catch(Exception e1){
    }
    b = new byte[1];
    b[0] = 0;
    int count = 0;
    try{
      while(count < numOps){
        b = new byte[1];
        b[0] = (byte)count;
        count++;
        if(count == 5){
          System.out.println("shutting down servers........");
          for(ServerNode serverNode : serverNodes){
            serverNode.shutdown();
          }
//          for(ClientNode clientNode : clientMap.values()){
//            clientNode.shutdown();
//          }
          
          System.out.println("servers shutdown complete........");
          try{
            Thread.sleep(30000);
          }catch(Exception e){
          }
        }
        
        clientMap.get(6).write(testoid, b);
        
        try{
          Thread.sleep(5000);
        }catch(Exception e){
        }
        
        LinkedList<Object> l = clientMap.get(7).read(testoid);
        if(l.size() > 0){
          System.out.println("read : " + b[0]  + " returned "+ ((byte[])l.getFirst())[0]);
        } else {
          System.out.println("read : [ ]");
        }
//        try{
//          Thread.sleep(2000);
//        }catch(Exception e){
//        }
        
        if(count == 20){
          serverNodes.clear();
          for(Integer serverid : serverSet){
            try{
              serverNodes.add(
                new ServerNode(new BranchID(serverid),
                  StorageConfig.serverMap.get(serverid)));
              try{
                Thread.sleep(1000);
              }catch(Exception e){
              }
            }catch(Exception e){
              e.printStackTrace();
              assert false;
            }
          }
          
          System.out.println("Servers Created..");
          for(ServerNode serverNode : serverNodes){
            serverNode.start();
          }
          
          System.out.println("Servers Started..");
          try{
            Thread.sleep(30000);
          }catch(Exception e){
          }
        }
      }
    }catch(DataNotFound e){
      e.printStackTrace();
      assert false;
    }
    for(ClientNode cn:clientMap.values()){
      cn.shutdown();
    }
    for(ServerNode sn: serverNodes){
      sn.shutdown();
    }
  }
  
  public void testSimple2(){
    
    int numOperations = 30;
    
    StorageConfig.reset();
    StorageConfig.useClientBodyCleanup = false;
    StorageConfig.useCommit = false;
    StorageConfig.useBeacon = false;
    StorageConfig.NoBodyOnClientServerSync = true;
    
    Node.useSignature = false;
    Node.enableSecurity = true;
    SangminConfig.useHash = true;
    SangminConfig.usePersistentStore = false;
    
    StorageConfig.S3Emulation = false;
    SangminConfig.hackedHash = StorageConfig.S3Emulation; 
//    HashSet<Integer> s = new HashSet<Integer>();
//    s.add(0);
//    s.add(1);
//    s.add(2);
//    s.add(3);
//    s.add(4);
    
    HashSet<Integer> s0 = new HashSet<Integer>();
    s0.add(3);
    HashSet<Integer> s1 = new HashSet<Integer>();
    s1.add(0);
    HashSet<Integer> s2 = new HashSet<Integer>();
    s2.add(1);
    HashSet<Integer> s3 = new HashSet<Integer>();
    s3.add(2);
    StorageConfig.addServer(0, s0);
    StorageConfig.addServer(1, s1);
    StorageConfig.addServer(2, s2);
    StorageConfig.addServer(3, s3);
//    StorageConfig.addServer(4, s);
    
    HashSet<Integer> st1 = new HashSet<Integer>();
    st1.add(1);
    StorageConfig.addClient(4, 0, 0, st1);
    
    HashSet<Integer> st2 = new HashSet<Integer>();
    st2.add(3);
    StorageConfig.addClient(5, 2, 2, st2);
//    
//    HashSet<Integer> st3 = new HashSet<Integer>();
//    st3.add(2);
//    StorageConfig.addClient(12, 2, 2, st3);
//
//    StorageConfig.addClient(10, 0, 0, st1);
//    StorageConfig.addClient(11, 1, 1, st2);
//    StorageConfig.addClient(12, 2, 2, st3);
    
//    StorageConfig.reset();
//    try{
//      StorageConfig.readConfig("storageConfig");
//    }catch(IOException e2){
//      // TODO Auto-generated catch block
//      e2.printStackTrace();
//      return;
//    }
    
    Integer[] clientsID = StorageConfig.getClientIdSet().toArray(new Integer[0]);
    
    System.out.println("Configurtaion done.");
    Set<Integer> serverSet = StorageConfig.getServerIdSet();
    ServerNode[] serverNodes = new ServerNode[serverSet.size()];
    for(Integer serverid : serverSet){
      try{
        serverNodes[serverid] = new ServerNode(new BranchID(serverid), StorageConfig.serverMap.get(serverid));
      }catch(Exception e){
        e.printStackTrace();
        assert false;
      }
    }
    System.out.println("Servers Created..");
    for(Integer serverid : serverSet){
      serverNodes[serverid].start();
    }
    System.out.println("Servers Started..");
    HashMap<Integer, ClientNode> clientMap = new HashMap<Integer, ClientNode>();
    for(Integer clientid : StorageConfig.getClientIdSet()){
      try{

        ClientNode c = new ClientNode(clientid, 
            StorageConfig.Client2WriteServerMap.get(clientid),
            StorageConfig.Client2ReadServerMap.get(clientid),
            StorageConfig.Client2SyncServerMap.get(clientid),
            StorageConfig.getClientIdSet(), 
            StorageConfig.getServerIdSet());
        clientMap.put(clientid, c);
        
      }catch(Exception e){
        e.printStackTrace();
        assert false;
      }
    }
    System.out.println("Clients Created..");
    StorageConfig.objSize = 1024*1000;
    byte[] data = new byte[StorageConfig.objSize];
    for(int i=0; i<data.length; i++){
      data[i] = 12;
    }
    int NUMOBJS = 5;
    Random r = new Random();
    HashSet<ObjId> objSet = new HashSet<ObjId>();
    
    StorageConfig.printCurrentConfig();
    
    System.out.println("preloading..");
    
    for(int i=0; i < clientsID.length; i++){
      try{
        Thread.sleep(250);
      }catch(InterruptedException e1){
      }
      ClientNode c = clientMap.get(clientsID[i]);
      
      for(int j = 0; j < NUMOBJS; j++){
        ObjId oid = new ObjId("/" + c.getID().getIDint() + "/" + j);
        objSet.add(oid);
        c.write(oid, data);
      }

    }
    
    for(int i=0; i < clientsID.length; i++){
      ClientNode c = clientMap.get(clientsID[i]);
      for(Integer server: serverSet){
        c.syncTo(server);
      }

    }
    try{
      Thread.sleep(10000);
    }catch(InterruptedException e2){
    }
    
    System.out.println("preloading over...");
    for(int i=0; i < numOperations; i++){
      System.out.println("[ " + i + " operations have completed. ]");
      try{
        Thread.sleep(500);
      }catch(InterruptedException e1){
      }
      ClientNode c = clientMap.get(clientsID[r.nextInt(clientsID.length)]);
      
      ObjId oid = new ObjId("/" + c.getID().getIDint() + "/" + r.nextInt(NUMOBJS));
      objSet.add(oid);
      
      if(r.nextFloat() < 1.0){
        c.write(oid, data);
      } else {
        try{
          c.read(oid);
        }catch(DataNotFound e){
          assert false;
        }
      }
      
      if(i % (numOperations/10) == 0){
        for(ClientNode cn : clientMap.values()){
          for(ObjId objId : objSet){
            try{
              LinkedList<Object> l = cn.read(objId);
//              System.out.println(l);
            }catch(DataNotFound e){
              assert false;
            }
          }
          
        }
        
      }
      
      
    }
    for(ClientNode cn:clientMap.values()){
      cn.shutdown();
    }
    for(ServerNode sn: serverNodes){
      sn.shutdown();
    }
    
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "/test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SimpleUnit.class);
    return suite;
  }
  
  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "/test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SimpleUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }
}
