package code.untrustedstorage.writeanyreadany.unit;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import code.branchDetecting.BranchID;
import code.untrustedstorage.writeanyreadany.StorageConfig;
import code.untrustedstorage.writeanyreadany.client.ClientNode;
import code.untrustedstorage.writeanyreadany.client.ClientNodeTraceExecutor;
import code.untrustedstorage.writeanyreadany.client.ClientNodeTraceListener;
import code.untrustedstorage.writeanyreadany.server.ServerNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TraceUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public TraceUnit (final String s) {
    super (s);
  }
  
  protected void setUp() throws Exception{
    super.setUp();
    SimpleUnit.makeIrisConfig(0, 30);    
  }

  
  public void testTrace(){
    
   StorageConfig.useCommit = true;
    
    HashSet<Integer> s = new HashSet<Integer>();
    s.add(0);
    s.add(1);
    
    StorageConfig.addServer(0, s);
    StorageConfig.addServer(1, s);
    
    HashSet<Integer> st0 = new HashSet<Integer>();
    st0.add(0);
    StorageConfig.addClient(6, 0, 0, st0);
    HashSet<Integer> st1 = new HashSet<Integer>();
    st1.add(1);
    StorageConfig.addClient(7, 1, 1, st1);
    
    System.out.println("Configurtaion done.");
    
    Set<Integer> serverSet = StorageConfig.getServerIdSet();
    ServerNode[] serverNodes = new ServerNode[serverSet.size()];
    for(Integer serverid : serverSet){
      try{
        serverNodes[serverid] =
          new ServerNode(new BranchID(serverid),
            StorageConfig.serverMap.get(serverid));
        serverNodes[serverid].start();
        Thread.sleep(1000);
      }catch(Exception e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }
    }
    System.out.println("Servers Created..");

    System.out.println("Servers Started..");
    HashMap<Integer, ClientNode> clientMap = new HashMap<Integer, ClientNode>();
    for(Integer clientid : StorageConfig.getClientIdSet()){
      try{
        
        ClientNode c = new ClientNode(clientid, 
            StorageConfig.Client2WriteServerMap.get(clientid),
            StorageConfig.Client2ReadServerMap.get(clientid),
            StorageConfig.Client2SyncServerMap.get(clientid),
            StorageConfig.getClientIdSet(), 
            StorageConfig.getServerIdSet());
        clientMap.put(clientid, c);
        (new ClientNodeTraceListener(c)).start();
      }catch(Exception e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }
    }
    System.out.println("Clients Created..");
    
    try{
      ClientNodeTraceExecutor.generateTrace("/tmp/trace.tmp", (float) 0.9, 6, 2, 10);
      (new ClientNodeTraceExecutor("/tmp/trace.tmp")).start();
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }

    
  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "/test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(TraceUnit.class);
    return suite;
  }
  
  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "/test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "TraceUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }
}
