#! perl -w
# installs code and or classes on the target machines
# run as follows:
#    perl csresCodePush.pl <Nameof the file that contains list of machines>
# The file should a list of csres machines
# Assumptions:
#    - appropriately ssh keys installed in authorized_keys2 already so
#        automatic ssh authorisation works
#    - universalReplication directory exists in the home
        
if(scalar(@ARGV) < 1) {
    print "Usage: Supply the file with the list of node names\n" ;
    exit ;
}

# code file directories that you want to push
# should start from the universalReplication directory
# format "Directory files"
@classDirs = (
              "code/classes *",
              "code sdims.jar",
              "code *.config",
              "code gnu",
              "code *ermissio*",
              "code/experiments/expt1/classes *",
              "code/experiments/expt2/classes *",
              "code/experiments/expt3/classes *"
              );

$projDir = "~/research/universalReplication/" ;

$nodeNameFile = $ARGV[0] ;

open(FH, "$nodeNameFile") ;

while(<FH>) {
    chomp ;
    $host = $_ ;
    print "Working on the host $host\n" ;
    system("ssh root\@$host \"cd universalReplication; \\rm -rf *\"") ;

    foreach $classDirTuple(@classDirs) {
        my($classDir, $files) = split(/ /, $classDirTuple) ;
        print "Copying $classDir\n" ;
        system("ssh root\@$host \"mkdir -p universalReplication/$classDir\"") ;
        system("cd $projDir/$classDir; scp -r $files \"root\@$host:universalReplication/$classDir\"") ;
	print "Transfer done\n" ;
	system("ssh root\@$host \"ls -al universalReplication/$classDir\"") ;
    }
}


