package code.utils.junit;
 /** 
 *  Template for writing JUnit tests. To write the test for class
 
 *  Foo, copy this file to FooUnit.java and update as described
 
 *  below.
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import code.*;

/**
 * TBD: Update class name
 */
public class TestEmpty extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public TestEmpty (final String s) {
    super (s);
  }

  /*
   * I'm not sure why you would use inner test classes,
   * but it is part of the TestEmpty template. 
   *
   * TBD: Delete this if you don't need it for your class
   */
  public static class InnerTestEmpty extends EmptyTestCase {
    public InnerTestEmpty (final String s) {
      super (s);
    }
    public static final String TEST_ALL_TEST_TYPE = "UNIT";
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

  /* 
   * TBD: Insert functions called testX for some X
   */
  public void testX(){
    /*
     * Your code here. Create instance of class to be tested
     * and test it...
     */
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(TestEmpty.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TestEmpty.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "TestEmpty";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new RandomAccessStateUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
  }

}
