#!/bin/sh
#
# Usage
# Run from main code directory
#    utils/rununit/go.sh
#


#
# Sanity check that the string 'System.exit(' does *not*
# appear in any of the unit tests. This is useful because
# we are translating a bunch of old tests that used
# System.exit(-1) to signal errors into new junit
# test that fail() or assert(false) to signal errors
#



find . -name "*Unit.java" | xargs grep -n 'System.exit(' | awk '{print " "; print " "; print "-----------------------------"; print "-----------------------------"; print "WARNING: Junit tests must signal failure with fail() or assert(). This code has a System.exit() in it. Fix it!"; print $0; print "-----------------------------";print "-----------------------------";print " "; print " ";}'
