#!/bin/sh
#
# Usage
# Run from main code directory
#    utils/rununit/go.sh
#


PRACTIDIR=/home/nalini/research/universalReplication/code
CVSROOT=:ext:nalini@bollard.cs.utexas.edu:/u/dahlin/REPOSITORY
WORKINGDIR=$HOME/tmp/universalreplication-junit
OUTDIR="utils/rununit/out"
YEAR=`date +'%Y'`
MONTH=`date +'%m'`
DAY=`date +'%d'`
REPORT=$YEAR/$MONTH/$DAY.txt

export CVS_RSH="ssh"

#MAILTO="nalini@cs.utexas.edu"
MAILTO="dahlin@cs.utexas.edu,nayate@cs.utexas.edu,zjiandan@cs.utexas.edu,nalini@cs.utexas.edu"


export PATH=/usr/java/jdk1.5.0_07/bin:/usr/kerberos/bin:/usr/local/bin:/bin:/usr/bin:/home/nalini/bin:/home/nalini/research/universalReplication/code/bin:/home/nalini/research/universalReplication/code/bin:/home/nalini/research/universalReplication/code/bin


export LD_LIBRARY_PATH=.

#MDD DBG
#which java

######################################################
#
# Build it
#
######################################################


#Check it out
echo "going to check out code to $WORKINGDIR"
sh $PRACTIDIR/killall.sh > /dev/null 2>&1
rm -rf $WORKINGDIR
mkdir -p $WORKINGDIR
cd $WORKINGDIR
/usr/bin/cvs -d $CVSROOT co universalReplication/code > /dev/null 2>&1
echo "code checked-out to $WORKINGDIR"
cd universalReplication/code

#set env
#source setenv-CS.sh

rm -rf $OUTDIR/tmp
mkdir -p $OUTDIR/tmp

#
# Compile everything
#
make OSTYPE=fc clean > /dev/null  2>&1
make OSTYPE=fc > $OUTDIR/tmp/make.out 2>&1

echo "code compiled"

######################################################
#
# Run it
#
######################################################
#
# Run unit tests
#
echo "Running unit tests. This will take some time"
echo "output is redirected to $WORKINGDIR/universalReplication/code/$OUTDIR/tmp/run.out"
make OSTYPE=fc junittext > $OUTDIR/tmp/run.out  2>&1

echo "finished running unit test... post processing"

######################################################
#
# Post-process report
#
######################################################

#
# Make an archival version of full output
#
cat $OUTDIR/tmp/make.out $OUTDIR/tmp/run.out > $OUTDIR/tmp/fullreport.out

#
# Did someone break the build?
#
cat $OUTDIR/tmp/make.out $OUTDIR/tmp/run.out | grep "make:" | grep "Error" | grep -v "junittext" | awk '{print "BROKEN BUILD"; print "BROKEN BUILD"; print $0; print "BROKEN BUILD"; print "BROKEN BUILD"}' > $OUTDIR/tmp/makeerror.out

#
# To avoid cluttering repository too much, limit output
# to 1000 lines (need to make sure people turn off
# verbose output before checking in code!)
#


mkdir -p $OUTDIR/$YEAR
mkdir -p $OUTDIR/$YEAR/$MONTH
cat $OUTDIR/tmp/fullreport.out | tail -1000 > $OUTDIR/$REPORT
/usr/bin/cvs -d $CVSROOT add $OUTDIR/$YEAR 
#  > /dev/null  2>&1
/usr/bin/cvs -d $CVSROOT add $OUTDIR/$YEAR/$MONTH 
#  > /dev/null  2>&1
/usr/bin/cvs -d $CVSROOT add $OUTDIR/$REPORT 
# > /dev/null  2>&1
/usr/bin/cvs -d $CVSROOT commit -m "Nighltly junit run" $OUTDIR/$REPORT 
#> /dev/null 2>&1

#
# Did someone leave logging messages on?
#
cat $OUTDIR/tmp/fullreport.out | awk '{lines++;}END{if(lines > 999){print "OUTPUT TRUNCATED. Who forgot to turn off screen output before checking in code? Please fix and re-run todays tests!";}else{print "length OK";}}' > $OUTDIR/tmp/length.out

#
# Did someone write bad junit tests?
#
cat $OUTDIR/tmp/run.out | grep "WARNING" | grep "System.exit" > $OUTDIR/tmp/sanity.out
cat $OUTDIR/tmp/run.out | grep "Unit.java" | grep "System.exit" > $OUTDIR/tmp/sanity2.out

#
# Grab the junit output
#
cat $OUTDIR/tmp/run.out | grep OK | grep tests > $OUTDIR/tmp/goodout
cat $OUTDIR/tmp/run.out | grep "Tests run:" | grep "Failures:" | grep "Errors:" > $OUTDIR/tmp/badout
tail -1 $OUTDIR/tmp/run.out | grep "Error" > $OUTDIR/tmp/badrunout
echo "Full results in $OUTDIR/$REPORT" > $OUTDIR/tmp/textout

#
# Make a short report and email it
#
cat $OUTDIR/tmp/makeerror.out $OUTDIR/tmp/textout $OUTDIR/tmp/goodout $OUTDIR/tmp/badout $OUTDIR/tmp/badrunout $OUTDIR/tmp/length.out $OUTDIR/tmp/sanity.out $OUTDIR/tmp/sanity2.out > $OUTDIR/tmp/mailout
mail -s "$REPORT UniversalReplication junit" $MAILTO < $OUTDIR/tmp/mailout

#
# Future -- generate pretty time-series graphs of which tests
# work and don't work on which days
#




