#include <config.h>
// serial.C

#include <assert.h>
#include <stdlib.h>
#include <stream.h>
#include <unistd.h>
#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <symtab/symtab.h>
#include <lib/UidTable.h>
#include <lib/MsgUI.h>
#include <treebuild/pass.h>
#include <misc/voidlist.h>
#include <misc/sfile.h>
#include <misc/fileutil.h>
#include <symtab/symtab.h>
#include <lib/Syntax.h>
#include <backends/serial/serial_aux.h>
#include <translate/translate.h>


void cIdent::Serial()
{
}


void cIntConst::Serial()
{
}


void cRealConst::Serial()
{
}


void cNewExpr::Serial()
{
   if (Sizes != 0) Sizes->Serial();
}


void cFuncCallOp::Serial()
{
   cObIterator i;
   cObject *p;


   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }
}


void cNotOp::Serial()
{
   Left->Serial();
}


void cUnaryMinusOp::Serial()
{
   Left->Serial();
}


void cOrOp::Serial()
{

   Left->Serial();
   Right->Serial();
}


void cAndOp::Serial()
{
   Left->Serial();
   Right->Serial();
}


void cNEOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cEqOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cGEOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cLEOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cLTOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cGTOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cMinusOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cPlusOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cModOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cDivOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cMultOp::Serial()
{


   Left->Serial();
   Right->Serial();
}


void cSelectOp::Serial()
{


   Left->Serial();
}


void cArrayIndOp::Serial()
{
   Left->Serial();
   Right->Serial();
}


void cFuncArgSpec::Serial()
{
}


   // FixFuncType deals with void return types

static MString FixFuncType(MString s, cAbsTree *Here)
{
   if (s == MString(""))
     return "void";
   else
     return SerialGetName(s, Here);
}


void cFuncSig::Serial()
{
   cAbsTree *t, *t2;
   cCursor c;

   // Where it goes depends on the scope in which it is declared.
   // The possibilities are Program, Graph, UC, and NSrel.

   t = GetContaining(this, UC, NSRel, Graph, Program, 0);

   switch (t->IsA()) {
    case Program:
      c.cd(eGlob_h);
      c.cd(eGlobFuncSig);
      break;
    case Graph:
      c.cd(eGraph_c, t->UID);
      c.cd(eGraphFuncSig);
      break;
    case NSRel:
      t2 = GetContaining(t, Graph, 0);
      c.cd(eGraph_c, t2->UID);
      c.cd(eNSScope, t->UID);
      c.cd(eNSFuncSig);
      break;
    case UC:
      t2 = GetContaining(t, Graph, 0);
      c.cd(eGraph_c, t2->UID);
      c.cd(eUCScope, t->UID);
      c.cd(eUCFuncSig);
      break;
   default:
     assert (0); // We should never get here.
     break;
   }


   c << FixFuncType(ReturnType, this) << " " 
     << SerialGetName(FuncName, this) << "();\n";

   // No need to call cFuncArcSpec::Serial since we use K&R C
}


void cArc::Serial()
{
}


void cPartArc::Serial()
{
}


void cMergeArc::Serial()
{
}


void cExpandArc::Serial()
{
}


void cContractArc::Serial()
{
}


void cStrip_UpdateArc::Serial()
{
}


void cAlignArc::Serial()
{
}


void cNamedType::Serial()
{
   cTypeDef *TheTypeDef;
   cCursor c;
   cAbsTree *t;

   TheTypeDef = (cTypeDef *) Parent;

   t = GetContaining(this, Graph, Program, 0);

   if (t->IsA() == Program) {
      c.cd(eGlob_h);
      c.cd(eGlobTypeDef);

   } else if (t->IsA() == Graph) {
      c.cd(eMain_h);
      c.cd(eGraphTypeDef);
   } 

   c << "typedef " << SerialGetName(TypeName,this) << " "
     << SerialGetName(TheTypeDef->Name,this) << ";\n\n";

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrNamedTypeSym(\"" << TypeName << "\", \"" 
	<<  TheTypeDef->Name << "\", " << t->UID << ");\n";
   }
}


void cArrayType::Serial()
{
   cTypeDef *ArrayTypeDef;
   cCursor c;
   cAbsTree *t;
   cSETypeName *ArraySETypeName;
   MString TargetTypeName;
   cSETypeName *TargetSETypeName;

   ArrayTypeDef = (cTypeDef *) Parent;

   t = GetContaining(this, Graph, Program, 0);

   if (t->IsA() == Program) {
      c.cd(eGlob_h);
      c.cd(eGlobTypeDef);
   } else if (t->IsA() == Graph) {
      c.cd(eMain_h);
      c.cd(eGraphTypeDef);
   }

   // define the type
   c << "typedef " << SerialGetName(BaseType,this) << " *"
     << SerialGetName(ArrayTypeDef->Name,this) << ";\n\n";

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrArrayTypeSym(\"" << BaseType << "\", \"" 
	<<  ArrayTypeDef->Name << "\", " << t->UID << ");\n";
   }

   // define the deep copy function for type
   c.cd();
   c.cd(eMain_h);
   c.cd(eCopyFuncSig);
   c << ArrayTypeDef->Name << " _c2_copy_" << ArrayTypeDef->Name << "(/* " 
      << ArrayTypeDef->Name << " from */);\n";

   c.cd();
   c.cd(eMain_c);
   c.cd(eCopyFunc);
   c << ArrayTypeDef->Name << " _c2_copy_" << ArrayTypeDef->Name << "( from )\n" 
     << ArrayTypeDef->Name << " from;\n"
     << "{\n"
     << ArrayTypeDef->Name << " to;\n" 
     << "if (from != (" << ArrayTypeDef->Name << ")0) {\n"
     << "int i;\n"
     << "int bound = asize(from);\n"
     << "to = (" << ArrayTypeDef->Name << ")_c2_shmalloc(sizeof(*to) * bound);\n"
     << "_c2_AddrHashTabAdd(to, bound);\n"
     << "for (i=0; i<bound; i++) \n";

   ArraySETypeName = (cSETypeName *) GetSymbol(ArrayTypeDef->Name, this, ::SETypeName, 0);

   TargetTypeName = ArraySETypeName->UserBaseTypeName;
   TargetSETypeName = (cSETypeName *) GetSymbol(TargetTypeName, this, ::SETypeName, 0);

   while (TargetSETypeName->UserBaseTypeName != MString("")) {
      cSETypeName *BaseSETypeName = (cSETypeName *) 
        GetSymbol(TargetSETypeName->UserBaseTypeName, this, ::SETypeName, 0);
      if (BaseSETypeName->Type != TargetSETypeName->Type) break;
      TargetTypeName = TargetSETypeName->UserBaseTypeName;
      TargetSETypeName = BaseSETypeName;
   }
   switch (TargetSETypeName->Type->IsA()) {
      case ::IntSType:
      case ::RealSType:
      case ::CharSType:
         c << "to[i] = from[i];\n";
         break;
      case ::ArraySType:
      case ::StructSType:
         c << "to[i] = " << "_c2_copy_" << TargetTypeName << "( from[i] );\n";
         break;
      default:
         break;
   }
   c << "}\n"
     << "return to;"
     << "}\n\n";


   // define the deep free function for type
   c.cd();
   c.cd(eMain_h);
   c.cd(eFreeFuncSig);
   c << "void _c2_free_" << ArrayTypeDef->Name << "(/* " << ArrayTypeDef->Name << " this */);\n";
   
   c.cd();
   c.cd(eMain_c);
   c.cd(eCopyFunc);
   c << "void _c2_free_" << ArrayTypeDef->Name << "(this)\n" 
     << ArrayTypeDef->Name << " this;\n" 
     << "{\n"
     << "if (this != 0) {\n";

   switch (TargetSETypeName->Type->IsA()) {
      case ::ArraySType:
      case ::StructSType:
         c << "int i;\n"
           << "int bound = asize(this);\n"
           << "for (i=0; i<bound; i++) \n"
           << "_c2_free_" << TargetTypeName << "(this[i]);\n";
         break;
      case ::IntSType:
      case ::RealSType:
      case ::CharSType:
      default:
         break;
   }
   c << "_c2_AddrHashTabRemove(this);\n"
     << "free(this);\n"
     << "}\n"
     << "}\n\n";
}


void cStructMem::Serial()
{
}


void cStructType::Serial()
{
   cObIterator i;
   cObject *p;
   cTypeDef *StructTypeDef;
   cCursor c;
   cAbsTree *t;
   cStructMem *s;
   cSETypeName *StructSETypeName;
   cStructSType *StructSType;

   StructTypeDef = (cTypeDef *) Parent;

   t = GetContaining(this, Graph, Program, 0);

   if (t->IsA() == Program) {
      c.cd(eGlob_h);
      c.cd(eGlobTypeDef);
   } else if (t->IsA() == Graph) {
      c.cd(eMain_h);
      c.cd(eGraphTypeDef);
   }

   // define the type
   c << "typedef struct {\n";

   for (p = i.Init(Members); i.MoreLeft(); p = i.Next()) {
      s = (cStructMem *) p;
      c << "  " << SerialGetName(s->Type, this) << " " << s->Name << ";\n";
   }

   c << "} *" << SerialGetName(StructTypeDef->Name, this) << "; \n\n";

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrStructTypeSym(\"" <<  SerialGetName(StructTypeDef->Name, this) << "\", " 
	<< UID << ", "<< t->UID ;
      for (p = i.Init(Members); i.MoreLeft(); p = i.Next()) {
	 s = (cStructMem *) p;
	 c << ", \"" << SerialGetName(s->Type, this) << "\", \"" << s->Name << "\", " << s->UID;
      }
      c << ", 0);\n";

      // addresses of fields
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymAddr);
      c.cd(eSAEntry, UID); c.cd(eSAEntryCase);
      c << " case " << UID << ":\n"
	<< "  switch(UID) {\n";
      c.up(); c.cd(eSAEntryTail);
      c << "  }\n   break;\n";
      c. up(); c.cd(eSAEntrySW);
      for (p = i.Init(Members); i.MoreLeft(); p = i.Next()) {
	 s = (cStructMem *) p;
	 c << "     case " << s->UID << ":\n"
	   << "       return (void *) &((" << SerialGetName(StructTypeDef->Name, this) << ") Data)->"
           <<  s->Name  << ";\n"
           << "       break;\n\n";
      }
   }

   // define the deep copy function for type
   c.cd();
   c.cd(eMain_h);
   c.cd(eCopyFuncSig);
   c << StructTypeDef->Name << " _c2_copy_" << StructTypeDef->Name << "(/* " 
      << StructTypeDef->Name << " from */);\n";

   c.cd();
   c.cd(eMain_c);
   c.cd(eCopyFunc);
   c << StructTypeDef->Name << " _c2_copy_" << StructTypeDef->Name << "( from )\n" 
     << StructTypeDef->Name << " from;\n"
     << "{\n";

   c << StructTypeDef->Name << " to;\n" 
     << "if (from != (" << StructTypeDef->Name << ")0) {\n"
     << "to = (" << StructTypeDef->Name << ")_c2_shmalloc(sizeof(*to));\n"
     << "_c2_AddrHashTabAdd((char *)to, sizeof(*to));\n";

   StructSETypeName = (cSETypeName *) GetSymbol(StructTypeDef->Name, this, ::SETypeName, 0);
   StructSType = (cStructSType *)StructSETypeName->Type;

   for (p = i.Init(StructSType->Members); i.MoreLeft(); p = i.Next()) {
      cStructMemSType *StructMemSType = (cStructMemSType *)p;

      // MemberName is StructMemSType->Ident

      MString MemberTypeName = StructMemSType->Type->TypeName;

      cSETypeName *MemberSETypeName = (cSETypeName *) 
        GetSymbol(MemberTypeName, this, ::SETypeName, 0);

      while (MemberSETypeName->UserBaseTypeName != MString("")) {
         cSETypeName *BaseSETypeName = (cSETypeName *) 
           GetSymbol(MemberSETypeName->UserBaseTypeName, this, ::SETypeName, 0);
         if (BaseSETypeName->Type != MemberSETypeName->Type) break;
         MemberTypeName = MemberSETypeName->UserBaseTypeName;
         MemberSETypeName = BaseSETypeName;
      }
      switch (MemberSETypeName->Type->IsA()) {
         case ::IntSType:
         case ::RealSType:
         case ::CharSType:
            c << "to->" << StructMemSType->Ident << " = from->" << StructMemSType->Ident << ";\n";
            break;
         case ::ArraySType:
         case ::StructSType:
            c << "to->" << StructMemSType->Ident  << " = _c2_copy_" << MemberTypeName 
              << "( from->" << StructMemSType->Ident << " );\n";
            break;
         default:
            break;
      }
   }
   c << "};\n"
     << "return to;\n"
     << "}\n\n";


   // define the deep free function for type
   c.cd();
   c.cd(eMain_h);
   c.cd(eFreeFuncSig);
   c << "void _c2_free_" << StructTypeDef->Name << "(/* " << StructTypeDef->Name << " this */);\n";
   
   c.cd();
   c.cd(eMain_c);
   c.cd(eCopyFunc);
   c << "void _c2_free_" << StructTypeDef->Name << "(this)\n" 
     << StructTypeDef->Name << " this;\n" 
     << "{\n"
     << "if (this != 0) {";

   for (p = i.Init(StructSType->Members); i.MoreLeft(); p = i.Next()) {
      cStructMemSType *StructMemSType = (cStructMemSType *)p;

      // MemberName is StructMemSType->Ident

      MString MemberTypeName = StructMemSType->Type->TypeName;

      cSETypeName *MemberSETypeName = (cSETypeName *) 
        GetSymbol(MemberTypeName, this, ::SETypeName, 0);

      while (MemberSETypeName->UserBaseTypeName != MString("")) {
         cSETypeName *BaseSETypeName = (cSETypeName *) 
           GetSymbol(MemberSETypeName->UserBaseTypeName, this, ::SETypeName, 0);
         if (BaseSETypeName->Type != MemberSETypeName->Type) break;
         MemberTypeName = MemberSETypeName->UserBaseTypeName;
         MemberSETypeName = BaseSETypeName;
      }
      switch (MemberSETypeName->Type->IsA()) {
         case ::ArraySType:
         case ::StructSType:
            c << "_c2_free_" << MemberTypeName << "(this->" << StructMemSType->Ident << ");\n";
            break;
         case ::IntSType:
         case ::RealSType:
         case ::CharSType:
         default:
            break;
      }
   }
   c << "_c2_AddrHashTabRemove(this);\n"
     << "free(this);\n"
     << "}\n"
     << "}\n\n";
}


void cTypeDef::Serial()
{
   Type->Serial();
}


void cCallStmt::Serial()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }
}


void cWhileStmt::Serial()
{

   Cond->Serial();
   Body->Serial();
}


void cBlockStmt::Serial()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(StmtList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }
}


void cIfStmt::Serial()
{

   Cond->Serial();
   IfPart->Serial();

   if (ElsePart != 0) {
      ElsePart->Serial();
   }
}


void cAssignStmt::Serial()
{


   LHS->Serial();
   RHS->Serial();
}


void cNullStmt::Serial()
{
}


void cSizeSpec::Serial()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(ArrayBounds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(MemberSizes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }
}


void cMemSize::Serial()
{

   Sizes->Serial();
}


void cVarDecl::Serial()
{
   cAbsTree *t;
   cCursor c;
   cObIterator i;


   t = GetContaining(this, UC, NSRel, Arc, 0);

   switch (t->IsA()) {
    case UC:
    case NSRel:
      c.cd(eMain_h);
      c.cd(eNodeVar, t->UID);
      break;
    case Arc:
      return;  // Can only have ints.  Handled in arc mapping code.
   default:
     assert (0); // We should never get here.
     break;
   }

   c << SerialGetName(TypeName, t) << " " << VarName << ";\n";

   cSEVariable *SEVariable = (cSEVariable *)
                             GetSymbol(VarName, t, ::SEVariable, 0);

   if (SEVariable->Shared) {   // Spit out extra stuff for a shared var
      c << "int _c2_" << VarName << "_UID;\n";
   
      if (AddDbgrCode) {
   	c << "_c2_NSLink *_c2_" << VarName << "_Q;\n"
	  << "_c2_SpList _c2_" << VarName << "_splist;\n";

      }

      // Initialize the extra stuff in MakeObj
                         // WCount = 1 to lock var until after init comp
      c.cd();
      c.cd(eMain_c);
      c.cd(eMakeObj);
      c.cd(eMOEntry, t->UID);
      c.cd(eMOEntryInit);

      c << "((struct _c2_nv" << t->UID << " *) Data)->_c2_" << VarName
        <<    "_UID = " << -(this->UID) << ";\n";

     if (AddDbgrCode) {
	c << "((struct _c2_nv" << t->UID << " *) Data)->_c2_" << VarName
          <<    "_Q = 0;\n";

	c << "((struct _c2_nv" << t->UID << " *) Data)->_c2_" << VarName
          <<    "_splist = (_c2_SpList) _c2_allocSpList();\n\n";
     }
   }
   
   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrVarSym(\"" << VarName << "\", " << UID 
	<< ", \"" << TypeName  <<  "\", "
        << t->UID << ");\n";
      // for obtaining symbol addresses at runtime
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymAddr);
      c.cd(eSAEntry, t->UID); c.cd(eSAEntrySW);
      c << "     case " << UID << ":\n"
	<< "       return (void *) &((struct _c2_nv" << t->UID << " *) Data)->"
	<<  VarName << ";\n"
	<< "       break;\n\n";
   }

   cSETypeName *SETypeName = (cSETypeName *)
                             GetSymbol(TypeName, this, ::SETypeName, 0);

   // Must allocate storage for things with size specs
   
   if (SEVariable->Shared) {
      c.cd();
      c.cd(eGraph_c, t->Parent->UID);
      c.cd(eNSScope, t->UID);
      c.cd(eNSIProc);
      c.cd(eNSIProcInit);
   } else {
      c.cd();
      c.cd(eGraph_c, t->Parent->UID);
      c.cd(eUCScope, t->UID);
      c.cd(eUCIProc);
      c.cd(eUCIProcInit);
   }


   if (Sizes != 0)  {
      Sizes->Serial();

      SerialSizeSpec(Sizes, TypeName);
      
      c << SerialGetName(VarName, t) << " = _c2_new" 
        <<    -(Sizes->UID) << "(_c2_g, _c2_l);\n";

   } 
}


void cNSRel::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;

   SerialDoFuncDefs(FuncDefs, this);
   SerialNSProc(this);

   // Do MakeObj entry
   c.cd();
   c.cd(eMain_c);
   c.cd(eMakeObj);
   c.cd(eMOEntry, this->UID);
   c.cd(eMOEntryHead);
   c << "case " << this->UID << ":\n"
     << "Data = (void *) _c2_shmalloc(sizeof(struct _c2_nv" << this->UID 
     <<     "));\n";

   c.up();
   c.cd(eMOEntryNSFini);
   c << "tmpR = _c2_MakeNSRel(UID, Index, Graph, Data, " << "_c2_ip" 
     << this->UID << ", Graph->CrepsToGo == 0);\n";

   c.up();
   c.cd(eMOEntryTail);
   c << "*ObjType = _c2_NSRELNODE;\n"
     << "return (void *) tmpR\n;"
     << "break;\n";

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrNSRelSym(\"" << Name << "\", " << UID 
	<<  ", " << Parent->UID << ");\n";
      // symbol addresses of vars declared here
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymAddr);
      c.cd(eSAEntry, UID); c.cd(eSAEntryCase);
      c << " case " << UID << ":\n"
        << "  switch(UID) {\n";
      c.up(); c.cd(eSAEntryTail);
      c << "  }\n   break;\n";
   }

   // local and shared vars get put into the same struct
   {
      c.cd(); c.cd(eMain_h); c.cd(eNodeVar, UID);
      c << "struct " << "_c2_nv" << UID << " {     /* NSRel = " 
	<<      Name << " */\n"
	<<       "  char _c2_Dummy;\n";  // Empty structs illegal in C
      for (p = i.Init(SharedVars); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }
      for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }
      c << "};\n\n";
   }
}


void cReplSpec::Serial()
{
   cCursor c;
   cGraph *g;
   cRule *r;
   cUC *u;
   cAbsTree *tmp;
   int FiringRule;

   // Yes, this is horrid.

   tmp = GetContaining(this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
   r = (cRule *) GetContaining(tmp, Rule, 0);
   FiringRule = r->FiringRule;
   u = (cUC *) GetContaining(r, UC, 0);
   g = (cGraph *) GetContaining(u, Graph, 0);

   c.cd(eGraph_c, g->UID);
   c.cd(eUCScope, u->UID);
   c.cd(eUCProc);

   if (FiringRule)
     switch (tmp->IsA()) {
      case Rule:
	c.cd(eUCProcFrule, r->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcFRHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcFRTail);
	c << "}\n";
	break;
      case Guard:
	c.cd(eUCProcFrule, r->UID);
	c.cd(eUCProcFRCheck, tmp->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcFRCheckHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcFRCheckTail);
	c << "}\n";
	break;
      case Binding: 
	c.cd(eUCProcFrule, r->UID);
	c.cd(eUCProcFRBind, tmp->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcFRBindHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcFRBindTail);
	c << "}\n";
	break;
      case ArcInput:
	c.cd(eUCProcFrule, r->UID);
	c.cd(eUCProcFRCheck, tmp->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcFRCheckHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcFRCheckTail);
	c << "}\n";
	//  *** This also goes into a binding part!
        c.up();
	c.up();
	c.cd(eUCProcFRBind, tmp->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcFRBindHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcFRBindTail);
	c << "}\n";
	break;
     default:
       assert (0); // We should never get here.
       break;
     }
   else
     switch (tmp->IsA()) {
      case Rule:
	c.cd(eUCProcRrule, r->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcRRHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcRRTail);
	c << "}\n";
	break;
      case Guard:
	c.cd(eUCProcRrule, r->UID);
	c.cd(eUCProcRRCheck, tmp->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcRRCheckHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcRRCheckTail);
	c << "}\n";
	break;
      case ArcOutput:
      case Binding:
	c.cd(eUCProcRrule, r->UID);
	c.cd(eUCProcRRBind, tmp->UID);
	c << "int " << IndVar << ";\n";
	c.cd(eUCProcRRBindHead);
	c << "for (" << IndVar << "=0; " << IndVar << "<";
	c << Bound->Translate();
	c << "; " << IndVar << "++) {\n";
	c.up();
	c.cd(eUCProcRRBindTail);
	c << "}\n";
	break;
     default:
       assert (0); // We should never get here.
       break;
     }
}



void cGuard::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;
   cGraph *g;
   cRule *r;
   cUC *u;
   cAbsTree *tmp;
   int FiringRule;


   tmp = GetContaining(this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
   r = (cRule *) GetContaining(tmp, Rule, 0);
   FiringRule = r->FiringRule;
   u = (cUC *) GetContaining(r, UC, 0);
   g = (cGraph *) GetContaining(u, Graph, 0);

   c.cd(eGraph_c, g->UID);
   c.cd(eUCScope, u->UID);
   c.cd(eUCProc);

   if (FiringRule) {
      	c.cd(eUCProcFrule, r->UID);
	c.cd(eUCProcFRCheck, this->UID);
	c << "{\n";
	c.cd(eUCProcFRCheckBody);
	c << "if (!(";
	c << Cond->Translate();
	c << ")) goto _c2_endrule" << -(r->UID) << ";\n";
	c.up();
	c.cd(eUCProcFRCheckTail);	
	c << "}\n";
   }else {
      	c.cd(eUCProcRrule, r->UID);
	c.cd(eUCProcRRCheck, this->UID);
	c << "{\n";
	c.cd(eUCProcRRCheckBody);
	c << "if (!(";
	c << Cond->Translate();
	c << ")) goto _c2_endrule" << -(r->UID) << ";\n"
	  << "_c2_NullRule = 0;\n";
	c.up();
	c.cd(eUCProcRRCheckTail);	
	c << "}\n";
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   SerialCreateReplCond(ReplCond, this);

}


void cArcInput::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;
   cGraph *g;
   cRule *r;
   cUC *u;
   cAbsTree *tmp;
   int NumInd;


   tmp = GetContaining(this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
   r = (cRule *) GetContaining(tmp, Rule, 0);
   u = (cUC *) GetContaining(r, UC, 0);
   g = (cGraph *) GetContaining(u, Graph, 0);

   c.cd(eGraph_c, g->UID);
   c.cd(eUCScope, u->UID);
   c.cd(eUCProc);

   // checking part
   c.cd(eUCProcFrule, r->UID);
   c.cd(eUCProcFRCheck, this->UID);
   c << "{\n";
   c.cd(eUCProcFRCheckBody);
   NumInd = FillIndVar(c, "_c2_PortIndex", PortExpr, 0);
   c << "_c2_PortIndex.NumInd = " << NumInd << ";\n";
   if (AddDbgrCode) {
      c << "if (!(_c2_Check(_c2_MyAddr, _c2_l->" << FindPortName(PortExpr) 
	<<    ", &_c2_PortIndex))) goto _c2_endrule" << -(r->UID) << ";\n"
	<<  "  _c2_nxtFpBpAct(_c2_MyAddr);\n";
   } else {
      c << "if (!(_c2_Check(_c2_l->" << FindPortName(PortExpr) 
	<<    ", &_c2_PortIndex))) goto _c2_endrule" << -(r->UID) << ";\n";
   }
   c  << "_c2_NullRule = 0;\n";
   c.up();
   c.cd(eUCProcFRCheckTail);       
   c << "}\n";

    // binding part
   c.up();
   c.up();
   c.cd(eUCProcFRBind, this->UID);
   c << "{\n";
   c.cd(eUCProcFRBindBody);
   NumInd = FillIndVar(c, "_c2_PortIndex", PortExpr, 0);
   c << "_c2_PortIndex.NumInd = " << NumInd << ";\n";
   if (AddDbgrCode) {
      c << "_c2_Stat = _c2_Remove(_c2_MyAddr, _c2_l->" << FindPortName(PortExpr) 
        <<    " ,&_c2_PortIndex, &_c2_TmpValue);\n"
	<< "_c2_dtchFpBpAct(_c2_MyAddr, _c2_TmpValue.fplist, "
	<< "_c2_TmpValue.cmd);\n\n";
   } else {
      c << "_c2_Stat = _c2_Remove(_c2_l->" << FindPortName(PortExpr) 
	<<    " ,&_c2_PortIndex, &_c2_TmpValue);\n";
   }
   SerialArcAssign(c, VarExpr, PortExpr, this);
   c.up();
   c.cd(eUCProcFRBindTail);        
   c << "}\n";

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   SerialCreateReplCond(ReplCond, this);
}


void cBinding::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;
   cGraph *g;
   cRule *r;
   cUC *u;
   cAbsTree *tmp;
   int FiringRule;


   tmp = GetContaining(this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
   r = (cRule *) GetContaining(tmp, Rule, 0);
   FiringRule = r->FiringRule;
   u = (cUC *) GetContaining(r, UC, 0);
   g = (cGraph *) GetContaining(u, Graph, 0);

   c.cd(eGraph_c, g->UID);
   c.cd(eUCScope, u->UID);
   c.cd(eUCProc);

   if (FiringRule) {
      	c.cd(eUCProcFrule, r->UID);
	c.cd(eUCProcFRBind, this->UID);
	c << "{\n";
	c.cd(eUCProcFRBindBody);
	c << Bind->Translate();
	c.up();
	c.cd(eUCProcFRBindTail);	
	c << "}\n";
   }else {
      	c.cd(eUCProcRrule, r->UID);
	c.cd(eUCProcRRBind, this->UID);
	c << "{\n";
	c.cd(eUCProcRRBindBody);
	c << Bind->Translate();
	c.up();
	c.cd(eUCProcRRBindTail);	
	c << "}\n";
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   SerialCreateReplCond(ReplCond, this);
}


void cArcOutput::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;
   cGraph *g;
   cRule *r;
   cUC *u;
   cSEPortName *ps;
   int NumInd;
   cAbsTree *tmp;

   tmp = GetContaining(this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
   r = (cRule *) GetContaining(tmp, Rule, 0);
   u = (cUC *) GetContaining(r, UC, 0);
   g = (cGraph *) GetContaining(u, Graph, 0);

   c.cd(eGraph_c, g->UID);
   c.cd(eUCScope, u->UID);
   c.cd(eUCProc);

   c.cd(eUCProcRrule, r->UID);
   c.cd(eUCProcRRBind, this->UID);
   c << "{\n";
   c.cd(eUCProcRRBindBody);

   NumInd = FillIndVar(c, "_c2_PortIndex", PortExpr, 0);
   c << "_c2_PortIndex.NumInd = " << NumInd << ";\n";

   ps = (cSEPortName *) GetSymbol(FindPortName(PortExpr), u, SEPortName, 0);

   c << ps->GenName << "(_c2_MyAddr, &_c2_PortIndex, "
     <<    ValueExpr->Translate() << ");\n";

   if (ValueExpr->IsLHS)
     if (ValueExpr->StructuralType->IsA() == ::ArraySType ||
	 ValueExpr->StructuralType->IsA() == ::StructSType)
       c << ValueExpr->Translate() << " = 0;\n";

   c.up();
   c.cd(eUCProcRRBindTail);	
   c << "}\n";

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   SerialCreateReplCond(ReplCond, this);
}


void cRule::Serial()
{
   cObIterator i;
   cObject *p;
   cGraph *g;
   cUC *u;
   cCursor c;

   u = (cUC *) GetContaining(this, UC, 0);
   g = (cGraph *) GetContaining(u, Graph, 0);

   c.cd(eGraph_c, g->UID);
   c.cd(eUCScope, u->UID);
   c.cd(eUCProc);

   if ( FiringRule ) {

      c.cd(eUCProcFrule, UID);
      c << "{  /* Begin rule " << -UID << " */\n";

      if (AddDbgrCode) {
	 c <<  "if (_c2_fruleChkBpAct(_c2_MyAddr, " << -UID << "))\n"
	   <<  "    goto _c2_endrule" << -UID <<";\n";
      }

      c.cd(eUCProcFRTail);
      c << "goto _c2_comp;\n"
	<< "_c2_endrule" << -UID << ":;\n";

   } else {

      c.cd(eUCProcRrule, UID);
      c << "{  /* Begin rule " << -UID << " */\n";

      c.cd(eUCProcRRTail);
      c << "_c2_endrule" << -UID << ":;\n";

   }


   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   SerialCreateReplCond(ReplCond, this);

   for (p = i.Init(Guards); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(Binds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }


   if (FiringRule) {
      c << "}\n\n";   // Final } for rule   (assumes c is still at tail)
      c.up();
      c.cd(eUCProcFRHead);
      c << "_c2_NullRule = 1;\n"; // Init for check at least one LHS item true
      c.up();
      c.cd(eUCProcFRNullCheck);
      c << "if (_c2_NullRule) goto _c2_endrule" << -UID << ";\n";
   } else {
      c << "}\n\n";   // Final } for rule   (assumes c is still at tail)
      c.up();
      c.cd(eUCProcRRHead);
      c << "_c2_NullRule = 1;\n"; // Init for check at least one LHS item true
      c.up();
      c.cd(eUCProcRRNullCheck);
      c << "if (_c2_NullRule) goto _c2_endrule" << -UID << ";\n";
   }

}


void cPortSpec::Serial()
{
   cUC *u;
   cGraph *g;
   cCursor c;

   u = (cUC *) GetContaining(this, UC, 0);	

   if (IsInputPort) {
      g = (cGraph *) GetContaining(this, Graph, 0);

      c.cd(eMain_h); c.cd(eNodeVar, u->UID);
      c << "  _c2_SeqVarQ " << PortName << ";\n";

      // Put it into the MakeObj entry
      c.cd();
      c.cd(eMain_c);
      c.cd(eMakeObj);
      c.cd(eMOEntry, u->UID);
      c.cd(eMOEntryInit);
      c << "_c2_Create(((struct _c2_nv" << u->UID << " *) Data)->"
	<<    PortName << ");\n";

      // symbol addresses at runtime 
      if (AddDbgrCode) {
	 c.cd(); c.cd(eMain_c); c.cd(eDbgSymAddr);
	 c.cd(eSAEntry, u->UID); c.cd(eSAEntrySW);
	 c << "     case " << UID << ":\n"
	   << "       return (void *) ((struct _c2_nv" << u->UID << " *) Data)->"
           << PortName << ";\n" 
	   << "       break;\n\n";
      }

   } else
     SerialPortFunc(this);   // Create Output port function

   // enter symbol for the debugger
   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrPortSym(\"" << PortName << "\", \"" 
	<< TypeName << "\", " << IsInputPort << ", " << UID 
	<<  ", " << u->UID << ");\n";
   }
}


void cNSPortSpec::Serial()
{
   cUC *u;
   cGraph *g;
   cCursor c;
   cSESharedVar *SharVar;

   u = (cUC *) GetContaining(this, UC, 0);
   g = (cGraph *) GetContaining(u, Graph, 0);

   // Declare the variable
   c.cd(eMain_h);
   c.cd(eNodeVar, u->UID);
   c << SerialGetName(TypeName, u) << " " << PortName << ";\n";

   SharVar = (cSESharedVar *) GetSymbol(PortName, u, SESharedVar, 0);

   // Call shared var func to add to UC's lock list
   c.cd();
   c.cd(eGraph_c, g->UID);
   c.cd(eUCScope, u->UID);
   c.cd(eUCProc);
   c.cd(eUCProcSharedVarAdd);
   c << SharVar->GenName << "(_c2_MyAddr, &_c2_PortIndex);\n";

   // Create shared var func
   SerialSharVarFunc(this, SharVar);
}


void cUC::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;
   

   // These must be done before Serial calls to children
   SerialDoFuncDefs(FuncDefs, this);   // Node scope funcs
   SerialUCMakeObj(this);              // MakeObj entry in c2_main.c
   SerialUCProc(this);                 // Skel of UC's proc in graph.c

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrUCSym(\"" << Name << "\", " << UID 
	<<  ", " << Parent->UID << ");\n";
      // symbol addresses of vars declared here
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymAddr);
      c.cd(eSAEntry, UID); c.cd(eSAEntryCase);
      c << " case " << UID << ":\n"
        << "  switch(UID) {\n";
      c.up(); c.cd(eSAEntryTail);
      c << "  }\n   break;\n";
   }


   // input ports and local vars get translated to the same place.
   {
      c.cd(); c.cd(eMain_h); c.cd(eNodeVar, UID);

      c << "struct " << "_c2_nv" << UID << " {     /* UC = "
	<<      Name << " */\n"
	<< "  char _c2_Dummy;\n";  // Empty structs illegal in C

      for (p = i.Init(InputPorts); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }
      
      for (p = i.Init(OutputPorts); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }
      
      for (p = i.Init(NSPorts); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }

      for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }
      c << "};\n\n";
   }

   for (p = i.Init(InRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(OutRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }
}


void cIntNode::Serial()
{
   cCursor c;

   if (!InParam) {
      // Create the function pointer in graph struct for return func
      c.cd(); 
      c.cd(eMain_h);
      c.cd(eGraphVar, Parent->UID);
      c << "  void (*_c2_prf" << UID << ")();\n";
   }
}


void cCrepNode::Serial()
{
   cCursor c;

   // Create the variable in the graph struct
   c.cd(); 
   c.cd(eMain_h);
   c.cd(eGraphVar, Parent->UID);

   c << "  " << SerialGetName(Type, Parent) << " " << Name << ";\n"
     << "  int _c2_" << Name << ";\n";

   // enter symbol for the debugger
   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrCrepSym(\"" << Name << "\", \"" 
	<< SerialGetName(Type, Parent) << "\", " << UID 
	<<  ", " << Parent->UID << ");\n";
   }

   // Put it's flag initialization into the MakeObj entry
   c.cd();
   c.cd(eMain_c);
   c.cd(eMakeObj);
   c.cd(eMOEntry, Parent->UID);
   c.cd(eMOEntryInit);
   c << "((struct _c2_gv" << Parent->UID << " *) Data)->_c2_" << Name
     <<  " = 0;\n";

}


void cCallNode::Serial()
{
   cGraph *g;
   cCursor c;
   cObIterator i;
   cObject *p;
   cSEGraph *GSym;
   cGraph *TheGraph;
   cArc *a;

   g = (cGraph *) Parent;
   GSym = (cSEGraph *) GetSymbol(CalledGraph, g, SEGraph, 0);
   TheGraph = (cGraph *) (GSym->Graph);

   // Enter a case : for this call node in graph's MakeObj entry.
   c.cd(eMain_c);
   c.cd(eMakeObj);
   c.cd(eMOEntry, TheGraph->UID);
   c.cd(eMOEntryCase);
   c << "case " << UID << ":\n";

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrCallNodeSym(\"" << Name << "\", " << UID 
	<<  ", " << TheGraph->UID << ", " << Parent->UID << ");\n";
   }

   // Enter a case in MakeObj for return func pointer setting
   c.cd();
   c.cd(eMain_c);
   c.cd(eMakeObj);
   c.cd(eMOEntry, TheGraph->UID);
   c.cd(eMOEntrySWInit, UID);
   c.cd(eMOEntrySWInCase);

   c << "case " << UID << ":\n";

   c.up();
   c.cd(eMOEntrySWInTail);
   
   c << "break;\n";

   // Find all outgoing arcs and make routing functions for them.
   for (p = i.Init(g->Arcs); i.MoreLeft(); p = i.Next()) {
      a = (cArc *) p;
      if (a->FromUID == UID) {
	 if (a->ConnectsNSRel)
	   SerialMakeNSArcRoute(a, TheGraph, this);
	 else
	   SerialMakeArcRoute(a, TheGraph, this);
      }
   }
}


void cGraph::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;

   c.cd(eMakefile); c.cd(eObj);   // Add to objs list in makefile.
   c << Name << ".o ";

   c.up(); c.cd(eGrapht);
   c << Name << ".o: " << Name << ".c\n"
     << "\t$(CC) $(CFLAGS) $(INC) -c " << Name << ".c\n\n";

   c.cd(); c.cd(eGraph_c, UID);
   c << "/* " << Name << ".c */\n"
     << "#include \"c2_main.h\"\n\n";

   SerialGraphMakeObj(this);
   SerialDoFuncDefs(FuncDefs, this);

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrGphSym(\"" << Name << "\", " << UID 
	<<  ", " << Parent->UID << ");\n";
   }


   {
      c.cd(); c.cd(eMain_h); c.cd(eGraphVar, UID);
      c << "struct " << "_c2_gv" << UID << " {     /* Graph = "
	<< Name << " */\n"
	<< "  char _c2_Dummy;\n";  // Empty structs illegal in C

      for (p = i.Init(CrepNodes); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }

      for (p = i.Init(IntNodes); i.MoreLeft(); p = i.Next()) {
	 ((cAbsTree *) p)->Serial();
      }

      c << "};\n\n";
   }

   for (p = i.Init(UCNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(CallNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(NSRelNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(Arcs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }
}


void cProgram::Serial()
{
   cObIterator i;
   cObject *p;
   cCursor c;

   PassOK = 1;   // OK at start

   SerialMakeFile(this);
   SerialCreateMain();
   SerialMakeObj();

   c.cd();
   c.cd(eMain_h);
   c << "/* c2_main.h */\n\n"
     << "#include \"c2_misc.h\"\n"
     << "#include \"c2_workers.h\"\n"
     << "#include \"c2_seqvar.h\"\n"
     << "#include \"c2_globtype.h\"\n\n";

   c.cd();
   c.cd(eMain_c);
   c << "/* c2_main.c */\n"
     << "#include \"c2_main.h\"\n\n";

   c.cd();
   c.cd(eGlob_h);
   c << "/* c2_globtype.h */\n\n"
     << "#define TRUE 1\n"
     << "#define FALSE 0\n\n"
     << "typedef double real;\n\n";

   SerialDoFuncDefs(FuncDefs, this);

   if (setjmp(PassEnv)) {
      PassOK = 0;
      return;
   }

   if (AddDbgrCode) {
      c.cd(); c.cd(eMain_c); c.cd(eDbgSymEntry); c.cd(eDbgSEBody);
      c << "  _c2_entrPgmSym(\"" << Name << "\", " << UID  << ");\n";
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   for (p = i.Init(Graphs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Serial();
   }

   // [ut newline after objs list in makefile.
   c.cd(); c.cd(eMakefile); c.cd(eObj);
   c << "\n\n";

   (void) SerialWriteFiles(this);
}

