/*
  serial_arc.C
  ------------------------------------------------------------------------
  Arc generation routines.
  ------------------------------------------------------------------------
  @(#) $Id: serial_arc.C,v 1.10 1998/05/28 22:51:15 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <config.h>

#include <stream.h>
#include <unistd.h>
#include <backends/serial/serial_arc.h>
#include <misc/general.h>
#include <exmodel/abstree.h>
#include <symtab/symtab.h>
#include <lib/UidTable.h>
#include <lib/MsgUI.h>

#include <treebuild/pass.h>
#include <misc/voidlist.h>
#include <misc/sfile.h>
#include <misc/fileutil.h>
#include <lib/Syntax.h>
#include <symtab/symtab.h>
#include <backends/serial/serial_aux.h>


static void SerialNSConnect(cCursor &c, cArc *a)
{

   c << "_c2_TmpNSRel = (_c2_NSRelBase *) _c2_GetAddr(_c2_gr, "
     <<   a->ToUID << ", &_c2_ni);\n"
     << "_c2_NewLock->NSRelAddr = _c2_TmpNSRel;\n"
     << "_c2_NewLock->SharedAddr = (void *)\n"
     << "  &((struct _c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData))"
     <<     "->" << a->ToPort << ";\n"
     << "_c2_NewLock->UID =\n"
     << "  ((struct _c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData))"
     <<     "->_c2_" << a->ToPort << "_UID;\n"
     << "_c2_NewLock->LocalAddr = _c2_LocalAddr;\n";

   if (AddDbgrCode) {
      c << "_c2_NewLock->Q =\n"
        << "  &((struct _c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData))"
        <<     "->_c2_" << a->ToPort << "_Q;\n";

      c << "_c2_NewLock->psplist = \n"
	<< "   &((struct _c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData))" 
	<< "->_c2_" << a->ToPort << "_splist;\n\n";
      c << "_c2_NewLock->ReqType = _c2_LocalReqType;\n";
   }

 
   switch (a->BaseType->IsA()) {
    case IntSType:
      c << "_c2_NewLock->TypeTag = _c2_IsAnInt;\n";
      break;
    case RealSType:
      c << "_c2_NewLock->TypeTag = _c2_IsADouble;\n";
      break;
    case CharSType:
      c << "_c2_NewLock->TypeTag = _c2_IsAChar;\n";
      break;
    case ArraySType:
      c << "_c2_NewLock->TypeTag = _c2_IsAnArrayPtr;\n";
      break;
    case StructSType:
      c << "_c2_NewLock->TypeTag = _c2_IsAStructPtr;\n";
      break;
    default:
      Die("Internal error:  Illegal arc base type in SerialUCComm\n");
   }

   c << "_c2_InsertLock(&_c2_na->HeadLock, _c2_NewLock);\n";
}


  // Create code to Send data to a UC

static void SerialUCComm(cCursor &c, cArc *a)
{

   c << "_c2_TmpNode = (_c2_NodeBase *) _c2_GetAddr(_c2_gr, " 
     <<    a->ToUID << ", &_c2_ni);\n"
     << "_c2_QVar = ((struct _c2_nv" << a->ToUID << " *)"
     << "(_c2_TmpNode->LocalData))->" << a->ToPort << ";\n"
     << "}\n";

   switch (a->BaseType->IsA()) {
    case IntSType:
      c << "_c2_TmpValue.type = _c2_IsAnInt;\n"
        << "_c2_TmpValue.u.i = _c2_value;\n";
      break;
    case RealSType:
      c << "_c2_TmpValue.type = _c2_IsADouble;\n"
        << "_c2_TmpValue.u.d = _c2_value;\n";
      break;
    case CharSType:
      c << "_c2_TmpValue.type = _c2_IsAChar;\n"
        << "_c2_TmpValue.u.c = _c2_value;\n";
      break;
    case ArraySType:
      c << "_c2_TmpValue.type = _c2_IsAnArrayPtr;\n"
        << "_c2_TmpValue.u.array = _c2_value;\n";
      break;
    case StructSType:
      c << "_c2_TmpValue.type = _c2_IsAStructPtr;\n"
        << "_c2_TmpValue.u.structure = _c2_value;\n";
      break;
    default:
      Die("Internal error:  Illegal arc base type in SerialUCComm\n");
   }

   c << "_c2_Insert(_c2_QVar, _c2_pi, &_c2_TmpValue);\n"
     << "_c2_EnQueue(_c2_TmpNode);\n";
}


  // Create code to do an arc topo mapping

static void SerialArcMap(cCursor &c, cArc *a)
{
   cVarDecl *v;
   cExpr *e;
   cObIterator i;
   int ic;
   cObject *p;

   c << "{\n";

   // Declare index variables

   for (p = i.Init(a->CallVarList); i.MoreLeft(); p = i.Next()) {
      v = (cVarDecl *) p;
      c <<  "int " << v->VarName << ";\n";
   }

   for (p = i.Init(a->NodeVarList); i.MoreLeft(); p = i.Next()) {
      v = (cVarDecl *) p;
      c <<  "int " << v->VarName << ";\n";
   }

   for (p = i.Init(a->PortVarList); i.MoreLeft(); p = i.Next()) {
      v = (cVarDecl *) p;
      c <<  "int " << v->VarName << ";\n";
   }

   // Assign to index variables

   ic = 0;
   for (p = i.Init(a->CallVarList); i.MoreLeft(); p = i.Next()) {
      v = (cVarDecl *) p;
      c <<  v->VarName << " = _c2_gi.Ind[" << ic << "];\n";
      ic += 1;
   }

   ic = 0;
   for (p = i.Init(a->NodeVarList); i.MoreLeft(); p = i.Next()) {
      v = (cVarDecl *) p;
      c <<  v->VarName << " = _c2_ni.Ind[" << ic << "];\n";
      ic += 1;
   }

   ic = 0;
   for (p = i.Init(a->PortVarList); i.MoreLeft(); p = i.Next()) {
      v = (cVarDecl *) p;
      c <<  v->VarName << " = (*_c2_pi).Ind[" << ic << "];\n";
      ic += 1;
   }

   // Do the mapping

   ic = 0;
   for (p = i.Init(a->CallExprList); i.MoreLeft(); p = i.Next()) {
      e = (cExpr *) p;
      c << "_c2_gi.Ind[" << ic << "] = ";
      c << e->Translate();
      c << ";\n";
      ic += 1;
   }
   c << "_c2_gi.NumInd = " << ic << ";\n";

   ic = 0;
   for (p = i.Init(a->NodeExprList); i.MoreLeft(); p = i.Next()) {
      e = (cExpr *) p;
      c << "_c2_ni.Ind[" << ic << "] = ";
      c << e->Translate();
      c << ";\n";
      ic += 1;
   }
   c << "_c2_ni.NumInd = " << ic << ";\n";

   ic = 0;
   for (p = i.Init(a->PortExprList); i.MoreLeft(); p = i.Next()) {
      e = (cExpr *) p;
      c << "(*_c2_pi).Ind[" << ic << "] = ";
      c << e->Translate();
      c << ";\n";
      ic += 1;
   }
   c << "(*_c2_pi).NumInd = " << ic << ";\n";

   c << "}\n";

}


   // Create code to send to a crep

static void SerialCrep(cCursor &c, cCrepNode *cn, cGraph *GraphCalled)
{
   c << "_c2_AddToCache = 0;\n"
     << "}\n"
     << "if (((struct _c2_gv" << GraphCalled->UID << " *) (_c2_gr->LocalData))"
     <<   "->_c2_" << cn->Name << " == 1) {\n"
     << "_c2_KillComp(_c2_CREPTWICE);\n"
     << "} else\n"
     << "((struct _c2_gv" << GraphCalled->UID << " *) (_c2_gr->LocalData))"
     <<   "->_c2_" << cn->Name << " = 1;\n";

   c << "((struct _c2_gv" << GraphCalled->UID << " *) (_c2_gr->LocalData))"
     <<   "->" << cn->Name << " = (" << SerialGetName(cn->Type, cn)
     <<    ")_c2_value;\n";

   if (AddDbgrCode) {
      c << "_c2_InitWaitingNodes(_c2_TmpValue.fplist, _c2_gr);\n"; 
   } else {
      c << "_c2_InitWaitingNodes(_c2_gr);\n"; 
   }
}


  // Create code for a Call

static void SerialDoCall(cCursor &c, cArc *a, cAbsTree *ToNode)
{
   cGraph *CalledGraph;
   cCallNode *cn;
   cObIterator i;
   cObject *p;
   cSEGraph *GSym;
   cIntNode *in;
   ArcKind k;
   cCrepNode *crepnode;

   cn = (cCallNode *) ToNode;
   GSym = (cSEGraph *) GetSymbol(cn->CalledGraph, a, SEGraph, 0);
   CalledGraph = GSym->Graph;

   c << "_c2_gr = (_c2_GraphBase *) _c2_GetAddr(_c2_gr, "
     <<   a->ToUID << ", &_c2_gi);\n";

   // See if connects to an input interface node
   for (p = i.Init(CalledGraph->IntNodes); i.MoreLeft(); p = i.Next()) {
      in = (cIntNode *) p;
      if ((char *) in->Name == a->ToPort) {
	 FindArc(in->Name, in, &a, &k, &ToNode);
	 SerialDoNextArc(c, a, k, ToNode);
	 return;
      }
   }

   // See if it connects to a CreP node
   for (p = i.Init(CalledGraph->CrepNodes); i.MoreLeft(); p = i.Next()) {
      crepnode = (cCrepNode *) p;
      if ((char *) crepnode->Name == a->ToPort) {
	 SerialCrep(c, crepnode, CalledGraph);
	 return;
      }
   }
}



   // Create code to call a port function pointer-- a return from a
   // Graph

static void SerialCallPortFunc(cCursor &c, cArc *a)
{
   cGraph *g;

   g = (cGraph *) a->Parent;

   c << "}\n"
     << "{\n"
     << "_c2_GraphBase *_c2_TmpGraph;\n"
     << "_c2_TmpGraph = (_c2_GraphBase *) _c2_GetAddr(_c2_gr, _c2_PARENT, "
     <<   "_c2_pi);\n"
     << "_c2_gi = _c2_gr->Index;\n";

   if (AddDbgrCode) {
      c << "(((struct _c2_gv" << g->UID << " *)(_c2_gr->LocalData))->_c2_prf" 
        << a->ToUID << ")(_c2_TmpValue.fplist, _c2_TmpValue.cmd, "
	<< "_c2_TmpGraph, _c2_gi, _c2_ni, _c2_pi, "
        << " &_c2_TmpNode, &_c2_QVar, &_c2_AddToCache, _c2_value);\n";
   } else {  
     c << "(((struct _c2_gv" << g->UID << " *)(_c2_gr->LocalData))->_c2_prf" 
       << a->ToUID << ")(_c2_TmpGraph, _c2_gi, _c2_ni, _c2_pi, &_c2_TmpNode, "
       <<   "&_c2_QVar, _c2_AddToCache, _c2_value);\n";
   }

   c  << "}\n";
}


   // Create code to call NSRel port function pointer-- a return from a
   // Graph

static void SerialCallNSPortFunc(cCursor &c, cArc *a)
{
   cGraph *g;

   g = (cGraph *) a->Parent;

   c << "{\n"
     << "_c2_GraphBase *_c2_TmpGraph;\n"
     << "_c2_TmpGraph = (_c2_GraphBase *) _c2_GetAddr(_c2_gr, _c2_PARENT, "
     <<   "_c2_pi);\n"
     << "_c2_gi = _c2_gr->Index;\n"
     << "(((struct _c2_gv" << g->UID << " *)(_c2_gr->LocalData))->_c2_prf" 
     << a->ToUID << ")(_c2_TmpGraph, _c2_gi, _c2_ni, _c2_pi, _c2_na, _c2_LocalAddr, "
     <<   "_c2_LocalReqType, _c2_NewLock);\n"
     << "}\n";
}


   // Create code for a UC to UC arc

static void SerialUC_UC(cCursor &c, cArc *a)
{
   SerialArcMap(c, a);
   SerialUCComm(c, a);
}


   // Create code for a UC connected to a Call.

static void SerialUC_Call(cCursor &c, cArc *a, cAbsTree *ToNode)
{
   SerialArcMap(c, a);
   SerialDoCall(c, a, ToNode);
}


static void SerialUC_OI(cCursor &c, cArc *a)
{
   if (a->ConnectsNSRel)
     SerialCallNSPortFunc(c, a);
   else
     SerialCallPortFunc(c, a);
}

static void SerialUC_NS(cCursor &c, cArc *a)
{
   SerialArcMap(c, a);
   SerialNSConnect(c, a);
}

static void SerialCall_Call(cCursor &c, cArc *a, cAbsTree *ToNode)
{
   SerialArcMap(c, a);
   SerialDoCall(c, a, ToNode);
}

static void SerialCall_UC(cCursor &c, cArc *a)
{
   SerialArcMap(c, a);
   SerialUCComm(c, a);
}

static void SerialCall_OI(cCursor &c, cArc* a)
{
   if (a->ConnectsNSRel)
     SerialCallNSPortFunc(c, a);
   else
     SerialCallPortFunc(c, a);
}

static void SerialCall_NS(cCursor &c, cArc *a)
{
   SerialArcMap(c, a);
   SerialNSConnect(c, a);
}

static void SerialII_UC(cCursor &c, cArc *a)
{
   SerialUCComm(c, a);
}

static void SerialII_Call(cCursor &c, cArc *a, cAbsTree *ToNode)
{
   SerialDoCall(c, a, ToNode);
}

static void SerialII_OI(cCursor &c, cArc *a)
{
   if (a->ConnectsNSRel)
     SerialCallNSPortFunc(c, a);
   else
     SerialCallPortFunc(c, a);
}

static void SerialII_NS(cCursor &c, cArc *a)
{
   SerialNSConnect(c, a);
}


void SerialDoNextArc(cCursor &c, cArc *a, ArcKind kind, cAbsTree *ToNode)
{
   switch (kind) {
    case kUC_UC:
      SerialUC_UC(c, a);
      break;
    case kUC_Call:
      SerialUC_Call(c, a, ToNode);
      break;
    case kUC_OI:
      SerialUC_OI(c, a);
      break;
    case kUC_NS:
      SerialUC_NS(c, a);
      break;
    case kCall_UC:
      SerialCall_UC(c, a);
      break;
    case kCall_Call:
      SerialCall_Call(c, a, ToNode);
      break;
    case kCall_OI:
      SerialCall_OI(c, a);
      break;
    case kCall_NS:
      SerialCall_NS(c, a);
      break;
    case kII_UC:
      SerialII_UC(c, a);
      break;
    case kII_Call:
      SerialII_Call(c, a, ToNode);
      break;
    case kII_OI:
      SerialII_OI(c, a);
      break;
    case kII_NS:
      SerialII_NS(c, a);
      break;
    default:
      Die("Internal error: Bad kind in SerialDoNextArc.\n");
      break;
   }
}

