// serial_aux.h

#ifndef _serial_aux_h
#define _serial_aux_h

   // enum for sfile priorities.  There is an enum for each block type
   // in the structured files.  The enums *must* appear in the correct
   // order since the corresponding sub-blocks will be written in the
   // same order.  See sfile.h.
enum {
 eRoot=1,
   eMakefile,
      eDecl,
      eObj,
      eProgt,
      eGrapht,
   eMain_h, 
      eGraphTypeDef, 
      eGraphVar,  //[*]
      eNodeVar,  //[*]
      ePortFuncSig,
      eArcFuncSig,
      eNewFuncSig,
      eCopyFuncSig,
      eFreeFuncSig,
   eMain_c,
      eGlobFunc,
      eNewFunc,
      eCopyFunc,
      eFreeFunc,
      eIntFuncSig,
      eMakeObj,
         eMOHead,
         eMOEntry,  //[*]  // by graph or uc uid
	    eMOEntryCase,
            eMOEntryHead,
            eMOEntryInit,
            eMOEntryNSFini,
	    eMOEntrySWHead,
	    eMOEntrySWInit,  // [*] by call uid
               eMOEntrySWInCase,
               eMOEntrySWInBind,
               eMOEntrySWInTail,
            eMOEntryTail,
         eMOTail,
      eMainProg,
      eDbgSymEntry,
	   eDbgSEHead,
	   eDbgSEBody,
	   eDbgSETail,
      eDbgSymAddr,
	   eSAHead,
	   eSAEntry,  //[*] by graph, nsrel, or uc uid
	       eSAEntryCase,
               eSAEntrySW,
	       eSAEntryTail,
	   eSATail,
   eGlob_h,
      eGlobTypeDef,
      eGlobFuncSig,
   eGraph_c,  //[*]
      eGraphFuncSig,
      eGraphFunc,
      ePortFunc,
      eArcFunc,
      eUCScope,  //[*]
         eUCFuncSig,
         eUCFunc,
         eUCIProc,
            eUCIProcHead,
            eUCIProcInit,
            eUCIProcComp,
            eUCIProcTail,
         eUCProc,
            eUCProcHead,
            eUCProcSharedVarAdd,
            eUCProcBefFrule,
            eUCProcFrule,  //[*] rule UID
	       eUCProcFRHead,
	       eUCProcFRCheck, // [*] guard or arc_in
	          eUCProcFRCheckHead,
	          eUCProcFRCheckBody,
	          eUCProcFRCheckTail,
               eUCProcFRNullCheck,
	       eUCProcFRBind,  // [*] arc_in or binding
		  eUCProcFRBindHead,
		  eUCProcFRBindBody,
		  eUCProcFRBindTail,
	       eUCProcFRTail,
            eUCProcComp,
            eUCProcRrule,  //[*] rule UID
	       eUCProcRRHead,
	       eUCProcRRCheck, // [*] guard
	          eUCProcRRCheckHead,
	          eUCProcRRCheckBody,
	          eUCProcRRCheckTail,
               eUCProcRRNullCheck,
	       eUCProcRRBind,  // [*] arc_out or binding
		  eUCProcRRBindHead,
		  eUCProcRRBindBody,
		  eUCProcRRBindTail,
	       eUCProcRRTail,
            eUCProcTail,
      eNSScope,  //[*]
         eNSFuncSig,
         eNSFunc,
         eNSIProc,
            eNSIProcHead,
            eNSIProcInit,
            eNSIProcComp,
            eNSIProcRelLock,
            eNSIProcTail
  };


  // Writes the structured files to disk, returns 1 for success else 0.
int SerialWriteFiles(cProgram *ProgramRoot);

  // Creates Makefile
void SerialMakeFile(cProgram *p);

  // Creates the skeleton of MakeObj
void SerialMakeObj();

  // Creates main program in c2_main.c
void SerialCreateMain();

  // SerialGetName returns the string that should be output to the
  // structured file.  It may not be the same as the ident since
  // some things have to be renamed.

MString SerialGetName(MString &Ident, cAbsTree *Here);

  // Write out user's unparsed functions.

void SerialDoFuncDefs(MString &FuncDefs, cAbsTree *Here);

  // Create procs to implement UC nodes

void SerialUCProc(cUC *u);

  // Create procs to implement NSRel nodes

void SerialNSProc(cNSRel *n);

  // Translates the UC MakeObj Entry

void SerialUCMakeObj(cUC *u);

  // Translates the Graph MakeObj Entry

void SerialGraphMakeObj(cGraph *g);

  // Translates the CSizeSpec objects in cVarDecl and cNewExpr

void SerialSizeSpec(cSizeSpec *SizeSpec, MString TypeName);

  // Create code to assign value from an arc to a local

void SerialArcAssign(cCursor &c, cExpr *VarExpr, cExpr *PortExpr,
		      cAbsTree *Here);

  // create function for an output port.

void SerialPortFunc(cPortSpec *p);

  // create function for UC shared var

void SerialSharVarFunc(cNSPortSpec *nsp, cSESharedVar *sv);


// Create all of the things needed for an arc route function.  These are
// created for all arcs that exit a Call node.

void SerialMakeArcRoute(cArc *a, cGraph *CalledGraph, cCallNode *cn);
void SerialMakeNSArcRoute(cArc *a, cGraph *CalledGraph, cCallNode *cn);

  // Create code for a ReplCond

void SerialCreateReplCond(cExpr *rc, cReplThing *Where);

#endif
