/*
  unified.C
  ------------------------------------------------------------------------
  Main translation routines for the Unified backend.
  ------------------------------------------------------------------------
  @(#) $Id: unified.C,v 1.37 1998/11/06 06:41:17 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:

  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <config.h>

#include <assert.h>
#include <stdlib.h>
#include <stream.h>
#include <unistd.h>
#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <symtab/symtab.h>
#include <lib/UidTable.h>
#include <lib/MsgUI.h>
#include <treebuild/pass.h>
#include <misc/voidlist.h>
#include <misc/sfile.h>
#include <misc/fileutil.h>
#include <symtab/symtab.h>
#include <lib/Syntax.h>
#include <translate/translate.h>

#include "unified_aux.h"


#define ADD_NAME_TABLE_ENTRY \
{ \
    c.cd(); c.cd(eMain_c); c.cd(eNameTableEntry, UID); \
    c << "  {" << UID << ",\"" << Name << "\"},\n"; \
}


void cIdent::Unified ()
{
}

void cIntConst::Unified ()
{
}

void cRealConst::Unified ()
{
}


void cNewExpr::Unified ()
{
  if (Sizes != 0)
    Sizes->Unified ();
}


void cFuncCallOp::Unified ()
{
  cObIterator i;
  cObject *p;

  for (p = i.Init (Args); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
}


void cNotOp::Unified ()
{
  Left->Unified ();
}


void cUnaryMinusOp::Unified ()
{
  Left->Unified ();
}


void cOrOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cAndOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cNEOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cEqOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cGEOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cLEOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cLTOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cGTOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cMinusOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cPlusOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cModOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cDivOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cMultOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cSelectOp::Unified ()
{
  Left->Unified ();
}


void cArrayIndOp::Unified ()
{
  Left->Unified ();
  Right->Unified ();
}


void cFuncArgSpec::Unified ()
{
}


//FixFuncType deals with void return types
static MString FixFuncType (MString s, cAbsTree * Here)
{
  if (s == MString(""))
    return MString("void");
  else
    return UnifiedGetName (s, Here);
}


void cFuncSig::Unified ()
{
  cAbsTree *t, *t2;
  cCursor c;

  //Where it goes depends on the scope in which it is declared.
  // The possibilities are Program, Graph, UC, and NSrel.

  t = GetContaining (this, UC, NSRel, Graph, Program, 0);

  switch (t->IsA ()) {
  case Program:
    c.cd (eGlob_h);
    c.cd (eGlobFuncSig);
    break;
  case Graph:
    c.cd (eGraph_c, t->UID);
    c.cd (eGraphFuncSig);
    break;
  case NSRel:
    t2 = GetContaining (t, Graph, 0);
    c.cd (eGraph_c, t2->UID);
    c.cd (eNSScope, t->UID);
    c.cd (eNSFuncSig);
    break;
  case UC:
    t2 = GetContaining (t, Graph, 0);
    c.cd (eGraph_c, t2->UID);
    c.cd (eUCScope, t->UID);
    c.cd (eUCFuncSig);
    break;
  default:
    assert (0); // We should never get here.
    break;
  }


#if 0
  //Bracket the functions with C linkage (for C++).

  c << "#ifdef __cplusplus\n"
    << "extern \"C\" \n"
    << "#endif\n";
#endif

  c << FixFuncType (ReturnType, this) << " "
    << UnifiedGetName (FuncName, this) << "(";

  if (DontCheckArgs) {
    c << "...";
  } else {

    //Print every type and argument name (ANSI style).

    cObIterator i;
    cObject *p;
    cFuncArgSpec *fp;

    for (p = i.Init (Args); i.MoreLeft (); p = i.Next ()) {
      fp = (cFuncArgSpec *) p;
      c << fp->TypeName << " ";
      if (fp->Reference) {
	c << "* ";
      }
      c << fp->ArgName;
      if (!(i.Last ())) {
	c << ", ";
      }
    }
  }

  c << ");\n\n";
}


void cArc::Unified ()
{
}

void cPartArc::Unified ()
{
}

void cMergeArc::Unified ()
{
}

void cExpandArc::Unified ()
{
}

void cContractArc::Unified ()
{
}

void cStrip_UpdateArc::Unified ()
{
}

void cAlignArc::Unified ()
{
}


void cNamedType::Unified ()
{
  cTypeDef *TheTypeDef;
  cCursor c;
  cAbsTree *t;

  TheTypeDef = (cTypeDef *) Parent;

  t = GetContaining (this, Graph, Program, 0);

  if (t->IsA () == Program) {
    c.cd (eGlob_h);
    c.cd (eGlobTypeDef);

  } else if (t->IsA () == Graph) {
    c.cd (eMain_h);
    c.cd (eGraphTypeDef);
  }
  c << "typedef " << UnifiedGetName (TypeName, this) << " "
    << UnifiedGetName (TheTypeDef->Name, this) << ";\n\n";

  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrNamedTypeSym(\"" << TypeName << "\", \""
      << TheTypeDef->Name << "\", " << t->UID << ");\n";
  }
}


void cArrayType::Unified ()
{
  cTypeDef *ArrayTypeDef;
  cCursor c;
  cAbsTree *t;
  cSETypeName *ArraySETypeName;
  MString TargetTypeName;
  cSETypeName *TargetSETypeName;

  ArrayTypeDef = (cTypeDef *) Parent;

  t = GetContaining (this, Graph, Program, 0);

  if (t->IsA () == Program) {
    c.cd (eGlob_h);
    c.cd (eGlobTypeDef);
  } else if (t->IsA () == Graph) {
    c.cd (eMain_h);
    c.cd (eGraphTypeDef);
  }
  //define the type
  c << "typedef " << UnifiedGetName (BaseType, this) << " *"
    << UnifiedGetName (ArrayTypeDef->Name, this) << ";\n\n";

  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrArrayTypeSym(\"" << BaseType << "\", \""
      << ArrayTypeDef->Name << "\", " << t->UID << ");\n";
  }


  //define the deep copy function for type
  c.cd ();
  c.cd (eMain_h);
  c.cd (eCopyFuncSig);
  c << ArrayTypeDef->Name << " _c2_copy_" << ArrayTypeDef->Name << "("
    << ArrayTypeDef->Name << " from, "
    << ArrayTypeDef->Name << " to, int flag, Messenger& messenger, SerialMachine * sm = 0);\n";

  c.cd ();
  c.cd (eMain_c);
  c.cd (eCopyFunc);

  ArraySETypeName = (cSETypeName *) GetSymbol(ArrayTypeDef->Name, this, ::SETypeName, 0);

  TargetTypeName = ArraySETypeName->UserBaseTypeName;
  TargetSETypeName = (cSETypeName *) GetSymbol(TargetTypeName, this, ::SETypeName, 0);

  while (TargetSETypeName->UserBaseTypeName != MString("")) {
    cSETypeName *BaseSETypeName = (cSETypeName *) 
      GetSymbol(TargetSETypeName->UserBaseTypeName, this, ::SETypeName, 0);
    if (BaseSETypeName->Type != TargetSETypeName->Type) break;
    TargetTypeName = TargetSETypeName->UserBaseTypeName;
    TargetSETypeName = BaseSETypeName;
  }

  c << ArrayTypeDef->Name << " _c2_copy_" << ArrayTypeDef->Name << "( Array<" << ArrayTypeDef->Name << "> * from, Array<" << ArrayTypeDef->Name << "> * to, int flag, Messenger& messenger, SerialMachine * sm)\n"
    << "{\n"
    << "int i;\n"
    << "int bound;\n\n"
    << "Guard m (messenger.objectlock ());\n"
    << "switch(flag & LOCAL) { \n\n";

  c << " case RECEIVE :\n"
    << "   messenger >> bound;\n"
#if 0
    << "   if (sm) {\n"
    << "     to = new (sm) " << UnifiedGetName (BaseType, this) << "[bound];\n"
    << "   } else {\n"
    << "     to = new " << UnifiedGetName (BaseType, this) << "[bound];\n"
    << "   }\n"
    << "  _c2_AddrHashTabAdd((char *) to, bound);\n";
#endif
    << "   to = new Array<" << UnifiedGetName (BaseType, this) << "> (bound);\n";

  switch (TargetSETypeName->Type->IsA()) {
  case ::IntSType:
  case ::RealSType:
  case ::CharSType:
    c << "  messenger.unpack (to, bound);\n";
    break;
  case ::ArraySType:
  case ::StructSType:
    c << "  for (i=0; i<bound; i++) \n"
      << "  to[i] = _c2_copy_" << TargetTypeName 
      << "( (" << TargetTypeName << ") 0, to[i], RECEIVE, messenger, sm);\n";
    break;
  default:
    break;
  }

  c << "  return to;\n";

  c << " case TRANSMIT : if (from != (" << ArrayTypeDef->Name << " *) 0) \n"
    << " bound = from->size();\n"
#if 0
    << " bound = asize((char *) from);\n"
#endif
    << " else bound = 0;\n"
    << "  messenger << bound;\n";

  switch (TargetSETypeName->Type->IsA()) {
  case ::IntSType:
  case ::RealSType:
  case ::CharSType:
    c << "  messenger.pack (from, bound);\n";
    break;
  case ::ArraySType:
  case ::StructSType:
    c << "  for (i=0; i<bound; i++) \n"
      << "  _c2_copy_" << TargetTypeName 
      << "( from[i], (" << TargetTypeName << ") 0, TRANSMIT, messenger, sm);\n";
    break;
  default:
    break;
  }
  
  c << "  break;\n\n";
  
  c << " case LOCAL:\n"
    << "  if (from != (Array< " << ArrayTypeDef->Name << ">*) 0) {\n"
    << "  bound = from->size();\n"
#if 0
    << "  bound = asize((char *) from);\n"
    << "  if (sm) {\n"
    << "  to = new (sm) " << UnifiedGetName (BaseType, this) << "[bound];\n"
    << "  } else {\n"
    << "  to = new " << UnifiedGetName (BaseType, this) << "[bound];\n"
    << "  }\n"
    << "  _c2_AddrHashTabAdd((char *) to, bound);\n"
#endif
    << "  to = new Array<" << UnifiedGetName (BaseType, this) << "> (bound);\n"
    << "  for (i=0; i<bound; i++) \n";

  switch (TargetSETypeName->Type->IsA()) {
  case ::IntSType:
  case ::RealSType:
  case ::CharSType:
    c << "  to[i] = from[i];\n"
      << "  return to;\n"
      << "};\n\n";
    break;
  case ::ArraySType:
  case ::StructSType:
    c << "  to[i] = " << "_c2_copy_" << TargetTypeName 
      << "( from[i], (" << TargetTypeName << ") 0, LOCAL, messenger, sm);\n"
      << "  return to;\n"
      << "  };\n";
    break;
  default:
    break;
  }

  c << "break;\n"
    << "default:\n"
    << "  MESSAGE(\"Illegal flag used in copy.\");\n";

  c << "}\n"
    << "return (" << ArrayTypeDef->Name << ") 0;\n"
    << "}\n\n";


  //define the deep free function for type
  c.cd ();
  c.cd (eMain_h);
  c.cd (eFreeFuncSig);
  c << "void _c2_free_" << ArrayTypeDef->Name << "(" << ArrayTypeDef->Name << " self);\n";

  c.cd ();
  c.cd (eMain_c);
  c.cd (eCopyFunc);
  c << "void _c2_free_" << ArrayTypeDef->Name << "(" << ArrayTypeDef->Name << " self)\n"
    << "{\n"
    << "if (self != 0) {\n";

  switch (TargetSETypeName->Type->IsA ()) {
  case ArraySType:
  case StructSType:
    c << "int i;\n"
      << "int bound = self->size();\n"
      << "for (i=0; i<bound; i++) \n"
      << "_c2_free_" << TargetTypeName << "(self[i]);\n";
    break;
  case IntSType:
  case RealSType:
  case CharSType:
  default:
    break;
  }
  c << "// _c2_AddrHashTabRemove((char *) self);\n"
    << "delete self;\n"
    << "}\n"
    << "}\n\n";
}


void cStructMem::Unified ()
{
}


void cStructType::Unified ()
{
  cObIterator i;
  cObject *p;
  cTypeDef *StructTypeDef;
  cCursor c;
  cAbsTree *t;
  cStructMem *s;
  cSETypeName *StructSETypeName;
  cStructSType *StructSType;

  StructTypeDef = (cTypeDef *) Parent;

  t = GetContaining (this, Graph, Program, 0);

  if (t->IsA () == Program) {
    c.cd (eGlob_h);
    c.cd (eGlobTypeDef);
  } else if (t->IsA () == Graph) {
    c.cd (eMain_h);
    c.cd (eGraphTypeDef);
  }
  //define the type
  c << "class _" << UnifiedGetName (StructTypeDef->Name, this) << "_struct {\n";
  c << "public:\n";
  c << "inline void * operator new (size_t sz, SerialMachine * sm) {\n"
    << "  return sm->alloc (sz);\n"
    << "}\n";
  c << "inline void * operator new (size_t sz) {\n"
    << "  return (void *) ::new char[sz];\n"
    << "}\n"
    << "inline void operator delete (void *) {} // FIX ME!!\n\n";
  
  for (p = i.Init (Members); i.MoreLeft (); p = i.Next ()) {
    s = (cStructMem *) p;
    c << "  " << UnifiedGetName (s->Type, this) << " " << s->Name << ";\n";
  }

  c << "};\n";
  c << "typedef _" << UnifiedGetName (StructTypeDef->Name, this) << "_struct * " << UnifiedGetName (StructTypeDef->Name, this) << "; \n\n";

  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrStructTypeSym(\"" << UnifiedGetName (StructTypeDef->Name, this) << "\", "
      << UID << ", " << t->UID;
    for (p = i.Init (Members); i.MoreLeft (); p = i.Next ()) {
      s = (cStructMem *) p;
      c << ", \"" << UnifiedGetName (s->Type, this) << "\", \"" << s->Name << "\", " << s->UID;
    }
    c << ", 0);\n";

    //addresses of fields
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymAddr);
    c.cd (eSAEntry, UID);
    c.cd (eSAEntryCase);
    c << " case " << UID << ":\n"
      << "  switch(UID) {\n";
    c.up ();
    c.cd (eSAEntryTail);
    c << "  }\n   break;\n";
    c.up ();
    c.cd (eSAEntrySW);
    for (p = i.Init (Members); i.MoreLeft (); p = i.Next ()) {
      s = (cStructMem *) p;
      c << "     case " << s->UID << ":\n"
	<< "       return (void *) &((" << UnifiedGetName (StructTypeDef->Name, this) << ") Data->data())->"
	<< s->Name << ";\n"
	<< "       break;\n\n";
    }
  }
  //define the deep copy function for type
  c.cd ();
  c.cd (eMain_h);
  c.cd (eCopyFuncSig);
  c << StructTypeDef->Name << " _c2_copy_" << StructTypeDef->Name << "("  << StructTypeDef->Name << " from, " << StructTypeDef->Name << " to, int flag, Messenger& messenger, SerialMachine * sm = 0);\n";

  c.cd();
  c.cd(eMain_c);
  c.cd(eCopyFunc);
  c << StructTypeDef->Name << " _c2_copy_" << StructTypeDef->Name << "( " << StructTypeDef->Name << " from, " << StructTypeDef->Name << " to, int flag, Messenger& messenger, SerialMachine * sm)\n"
    << "{\n"
    << "int null;\n"
    << "Guard m (messenger.objectlock ());\n"
    << "switch(flag & LOCAL) {\n\n";

  StructSETypeName = (cSETypeName *) GetSymbol(StructTypeDef->Name, this, ::SETypeName, 0);
  StructSType = (cStructSType *)StructSETypeName->Type;

  c << "case RECEIVE: "
    << "  messenger >> null;\n"
    << "  to = new _" << StructTypeDef->Name << "_struct;\n"
#if 0
    << "  _c2_AddrHashTabAdd((char *)to, sizeof(*to));\n"
#endif
    << "  if (null) return to;\n";

  for (p = i.Init(StructSType->Members); i.MoreLeft(); p = i.Next()) {
    cStructMemSType *StructMemSType = (cStructMemSType *)p;

    // MemberName is StructMemSType->Ident

    MString MemberTypeName = StructMemSType->Type->TypeName;

    cSETypeName *MemberSETypeName = (cSETypeName *) 
      GetSymbol(MemberTypeName, this, ::SETypeName, 0);

    while (MemberSETypeName->UserBaseTypeName != MString("")) {
      cSETypeName *BaseSETypeName = (cSETypeName *) 
	GetSymbol(MemberSETypeName->UserBaseTypeName, this, ::SETypeName, 0);
      if (BaseSETypeName->Type != MemberSETypeName->Type) break;
      MemberTypeName = MemberSETypeName->UserBaseTypeName;
      MemberSETypeName = BaseSETypeName;
    }
    switch (MemberSETypeName->Type->IsA()) {
    case ::IntSType:
    case ::RealSType:
    case ::CharSType:
      c << "messenger >> to->" << StructMemSType->Ident << ";\n";
      break;
    case ::ArraySType:
    case ::StructSType:
      c << "to->" << StructMemSType->Ident  << " = _c2_copy_" << MemberTypeName 
	<< "( (" << MemberTypeName << ") 0, to->" << StructMemSType->Ident << ", RECEIVE, messenger, sm);\n";
      break;
    default:
      break;
    }
  }

  c << "return to;\n";

  c << "case TRANSMIT: "
    << "  null = (from == (" << StructTypeDef->Name << ")0);\n"
    << "  messenger << null;\n"
    << "  if (null) break;\n";

  for (p = i.Init(StructSType->Members); i.MoreLeft(); p = i.Next()) {
    cStructMemSType *StructMemSType = (cStructMemSType *)p;

    // MemberName is StructMemSType->Ident

    MString MemberTypeName = StructMemSType->Type->TypeName;

    cSETypeName *MemberSETypeName = (cSETypeName *) 
      GetSymbol(MemberTypeName, this, ::SETypeName, 0);

    while (MemberSETypeName->UserBaseTypeName != MString("")) {
      cSETypeName *BaseSETypeName = (cSETypeName *) 
	GetSymbol(MemberSETypeName->UserBaseTypeName, this, ::SETypeName, 0);
      if (BaseSETypeName->Type != MemberSETypeName->Type) break;
      MemberTypeName = MemberSETypeName->UserBaseTypeName;
      MemberSETypeName = BaseSETypeName;
    }
    switch (MemberSETypeName->Type->IsA()) {
    case ::IntSType:
    case ::RealSType:
    case ::CharSType:
      c << "messenger << from->" << StructMemSType->Ident << ";\n";
      break;
    case ::ArraySType:
    case ::StructSType:
      c << "_c2_copy_" << MemberTypeName 
	<< "( from->" << StructMemSType->Ident << ", (" << MemberTypeName << ") 0, TRANSMIT, messenger, sm);\n";
      break;
    default:
      assert (0); // We should never get here.
      break;
    }
  }

  c << "break;\n\n";

  c << "case LOCAL:\n"
    << "default : if (from != (" << StructTypeDef->Name << ")0) {\n"
    << "  if (sm) {\n"
    << "    to = new (sm) _" << StructTypeDef->Name << "_struct;\n"
    << "  } else {\n"
    << "    to = new _" << StructTypeDef->Name << "_struct;\n"
    << "  }\n";
#if 0
    << "_c2_AddrHashTabAdd((char *)to, sizeof(*to));\n";
#endif

  for (p = i.Init(StructSType->Members); i.MoreLeft(); p = i.Next()) {
    cStructMemSType *StructMemSType = (cStructMemSType *)p;

    // MemberName is StructMemSType->Ident

    MString MemberTypeName = StructMemSType->Type->TypeName;

    cSETypeName *MemberSETypeName = (cSETypeName *) 
      GetSymbol(MemberTypeName, this, ::SETypeName, 0);

    while (MemberSETypeName->UserBaseTypeName != MString("")) {
      cSETypeName *BaseSETypeName = (cSETypeName *) 
	GetSymbol(MemberSETypeName->UserBaseTypeName, this, ::SETypeName, 0);
      if (BaseSETypeName->Type != MemberSETypeName->Type) break;
      MemberTypeName = MemberSETypeName->UserBaseTypeName;
      MemberSETypeName = BaseSETypeName;
    }
    switch (MemberSETypeName->Type->IsA()) {
    case ::IntSType:
    case ::RealSType:
    case ::CharSType:
      c << "to->" << StructMemSType->Ident << " = from->" << StructMemSType->Ident << ";\n";
      break;
    case ::ArraySType:
    case ::StructSType:
      c << "to->" << StructMemSType->Ident  << " = _c2_copy_" << MemberTypeName 
	<< "( from->" << StructMemSType->Ident << ", (" << MemberTypeName << ") 0, LOCAL, messenger, sm);\n";
      break;
    default:
      break;
    }
  }

  c << "return to;\n"
    << "};\n";

  c << "}\n"
    << "return (" << StructTypeDef->Name << ") 0;\n"
    << "}\n";

  //define the deep free function for type
  c.cd ();
  c.cd (eMain_h);
  c.cd (eFreeFuncSig);
  c << "void _c2_free_" << StructTypeDef->Name << "(" << StructTypeDef->Name << " self);\n";

  c.cd ();
  c.cd (eMain_c);
  c.cd (eCopyFunc);
  c << "void _c2_free_" << StructTypeDef->Name << "("
    << StructTypeDef->Name << " self)\n"
    << "{\n"
    << "if (self != 0) {";

  for (p = i.Init (StructSType->Members); i.MoreLeft (); p = i.Next ()) {
    cStructMemSType *StructMemSType = (cStructMemSType *) p;

    //MemberName is StructMemSType->Ident

    MString MemberTypeName = StructMemSType->Type->TypeName;

    cSETypeName *MemberSETypeName = (cSETypeName *)
      GetSymbol (MemberTypeName, this,::SETypeName, 0);

    while (MemberSETypeName->UserBaseTypeName != MString("")) {
      cSETypeName *BaseSETypeName = (cSETypeName *)
	GetSymbol (MemberSETypeName->UserBaseTypeName, this,::SETypeName, 0);
      if (BaseSETypeName->Type != MemberSETypeName->Type)
	break;
      MemberTypeName = MemberSETypeName->UserBaseTypeName;
      MemberSETypeName = BaseSETypeName;
    }
    switch (MemberSETypeName->Type->IsA ()) {
    case 	::ArraySType:
    case 	::StructSType:
      c << "_c2_free_" << MemberTypeName << "(self->" << StructMemSType->Ident << ");\n";
      break;
    case 	::IntSType:
    case 	::RealSType:
    case 	::CharSType:
    default:
      break;
    }
  }
  c << "//_c2_AddrHashTabRemove((char *) self);\n"
    << "delete self;\n"
    << "}\n"
    << "}\n\n";
}


void cTypeDef::Unified ()
{
  Type->Unified ();
}


void cCallStmt::Unified ()
{
  cObIterator i;
  cObject *p;

  for (p = i.Init (Args); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
}


void cWhileStmt::Unified ()
{
  Cond->Unified ();
  Body->Unified ();
}


void cBlockStmt::Unified ()
{
  cObIterator i;
  cObject *p;

  for (p = i.Init (StmtList); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
}


void cIfStmt::Unified ()
{
  Cond->Unified ();
  IfPart->Unified ();

  if (ElsePart != 0) {
    ElsePart->Unified ();
  }
}


void cAssignStmt::Unified ()
{
  LHS->Unified ();
  RHS->Unified ();
}


void cNullStmt::Unified ()
{
}


void cSizeSpec::Unified ()
{
  cObIterator i;
  cObject *p;

  for (p = i.Init (ArrayBounds); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (MemberSizes); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
}


void cMemSize::Unified ()
{
  Sizes->Unified ();
}


void cVarDecl::Unified ()
{
  cAbsTree *t;
  cCursor c;
  cObIterator i;

  t = GetContaining (this, UC, NSRel, Arc, 0);

  switch (t->IsA ()) {
  case UC:
  case NSRel:
    c.cd (eMain_h);
    c.cd (eNodeVar, t->UID);
    break;
  case Arc:
    return;
    //Can only have ints.Handled in arc mapping code.
  default:
    assert (0); // We should never get here.
    break;
  }

  c << UnifiedGetName (TypeName, t) << " " << VarName << ";\n";

  cSEVariable *SEVariable = (cSEVariable *)
    GetSymbol (VarName, t,::SEVariable, 0);

  if (SEVariable->Shared) {
    //Spit out extra stuff for a shared var
    c << "SharedVariableInfo _c2_" << VarName << "_SharedVarInfo;\n";
    
    if (AddDbgrCode) {
      c << "_c2_SpList _c2_" << VarName << "_splist;\n";
    }

    // Add an entry to NameSharingRelation::GetSharedVarInfo.
    c.cd ();
    c.cd (eMain_c);
    c.cd (eGetSharedVarInfo);
    c.cd (eGetSharedVarInfoBody, -(this->UID));

    c << "case " << -(this->UID) << ":\n";
    c << "  return ((_c2_nv" << t->UID << " *) LocalData()->data ())->_c2_" << VarName << "_SharedVarInfo;\n\n";


    // Initialize the extra stuff in MakeObj

    c.cd ();
    c.cd (eMain_c);
    c.cd (eMakeObj);
    c.cd (eMOEntry, t->UID);
    c.cd (eMOEntryInit);

    c << "((_c2_nv" << t->UID << " *) Data->data())->_c2_" << VarName << "_SharedVarInfo.GetAddress() = (void **) &" << "((_c2_nv" << t->UID << " *) Data->data())->" << VarName << ";\n";
    c << "((_c2_nv" << t->UID << " *) Data->data())->_c2_" << VarName << "_SharedVarInfo.SetUID (" << -(this->UID) << ");\n";

    if (AddDbgrCode) {
      c << "((_c2_nv" << t->UID << " *) Data->data())->_c2_" << VarName
	<< "_splist = (_c2_SpList) _c2_allocSpList();\n\n";
    }

    // Unlock shared var after init is done

    c.cd ();
    c.cd (eGraph_c, t->Parent->UID);
    c.cd (eNSScope, t->UID);
    c.cd (eNSIProc);
    c.cd (eNSIProcRelLock);

    c << "_c2_l->_c2_" << VarName << "_SharedVarInfo.initialize ();\n";

    // Add message handler-related routines.

    c.cd ();
    c.cd (eMain_h);
    c.cd (eSharVarUIDFuncSig);

    c << "int _c2_" << t->UID << "_" << VarName << "_SharVarUID();\n";

    c.cd ();
    c.cd (eMain_c);
    c.cd (eSharVarUIDFunc);

    c << "int _c2_" << t->UID << "_" << VarName << "_SharVarUID()\n"
      << "{\n return " << -(this->UID) << "; \n}\n\n\n";

#if 0
    c.cd ();
    c.cd (eMain_c);
    c.cd (eMesgHandler);
    c.cd (eMHMesgType3, t->UID);
    c.cd (eMHMesgType3Body, -(this->UID));

    c << "  case " << -(this->UID) << " :\n";
    // c << "  _c2_NewLock = new _c2_Lock;\n";
    
    c << "  _c2_NewLock = &((_c2_nv" << t->UID << " *)(_c2_TmpNSRel->LocalData()->data()))->_c2_" << VarName << "_Lock;\n";

    if (AddDbgrCode) {
      c << "  _c2_NewLock->psplist =\n  &((_c2_nv" << t->UID
	<< " *)(_c2_TmpNSRel->LocalData()->data()))->_c2_" << VarName << "_splist;\n";
    }
    c << "  break;\n";

    c.cd ();
    c.cd (eMain_c);
    c.cd (eMesgHandler);
    c.cd (eMHMesgType3Mesg4, t->UID);
    c.cd (eMHMesgType3Mesg4Body, -(this->UID));

    c << "  case " << -(this->UID) << " :\n";

    switch (SEVariable->Type->IsA ()) {
    case IntSType:
      c << "  _Messenger[id]->pack (((_c2_nv" << t->UID << " *)" << " (_c2_TmpNSRel->LocalData()->data()))->" << VarName << ");\n"
	<< "  break;\n";
      break;
    case RealSType:
      c << "  _Messenger[id]->pack (((_c2_nv" << t->UID << " *)"
	<< " (_c2_TmpNSRel->LocalData()->data()))->" << VarName << ");\n"
	<< "  break;\n";
      break;
    case CharSType:
      c << "  _Messenger[id]->pack (((_c2_nv" << t->UID << " *)"
	<< " (_c2_TmpNSRel->LocalData()->data()))->" << VarName << ");\n"
	<< "  break;\n";
      break;
    case ArraySType:
    case StructSType:
      c << " _c2_copy_" << UnifiedGetName (TypeName, t) << "(((_c2_nv"
	<< t->UID << " *) (_c2_TmpNSRel->LocalData()->data()))->" << VarName
	<< ", (" << UnifiedGetName (TypeName, t) << ") 0, TRANSMIT, messenger, sm);\n"
	<< "  break;\n";
      break;
    default:
      break;
    }

    c.cd ();
    c.cd (eMain_c);
    c.cd (eMesgHandler);
    c.cd (eMHMesgType4, t->UID);
    c.cd (eMHMesgType4Body, -(this->UID));

    switch (SEVariable->Type->IsA ()) {
    case ArraySType:
    case StructSType:
      c << "  case " << -(this->UID) << " :\n"
	<< "*((" << UnifiedGetName (TypeName, t) << " *) _c2_GotLock->LocalAddr())"
	<< " = _c2_copy_" << UnifiedGetName (TypeName, t)
	<< "((" << UnifiedGetName (TypeName, t) << ") 0, (" << UnifiedGetName (TypeName, t) << ") 0, RECEIVE, messenger, sm);\n"
	<< "  break;\n";
      break;
    case IntSType:
    case RealSType:
    case CharSType:
      break;
    default:
      break;
    }

    c.cd ();
    c.cd (eMain_c);
    c.cd (eMesgHandler);
    c.cd (eMHMesgType5, t->UID);
    c.cd (eMHMesgType5Body1, -(this->UID));

    c << "  case " << -(this->UID) << " :\n";
    // c << "  _c2_NewLock = new _c2_Lock;\n";
    c << "  _c2_NewLock = &((_c2_nv" << t->UID << " *)(_c2_TmpNSRel->LocalData()->data()))->_c2_" << VarName << "_Lock;\n";

    if (AddDbgrCode) {
      c << "  _c2_NewLock->psplist =\n  &((_c2_nv" << t->UID
	<< " *)(_c2_TmpNSRel->LocalData()->data()))->_c2_" << VarName << "_splist;\n";
    }
    c << "  _c2_NewLock->SharedAddr() =\n &((_c2_nv" << t->UID
      << " *)(_c2_TmpNSRel->LocalData()->data()))->" << VarName << ";\n"
      << "  break;\n";

    c.cd ();
    c.cd (eMain_c);
    c.cd (eMesgHandler);
    c.cd (eMHMesgType52, t->UID);
    c.cd (eMHMesgType5Body2, -(this->UID));


    switch (SEVariable->Type->IsA ()) {
    case ArraySType:
    case StructSType:
      c << "  case " << -(this->UID) << " :\n";

      c << "*((" << UnifiedGetName (TypeName, t) << " *) _c2_NewLock->SharedAddr())"
	<< " = _c2_copy_" << UnifiedGetName (TypeName, t)
	<< "((" << UnifiedGetName (TypeName, t) << ") 0, (" << UnifiedGetName (TypeName, t) << ") 0, RECEIVE, messenger, sm);\n"
	<< "  break;\n";
      break;
    case IntSType:
    case RealSType:
    case CharSType:
      break;
    default:
      break;
    }
#endif

    c.cd ();
    c.cd (eMain_c);
    c.cd (eCopyNSRel);
    c.cd (eCopyNSRelBody, t->UID);
    c.cd (eCopyNSRelAssign, -(this->UID));

    c << "  case " << -(this->UID) << " :\n";

    c << "switch (direction & LOCAL) {\n"
      << "  case TRANSMIT:\n";

    switch (SEVariable->Type->IsA ()) {
    case ArraySType:
    case StructSType:
      c << "    _c2_copy_" << UnifiedGetName (TypeName, t)
	<< "(*((" << UnifiedGetName (TypeName, t) << "*) LocalAddr), ("
	<< UnifiedGetName (TypeName, t) << ") 0, TRANSMIT, messenger, sm);\n"
	<< "    break;\n"
	<< "  case RECEIVE:\n"
	<< "    *LocalAddr = _c2_copy_" << UnifiedGetName (TypeName, t) << "((" << UnifiedGetName (TypeName, t) << ") 0, " << "(" << UnifiedGetName (TypeName, t) << ") 0, RECEIVE, messenger, sm);\n"
	<< "    break;\n";
      break;
    case IntSType:
      c << "    messenger << *((int *) LocalAddr);\n"
	<< "    break;\n"
	<< "  case RECEIVE:\n"
	<< "    messenger >> *((int *) LocalAddr);\n"
	<< "    break;\n";
      break;
    case RealSType:
      c << "    messenger << *((double *) LocalAddr);\n"
	<< "    break;\n"
	<< "  case RECEIVE:\n"
	<< "    messenger >> *((double *) LocalAddr);\n"
	<< "    break;\n";
      break;
    case CharSType:
      c << "    messenger << *((char*) LocalAddr);\n"
	<< "    break;\n"
	<< "  case RECEIVE:\n"
	<< "    messenger >> *((char *) LocalAddr);\n"
	<< "    break;\n";
      break;
    default:
      break;
    }

    c << "  default:\n"
      << "    cerr << \"An error has occurred!\" << endl;\n"
      << "    break;\n"
      << "}\n";

    c << "  break;\n";

  }

  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrVarSym(\"" << VarName << "\", " << UID
      << ", \"" << TypeName << "\", "
      << t->UID << ");\n";
    //for obtaining symbol addresses at runtime
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymAddr);
    c.cd (eSAEntry, t->UID);
    c.cd (eSAEntrySW);
    c << "     case " << UID << ":\n"
      << "       return (void *) &((_c2_nv" << t->UID << " *) Data->data())->"
      << VarName << ";\n"
      << "       break;\n\n";
  }
  cSETypeName *SETypeName = (cSETypeName *)
    GetSymbol (TypeName, this,::SETypeName, 0);

  //Must allocate storage for things with size specs

  if (SEVariable->Shared) {
    c.cd ();
    c.cd (eGraph_c, t->Parent->UID);
    c.cd (eNSScope, t->UID);
    c.cd (eNSIProc);
    c.cd (eNSIProcInit);
  } else {
    c.cd ();
    c.cd (eGraph_c, t->Parent->UID);
    c.cd (eUCScope, t->UID);
    c.cd (eUCIProc);
    c.cd (eUCIProcInit);
  }


  if (Sizes != 0) {
    Sizes->Unified ();

    UnifiedSizeSpec (Sizes, TypeName);

    c << UnifiedGetName (VarName, t) << " = _c2_new"
      << -(Sizes->UID) << "(_c2_g, _c2_l, _c2_MyAddr);\n";
  }

  if (1 /* !SEVariable->Shared */ ) {
    //Create the entry in the _c2_CopyUC routine.

    c.cd ();
    c.cd (eMain_c);
    c.cd (eCopyUC);
    c.cd (eCopyUCHead);
    c.cd (eCopyUCCase, t->UID);
    c.cd (eCopyUCCaseHead);
    c.cd (eCopyUCCase1Head);
    c.cd (eCopyUCCase1);

    //We create two versions:(1) = to is remote, (2) from is remote.

    // TRANSMIT case

#if 0
    c << "/* " << t->UID;
    if (SEVariable->Shared) {
      c << " (shared reader) ";
    }
    c << "*/\n";
#endif

    if (SEVariable->Shared) {
      c << "if (flag == TRANSMIT)\n";
    }
    switch (SEVariable->Type->IsA ()) {
    case ArraySType:
    case StructSType:
      c << "      _c2_copy_" << UnifiedGetName (TypeName, t) << "(((_c2_nv" << t->UID << " *) _c2_l)->" << VarName << ", (" << UnifiedGetName (TypeName, t) << ") 0, TRANSMIT, m);\n";
      break;
    case IntSType: 
    case RealSType:
    case CharSType:
      c << "      m << ((_c2_nv" << t->UID << " *) _c2_l)->" << VarName << ";\n";
    default:
      break;
    }

    c.up ();
    c.up ();
    c.cd (eCopyUCCase2Head);
    c.cd (eCopyUCCase2);

    //RECEIVE case

    c << "/* " << t->UID;
    if (SEVariable->Shared) {
      c << "(shared reader) ";
    }
    c << "*/\n";

    if (SEVariable->Shared) {
      c << "if (flag == RECEIVE)\n";
    }
    switch (SEVariable->Type->IsA ()) {
    case ArraySType:
    case StructSType:
      c << "      ((_c2_nv" << t->UID << " *) _c2_l)->" << VarName << " = _c2_copy_" << UnifiedGetName (TypeName, t) << "((" << UnifiedGetName (TypeName, t) << ") 0, (" << UnifiedGetName (TypeName, t) << ") 0,  RECEIVE, m);\n";
      break;
    case IntSType:
    case RealSType:
    case CharSType:
      c << "      m >> ((_c2_nv" << t->UID << " *) _c2_l)->" << VarName << ";\n";
      break;
    default:
      break;
    }
  }

}


void cNSRel::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;

  UnifiedDoFuncDefs (FuncDefs, this);
  UnifiedNSProc (this);

  ADD_NAME_TABLE_ENTRY;

#if 0
  //Message handler entries.
  c.cd ();
  c.cd (eMain_c);
  c.cd (eMesgHandler);
  c.cd (eMHMesgType3, this->UID);

  c << "case " << this->UID << " :\n"
    << " switch (UID) \n"
    << " {\n";

  c.cd ();
  c.cd (eMain_c);
  c.cd (eMesgHandler);
  c.cd (eMHMesgType3Mesg4, this->UID);

  c << "case " << this->UID << " :\n"
    << " switch (UID) \n"
    << " {\n";

  c.cd ();
  c.cd (eMain_c);
  c.cd (eMesgHandler);
  c.cd (eMHMesgType4, this->UID);

  c << "case " << this->UID << " :\n"
    << " switch (_c2_GotLock->GetUID()) \n"
    << " {\n";

  c.cd ();
  c.cd (eMain_c);
  c.cd (eMesgHandler);
  c.cd (eMHMesgType5, this->UID);

  c << "case " << this->UID << " :\n"
    << " switch (UID) \n"
    << " {\n";

  c.cd ();
  c.cd (eMain_c);
  c.cd (eMesgHandler);
  c.cd (eMHMesgType52, this->UID);

  c << "case " << this->UID << " :\n"
    << " switch (UID) \n"
    << " {\n";
#endif

  c.cd ();
  c.cd (eMain_c);
  c.cd (eCopyNSRel);
  c.cd (eCopyNSRelBody, this->UID);

  c << "case " << this->UID << " :\n"
    << " switch (UID) \n"
    << " {\n";

  //Do MakeObj entry
  c.cd ();
  c.cd (eMain_c);
  c.cd (eMakeObj);
  c.cd (eMOEntry, this->UID);
  c.cd (eMOEntryHead);
  c << "case " << this->UID << ":\n"
    << "if (TheMachine) {\n"
    << "  Data = (CodeDataBase *) new (TheMachine) CodeData<_c2_nv" << this->UID << ">(TheMachine);\n"
    << "} else {\n"
    << "  Data = (CodeDataBase *) new CodeData<_c2_nv" << this->UID << ">();\n"
    << "}\n";

  c.up ();
  c.cd (eMOEntryNSFini);
  c << "if (TheMachine) {\n"
    << "  tmpR = new (TheMachine) NameSharingRelation (UID, index, graph, Data, " << "_c2_ip" << this->UID << ", TheMachine);\n"
    << "} else {\n"
    << "  tmpR = new NameSharingRelation (UID, index, graph, Data, " << "_c2_ip" << this->UID << ", NULL);\n"
    << "}\n";
  
  c.up ();
  c.cd (eMOEntryTail);
  c << "*ObjType = _c2_NSRELNODE;\n"
    << "return (void *) tmpR;\n";

  for (p = i.Init (FuncSigs); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrNSRelSym(\"" << Name << "\", " << UID
      << ", " << Parent->UID << ");\n";
    //symbol addresses of vars declared here
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymAddr);
    c.cd (eSAEntry, UID);
    c.cd (eSAEntryCase);
    c << " case " << UID << ":\n"
      << "  switch(UID) {\n";
    c.up ();
    c.cd (eSAEntryTail);
    c << "  }\n   break;\n";
  }
  //local and shared vars get put into the same struct {
  c.cd ();
  c.cd (eMain_h);
  c.cd (eNodeVar, UID);
  c << "class _c2_nv" << UID << " {     /* NSRel = "
    << Name << " */\n";
  c << "public:\n";
  c << "inline void * operator new (size_t sz, ParHeap * heap) {\n"
    << "  return heap->alloc (sz);\n"
    << "}\n"
    << "inline void * operator new (size_t sz) {\n"
    << "  return (void *) ::new char[sz];\n"
    << "}\n"
    << "inline void operator delete (void *) {} // FIX ME!!\n\n";

  for (p = i.Init (SharedVars); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
  for (p = i.Init (LocalVars); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
  c << "};\n\n";

#if 0
  c.cd();
  c.cd(eMain_c);
  c.cd(eMesgHandler);
  c.cd(eMHMesgType3, this->UID);
  c.cd(eMHMesgType3BodyTail, this->UID);

  c << " default : _c2_KillComp(_c2_NOSUCHNSREL);\n"
    << " }\n"
    << " break;\n";

  c.cd();
  c.cd(eMain_c);
  c.cd(eMesgHandler);
  c.cd(eMHMesgType3Mesg4, this->UID);
  c.cd(eMHMesgType3Mesg4Tail, this->UID);

  c << " default : _c2_KillComp(_c2_NOSUCHNSREL);\n"
    << " }\n"
    << " break;\n";

  c.cd();
  c.cd(eMain_c);
  c.cd(eMesgHandler);
  c.cd(eMHMesgType4, this->UID);
  c.cd(eMHMesgType4Tail, this->UID);

  c << " default : _c2_KillComp(_c2_NOSUCHNSREL);\n"
    << " }\n"
    << " break;\n";

  c.cd();
  c.cd(eMain_c);
  c.cd(eMesgHandler);
  c.cd(eMHMesgType5, this->UID);
  c.cd(eMHMesgType5Body1Tail, this->UID);

  c << " default : _c2_KillComp(_c2_NOSUCHNSREL);\n"
    << " }\n"
    << " break;\n";

  c.cd();
  c.cd(eMain_c);
  c.cd(eMesgHandler);
  c.cd(eMHMesgType52, this->UID);
  c.cd(eMHMesgType5Body2Tail, this->UID);

  c << " default : _c2_KillComp(_c2_NOSUCHNSREL);\n"
    << " }\n"
    << " break;\n";
#endif

  c.cd();
  c.cd();
  c.cd(eMain_c);
  c.cd(eCopyNSRel);
  c.cd(eCopyNSRelBody, this->UID);
  c.cd(eCopyNSRelBodyTail, this->UID);

  c << " default : _c2_KillComp(_c2_NOSUCHNSREL);\n"
    << " }\n"
    << " break;\n";

}


void cReplSpec::Unified ()
{
  cCursor c;
  cGraph *g;
  cRule *r;
  cUC *u;
  cAbsTree *tmp;
  int FiringRule;

#define DECLARE_LOOPVAR c << "int " << IndVar << ";\n";
#define LOOP c << "for (" << IndVar << "=0; " << IndVar << "<" << Bound->Translate() << "; " << IndVar << "++) {\n";

#define CREATE_LOOP(A,B,C,D) \
  c.cd((A), r->UID); \
  c.cd((B), tmp->UID); \
  DECLARE_LOOPVAR; \
  c.cd((C)); \
  LOOP; \
  c.up(); \
  c.cd((D)); \
  c << "}\n";

  //same as above but without tmp line.
#define CREATE_LOOP1(A,C,D) \
  c.cd((A), r->UID); \
  DECLARE_LOOPVAR; \
  c.cd((C)); \
  LOOP; \
  c.up(); \
  c.cd((D)); \
  c << "}\n";

  // Yes, this is horrid.

  tmp = GetContaining (this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
  r = (cRule *) GetContaining (tmp, Rule, 0);
  FiringRule = r->FiringRule;
  u = (cUC *) GetContaining (r, UC, 0);
  g = (cGraph *) GetContaining (u, Graph, 0);

  c.cd (eGraph_c, g->UID);
  c.cd (eUCScope, u->UID);
  c.cd (eUCProc);

  if (FiringRule)
    switch (tmp->IsA ()) {
    case Rule:
      CREATE_LOOP1 (eUCProcFrule, eUCProcFRHead, eUCProcFRTail);
      break;
    case Guard:
      CREATE_LOOP (eUCProcFrule, eUCProcFRCheck, eUCProcFRCheckHead, eUCProcFRCheckTail);
      break;
    case Binding:
      CREATE_LOOP (eUCProcFrule, eUCProcFRBind, eUCProcFRBindHead, eUCProcFRBindTail);
      break;
    case ArcInput:
      CREATE_LOOP (eUCProcFrule, eUCProcFRCheck, eUCProcFRCheckHead, eUCProcFRCheckTail);
      //***This also goes into a binding part !
      c.up ();
      c.up ();
      c.cd (eUCProcFRBind, tmp->UID);
      DECLARE_LOOPVAR;
      c.cd (eUCProcFRBindHead);
      LOOP;
      c.up ();
      c.cd (eUCProcFRBindTail);
      c << "}\n";
      break;
    default:
      assert (0); // We should never get here.
      break;
    }
  else
    //routing rule
    switch (tmp->IsA ()) {
    case Rule:
      CREATE_LOOP1 (eUCProcRrule, eUCProcRRHead, eUCProcRRTail);
      break;
    case Guard:
      CREATE_LOOP (eUCProcRrule, eUCProcRRCheck, eUCProcRRCheckHead, eUCProcRRCheckTail);
      break;
    case ArcOutput:
    case Binding:
      CREATE_LOOP (eUCProcRrule, eUCProcRRBind, eUCProcRRBindHead, eUCProcRRBindTail);
      break;
    default:
      assert (0); // We should never get here.
      break;
    }
#undef DECLARE_LOOPVAR
#undef LOOP
#undef CREATE_LOOP
#undef CREATE_LOOP1
}



void cGuard::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;
  cGraph *g;
  cRule *r;
  cUC *u;
  cAbsTree *tmp;
  int FiringRule;


  tmp = GetContaining (this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
  r = (cRule *) GetContaining (tmp, Rule, 0);
  FiringRule = r->FiringRule;
  u = (cUC *) GetContaining (r, UC, 0);
  g = (cGraph *) GetContaining (u, Graph, 0);

  c.cd (eGraph_c, g->UID);
  c.cd (eUCScope, u->UID);
  c.cd (eUCProc);

  if (FiringRule) {
    c.cd (eUCProcFrule, r->UID);
    c.cd (eUCProcFRCheck, this->UID);
    c << "{\n";
    c.cd (eUCProcFRCheckBody);
    c << "if (!(" << Cond->Translate () << ")) goto _c2_endrule" << -(r->UID) << ";\n";
    c.up ();
    c.cd (eUCProcFRCheckTail);
    c << "}\n";
  } else {
    c.cd (eUCProcRrule, r->UID);
    c.cd (eUCProcRRCheck, this->UID);
    c << "{\n";
    c.cd (eUCProcRRCheckBody);
    c << "if (!(" << Cond->Translate () << ")) goto _c2_endrule" << -(r->UID) << ";\n";
    c << "_c2_NullRule = 0;\n";
    c.up ();
    c.cd (eUCProcRRCheckTail);
    c << "}\n";
  }

  for (p = i.Init (Repls); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  UnifiedCreateReplCond (ReplCond, this);

}


void cArcInput::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;
  cGraph *g;
  cRule *r;
  cUC *u;
  cAbsTree *tmp;
  int NumInd;


  tmp = GetContaining (this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
  r = (cRule *) GetContaining (tmp, Rule, 0);
  u = (cUC *) GetContaining (r, UC, 0);
  g = (cGraph *) GetContaining (u, Graph, 0);

  c.cd (eGraph_c, g->UID);
  c.cd (eUCScope, u->UID);
  c.cd (eUCProc);

  //checking part
  c.cd (eUCProcFrule, r->UID);
  c.cd (eUCProcFRCheck, this->UID);
  c << "{\n";
  c.cd (eUCProcFRCheckBody);
  NumInd = UnifiedFillIndVar (c, "_c2_PortIndex", PortExpr, 0);
  c << "_c2_PortIndex.length() = " << NumInd << ";\n";

  if (AddDbgrCode) {
    c << "if (!(_c2_MyAddr->CheckInputPort (_c2_l->" << FindPortName (PortExpr)
      << ", &_c2_PortIndex))) goto _c2_endrule" << -(r->UID) << ";\n"
      << "  _c2_nxtFpBpAct(_c2_MyAddr);\n";
  } else {
    c << "if (!(_c2_MyAddr->CheckInputPort (_c2_l->" << FindPortName (PortExpr)
      << ", &_c2_PortIndex))) goto _c2_endrule" << -(r->UID) << ";\n";
  }
  c << "_c2_NullRule = 0;\n";
  c.up ();
  c.cd (eUCProcFRCheckTail);
  c << "}\n";

  //binding part
  c.up ();
  c.up ();
  c.cd (eUCProcFRBind, this->UID);
  c << "{\n";
  c.cd (eUCProcFRBindBody);
  NumInd = UnifiedFillIndVar (c, "_c2_PortIndex", PortExpr, 0);
  if (AddDbgrCode) {
    c << "_c2_PortIndex.length() = " << NumInd << ";\n"
      << "_c2_Stat = __c2_MyAddr->RemoveFromInputPort (_c2_l->" << FindPortName (PortExpr)
      << " , _c2_PortIndex, _c2_TmpValue);\n"
      << "_c2_dtchFpBpAct(_c2_MyAddr, _c2_TmpValue.fplist, "
      << "_c2_TmpValue.cmd);\n\n";
  } else {
    c << "_c2_PortIndex.length() = " << NumInd << ";\n"
      << "_c2_Stat = _c2_MyAddr->RemoveFromInputPort (_c2_l->" << FindPortName (PortExpr)
      << " , _c2_PortIndex, _c2_TmpValue);\n";
  }
  UnifiedArcAssign (c, VarExpr, PortExpr, this);
  c.up ();
  c.cd (eUCProcFRBindTail);
  c << "}\n";

  for (p = i.Init (Repls); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  UnifiedCreateReplCond (ReplCond, this);
}


void cBinding::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;
  cGraph *g;
  cRule *r;
  cUC *u;
  cAbsTree *tmp;
  int FiringRule;


  tmp = GetContaining (this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
  r = (cRule *) GetContaining (tmp, Rule, 0);
  FiringRule = r->FiringRule;
  u = (cUC *) GetContaining (r, UC, 0);
  g = (cGraph *) GetContaining (u, Graph, 0);

  c.cd (eGraph_c, g->UID);
  c.cd (eUCScope, u->UID);
  c.cd (eUCProc);

#define TRANSLATE_BINDING(A,B,C,D) c.cd((A), r->UID); c.cd((B), this->UID); c << "{\n"; c.cd((C)); c << Bind->Translate(); c.up(); c.cd((D)); c << "}\n"

  if (FiringRule) {
    TRANSLATE_BINDING (eUCProcFrule, eUCProcFRBind, eUCProcFRBindBody, eUCProcFRBindTail);

  } else {
    TRANSLATE_BINDING (eUCProcRrule, eUCProcRRBind, eUCProcRRBindBody, eUCProcRRBindTail);

  }
#undef TRANSLATE_BINDING

  for (p = i.Init (Repls); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  UnifiedCreateReplCond (ReplCond, this);
}


void cArcOutput::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;
  cGraph *g;
  cRule *r;
  cUC *u;
  cSEPortName *ps;
  int NumInd;
  cAbsTree *tmp;

  tmp = GetContaining (this, Rule, Guard, ArcInput, Binding, ArcOutput, 0);
  r = (cRule *) GetContaining (tmp, Rule, 0);
  u = (cUC *) GetContaining (r, UC, 0);
  g = (cGraph *) GetContaining (u, Graph, 0);

  c.cd (eGraph_c, g->UID);
  c.cd (eUCScope, u->UID);
  c.cd (eUCProc);

  c.cd (eUCProcRrule, r->UID);
  c.cd (eUCProcRRBind, this->UID);
  c << "{\n";
  c.cd (eUCProcRRBindBody);

  NumInd = UnifiedFillIndVar (c, "_c2_PortIndex", PortExpr, 0);
  c << "_c2_PortIndex.length() = " << NumInd << ";\n";

  ps = (cSEPortName *) GetSymbol (FindPortName (PortExpr), u, SEPortName, 0);

  c << "_c2_Value _c2_TmpValue;\n";

  switch (ValueExpr->StructuralType->IsA ()) {
  case IntSType:
    c << "_c2_TmpValue.type = _c2_IsAnInt;\n";
    c << "_c2_TmpValue.u.i";
    break;
  case RealSType:
    c << "_c2_TmpValue.type = _c2_IsADouble;\n";
    c << "_c2_TmpValue.u.d";
    break;
  case CharSType:
    c << "_c2_TmpValue.type = _c2_IsAChar;\n";
    c << "_c2_TmpValue.u.c";
    break;
  case ArraySType:
    c << "_c2_TmpValue.type = _c2_IsAnArrayPtr;\n";
    c << "_c2_TmpValue.u.array";
    break;
  case StructSType:
    c << "_c2_TmpValue.type = _c2_IsAStructPtr;\n";
    c << "_c2_TmpValue.u.structure";
    break;
  default:
    Die ("Internal Error: Wrong type in UnifiedTypeOf\n");
    break;
  }

  c << "= " << ValueExpr->Translate () << ";\n";

  c << "Messenger& m = *(_c2_MyAddr->GetMessenger());\n";
  c << ps->GenName << "_remote(_c2_MyAddr, &_c2_PortIndex, &_c2_TmpValue, m);\n";

  if (ValueExpr->IsLHS)
    if (ValueExpr->StructuralType->IsA () ==::ArraySType ||
	ValueExpr->StructuralType->IsA () ==::StructSType)
      c << ValueExpr->Translate () << " = 0;\n";

  c.up ();
  c.cd (eUCProcRRBindTail);
  c << "}\n";

  for (p = i.Init (Repls); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  UnifiedCreateReplCond (ReplCond, this);
}


void cRule::Unified ()
{
  cObIterator i;
  cObject *p;
  cGraph *g;
  cUC *u;
  cCursor c;

  u = (cUC *) GetContaining (this, UC, 0);
  g = (cGraph *) GetContaining (u, Graph, 0);

  c.cd (eGraph_c, g->UID);
  c.cd (eUCScope, u->UID);
  c.cd (eUCProc);

  if (FiringRule) {

    c.cd (eUCProcFrule, UID);
    c << "{  /* Begin rule " << -UID << " */\n";

    if (AddDbgrCode) {
      c << "if (_c2_fruleChkBpAct(_c2_MyAddr, " << -UID << "))\n"
	<< "    goto _c2_endrule" << -UID << ";\n";
    }
    c.cd (eUCProcFRTail);
    c << "goto _c2_comp;\n"
      << "_c2_endrule" << -UID << ":;\n";

  } else {

    c.cd (eUCProcRrule, UID);
    c << "{  /* Begin rule " << -UID << " */\n";

    c.cd (eUCProcRRTail);
    c << "_c2_endrule" << -UID << ":;\n";

  }


  for (p = i.Init (Repls); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  UnifiedCreateReplCond (ReplCond, this);

  for (p = i.Init (Guards); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (Binds); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }


  if (FiringRule) {
    c << "}\n\n";
    //Final "}" for rule (assumes c is still at tail)
    c.up ();
    c.cd (eUCProcFRHead);
    c << "_c2_NullRule = 1;\n";
    //Init for check at least one LHS item true
    c.up ();
    c.cd (eUCProcFRNullCheck);
    c << "if (_c2_NullRule) goto _c2_endrule" << -UID << ";\n";
  } else {

    c << "}\n\n";
    //Final "}" for rule (assumes c is still at tail)
    c.up ();
    c.cd (eUCProcRRHead);
    c << "_c2_NullRule = 1;\n";
    //Init for check at least one LHS item true
    c.up ();
    c.cd (eUCProcRRNullCheck);
    c << "if (_c2_NullRule) goto _c2_endrule" << -UID << ";\n";
  }

}


void cPortSpec::Unified ()
{
  cUC *u;
  cGraph *g;
  cCursor c;

  u = (cUC *) GetContaining (this, UC, 0);

  if (IsInputPort) {
    g = (cGraph *) GetContaining (this, Graph, 0);

    c.cd (eMain_h);
    c.cd (eNodeVar, u->UID);
    c << "  _c2_SeqVarQ " << PortName << ";\n";

    //Put it into the MakeObj entry
    c.cd ();
    c.cd (eMain_c);
    c.cd (eMakeObj);
    c.cd (eMOEntry, u->UID);
    c.cd (eMOEntryInit);
    c << "if (TheMachine) {\n"
      << "((_c2_nv" << u->UID << " *) Data->data())->" << PortName << " = new (TheMachine) Port(TheMachine);\n"
      << "} else {\n"
      << "((_c2_nv" << u->UID << " *) Data->data())->" << PortName << " = new Port(NULL);\n"
      << "}\n";


    //symbol addresses at runtime
    if (AddDbgrCode) {
      c.cd ();
      c.cd (eMain_c);
      c.cd (eDbgSymAddr);
      c.cd (eSAEntry, u->UID);
      c.cd (eSAEntrySW);
      c << "     case " << UID << ":\n"
	<< "       return (void *) ((_c2_nv" << u->UID << " *) Data->data())->"
	<< PortName << ";\n"
	<< "       break;\n\n";
    }
  } else {
    UnifiedPortFunc (this);
    //Create Output port function
  }
  //enter symbol for the debugger
  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrPortSym(\"" << PortName << "\", \""
      << TypeName << "\", " << IsInputPort << ", " << UID
      << ", " << u->UID << ");\n";
  }
}


void cNSPortSpec::Unified ()
{
  cUC *u;
  cGraph *g;
  cCursor c;
  cSESharedVar *SharVar;

  u = (cUC *) GetContaining (this, UC, 0);
  g = (cGraph *) GetContaining (u, Graph, 0);

  //Declare the variable
  c.cd (eMain_h);
  c.cd (eNodeVar, u->UID);
  c << UnifiedGetName (TypeName, u) << " " << PortName << ";\n";

  SharVar = (cSESharedVar *) GetSymbol (PortName, u, SESharedVar, 0);

  // Add transmission and receipt of shared variables to
  // _c2_CopyUC.

  c.cd();
  c.cd(eMain_c);
  c.cd(eCopyUC);
  c.cd(eCopyUCHead);
  c.cd(eCopyUCCase, u->UID);
  c.cd(eCopyUCCaseHead);
  c.cd(eCopyUCCase1Head);
  c.cd(eCopyUCCase1);

  // TRANSMIT case

#if 0
  c << "/* " << u->UID << " (shared writer) */\n";

  c << "printf(\"transmitting a " << UnifiedGetName(SharVar->Type->TypeName, u) << ".\\n\"); fflush(stdout); \n";
#endif

  switch (SharVar->Type->IsA()) {
  case ArraySType:
  case StructSType:
    c << "      _c2_copy_" << UnifiedGetName(SharVar->Type->TypeName, u) << "(((_c2_nv" << u->UID << " *) _c2_l)->" << PortName << ", (" << UnifiedGetName(SharVar->Type->TypeName, u) << ") 0, TRANSMIT, m);\n";
    break;
  case IntSType:
  case RealSType:
  case CharSType:
    c << "      m << ((_c2_nv" << u->UID << " *) _c2_l)->" << PortName << ";\n";
    break;
  default:
    break;
  }

  // RECEIVE case.

  c.up();
  c.up();
  c.cd(eCopyUCCase2Head);
  c.cd(eCopyUCCase2);
     
  c << "/* " << u->UID << " (shared writer) */\n";

  switch (SharVar->Type->IsA()) {
  case ArraySType:
  case StructSType:
    c << "      ((_c2_nv" << u->UID << " *) _c2_l)->" << PortName << " = _c2_copy_" << UnifiedGetName(SharVar->Type->TypeName, u) << "((" << UnifiedGetName(SharVar->Type->TypeName, u) << ") 0, (" << UnifiedGetName(SharVar->Type->TypeName, u) << ") 0,  RECEIVE, m);\n";
    break;
  case IntSType:
  case RealSType:
  case CharSType:
    c << "      m >> ((_c2_nv" << u->UID << " *) _c2_l)->" << PortName << ";\n";
    break;
  default:
    break;
  }


  // Add set of Shared flag to initial procedure of UC.
  c.cd();
  c.cd(eGraph_c, g->UID);
  c.cd(eUCScope, u->UID);
  c.cd(eUCIProc);
  c.cd(eUCIProcComp);
  c << "// _c2_MyAddr->Shared = 1;\n";
  // FIX ME!!!!


  //Call shared var func to add to UC 's lock list

  c.cd ();
  c.cd (eGraph_c, g->UID);
  c.cd (eUCScope, u->UID);
  c.cd (eUCProc);
  c.cd (eUCProcSharedVarAdd);
  c << SharVar->GenName << "(_c2_MyAddr, &_c2_PortIndex);\n";

  //Create shared var func
  UnifiedSharVarFunc (this, SharVar);
}


void cUC::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;


  //These must be done before Unified calls to children
  UnifiedDoFuncDefs (FuncDefs, this);
  //Node scope funcs
  UnifiedUCMakeObj (this);
  //MakeObj entry in c2_main.c
  UnifiedUCProc (this);
  //Skel of UC 's proc in graph.c

  for (p = i.Init (FuncSigs); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrUCSym(\"" << Name << "\", " << UID
      << ", " << Parent->UID << ");\n";
    //symbol addresses of vars declared here
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymAddr);
    c.cd (eSAEntry, UID);
    c.cd (eSAEntryCase);
    c << " case " << UID << ":\n"
      << "  switch(UID) {\n";
    c.up ();
    c.cd (eSAEntryTail);
    c << "  }\n   break;\n";
  }
  ADD_NAME_TABLE_ENTRY;

  //input ports and local vars get translated to the same place.
  {
    c.cd ();
    c.cd (eMain_h);
    c.cd (eNodeVar, UID);

    c << "class _c2_nv" << UID << " {     /* UC = "
      << Name << " */\n";
    c << "public:\n";
    c << "inline void * operator new (size_t sz, ParHeap * heap) {\n"
      << "  return heap->alloc (sz);\n"
      << "}\n"
      << "inline void * operator new (size_t sz) {\n"
      << "  return (void *) ::new char[sz];\n"
      << "}\n"
      << "inline void operator delete (void *) {} // FIX ME!!\n\n";

    for (p = i.Init (InputPorts); i.MoreLeft (); p = i.Next ()) {
      ((cAbsTree *) p)->Unified ();
    }

    for (p = i.Init (OutputPorts); i.MoreLeft (); p = i.Next ()) {
      ((cAbsTree *) p)->Unified ();
    }

    for (p = i.Init (NSPorts); i.MoreLeft (); p = i.Next ()) {
      ((cAbsTree *) p)->Unified ();
    }

    for (p = i.Init (LocalVars); i.MoreLeft (); p = i.Next ()) {
      ((cAbsTree *) p)->Unified ();
    }
    c << "};\n\n";
  }

  for (p = i.Init (InRules); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (OutRules); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
}


void cIntNode::Unified ()
{
  cCursor c;

  if (!InParam) {
    //Create the function pointer in graph struct for return func
    c.cd ();
    c.cd (eMain_h);
    c.cd (eGraphVar, Parent->UID);
    c << "  void (*_c2_prf" << UID << ")(Graph *_c2_gr, CompNode * source, Index _c2_gi, Index _c2_ni, Index *_c2_pi, CompNode **_c2_RetNode, _c2_SeqVarQ *_c2_RetQVar, _c2_Value *_c2_value, Messenger& _Messenger);\n";
  }
}


void cCrepNode::Unified ()
{
  cCursor c;

  //Create the variable in the graph struct
  c.cd ();
  c.cd (eMain_h);
  c.cd (eGraphVar, Parent->UID);

  c << "  " << UnifiedGetName (Type, Parent) << " " << Name << ";\n"
    << "  int _c2_" << Name << ";\n";

  {    // Create the crep entry in the _c2_CopyGraph routine.

    c.cd();
    c.cd(eMain_c);
    c.cd(eCopyGraph);
    c.cd(eCopyGraphHead);
    c.cd(eCopyGraphCase, Parent->UID);
    c.cd(eCopyGraphCaseHead);
    c.cd(eCopyGraphCase1Head);
    c.cd(eCopyGraphCase1);

    // We create two versions: (1) = to is remote, (2) from is remote.

    cSETypeName *SETypeName;
    SETypeName = (cSETypeName *) GetSymbol(Type, this, ::SETypeName, 0);

    switch (SETypeName->Type->IsA()) {
    case ArraySType:
    case StructSType:
      c << "      _c2_copy_" << UnifiedGetName(Type, Parent) << "(((_c2_gv" << Parent->UID << " *) _c2_l)->" << Name << ", (" << UnifiedGetName(Type, Parent) << ") 0, TRANSMIT, m);\n";
      break;
    case IntSType:
    case RealSType:
    case CharSType:
      c << "      m << ((_c2_gv" << Parent->UID << " *) _c2_l)->" << Name << ";\n";
      break;
    default:
      break;
    }

    c.up();
    c.up();
    c.cd(eCopyGraphCase2Head);
    c.cd(eCopyGraphCase2);

    switch (SETypeName->Type->IsA()) {
    case ArraySType:
    case StructSType:
      c << "      ((_c2_gv" << Parent->UID << " *) _c2_l)->" << Name << " = _c2_copy_" << UnifiedGetName(Type, Parent) << "((" << UnifiedGetName(Type, Parent) << ") 0, (" << UnifiedGetName(Type, Parent) << ") 0,  RECEIVE, m);\n";
      break;
    case IntSType:
    case RealSType:
    case CharSType:
      c << "      m >> ((_c2_gv" << Parent->UID << " *) _c2_l)->" << Name << ";\n";
      break;
    default:
      break;
    }

    c << "      ((_c2_gv" << Parent->UID << " *) _c2_l)->_c2_" << Name << " = 1;\n";

  }

  //enter symbol for the debugger
  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrCrepSym(\"" << Name << "\", \""
      << UnifiedGetName (Type, Parent) << "\", " << UID
      << ", " << Parent->UID << ");\n";
  }

  //Put its flag initialization into the MakeObj entry
  c.cd ();
  c.cd (eMain_c);
  c.cd (eMakeObj);
  c.cd (eMOEntry, Parent->UID);
  c.cd (eMOEntryInit);
  c << "((_c2_gv" << Parent->UID << " *) Data->data())->_c2_" << Name
    << " = 0;\n";

}


void cCallNode::Unified ()
{
  cGraph *g;
  cCursor c;
  cObIterator i;
  cObject *p;
  cSEGraph *GSym;
  cGraph *TheGraph;
  cArc *a;

  g = (cGraph *) Parent;
  GSym = (cSEGraph *) GetSymbol (CalledGraph, g, SEGraph, 0);
  TheGraph = (cGraph *) (GSym->Graph);

  ADD_NAME_TABLE_ENTRY;

  /* Enter a case:
     for this
     call node in graph 's MakeObj entry.
     */

  c.cd ();
  c.cd (eMain_c);
  c.cd (eMakeObj);
  c.cd (eMOEntry, TheGraph->UID);
  c.cd (eMOEntryCase);
  c << "case " << UID << ":\n";


  // Enter the case in Graph::Copy ().

  c.cd ();
  c.cd (eMain_c);
  c.cd (eCopyGraph);
  c.cd (eCopyGraphHead);
  c.cd (eCopyGraphCase, TheGraph->UID);
  c.cd (eCopyGraphCaseHead);
  c << "case " << UID << ":\n";


  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrCallNodeSym(\"" << Name << "\", " << UID
      << ", " << TheGraph->UID << ", " << Parent->UID << ");\n";
  }
  //Enter a case in MakeObj for return func pointer setting
  c.cd ();
  c.cd (eMain_c);
  c.cd (eMakeObj);
  c.cd (eMOEntry, TheGraph->UID);
  c.cd (eMOEntrySWInit, UID);
  c.cd (eMOEntrySWInCase);

  c << "case " << UID << ":\n";

  c.up ();
  c.cd (eMOEntrySWInTail);

  c << "break;\n";

  //Find all outgoing arcs and make routing functions for them.
  for (p = i.Init (g->Arcs); i.MoreLeft (); p = i.Next ()) {
    a = (cArc *) p;
    if (a->FromUID == UID) {
      if (a->ConnectsNSRel)
	UnifiedMakeNSArcRoute (a, TheGraph, this);
      else
	UnifiedMakeArcRoute (a, TheGraph, this);
    }
  }
}


void cGraph::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;

  c.cd (eMakefile);
  c.cd (eObj);
  //Add to objs list in makefile.
  c << Name << ".o ";

  c.up();
  c.cd(eGrapht);
  c << Name << ".o: " << Name << ".C\n";

  c.cd ();
  c.cd (eGraph_c, UID);
  c << "/* " << Name << ".c */\n"
    << "#include \"c2_main.h\"\n\n";

  UnifiedGraphMakeObj (this);
  UnifiedDoFuncDefs (FuncDefs, this);

  for (p = i.Init (FuncSigs); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (Types); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }


  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrGphSym(\"" << Name << "\", " << UID
      << ", " << Parent->UID << ");\n";
  }
  ADD_NAME_TABLE_ENTRY;

  {
    c.cd ();
    c.cd (eMain_h);
    c.cd (eGraphVar, UID);
    c << "class _c2_gv" << UID << " {     /* Graph = "
      << Name << " */\n";
    c << "public:\n";
    c << "inline void * operator new (size_t sz, ParHeap * heap) {\n"
      << "  return heap->alloc (sz);\n"
      << "}\n"
#if 1
      << "inline void * operator new (size_t sz) {\n"
      << "  return (void *) ::new char[sz];\n"
      << "}\n\n"
#endif
      << "inline void operator delete (void *) {} // FIX ME!!\n\n";

    for (p = i.Init (CrepNodes); i.MoreLeft (); p = i.Next ()) {
      ((cAbsTree *) p)->Unified ();
    }

    for (p = i.Init (IntNodes); i.MoreLeft (); p = i.Next ()) {
      ((cAbsTree *) p)->Unified ();
    }

    c << "};\n\n";
  }

  for (p = i.Init (UCNodes); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (CallNodes); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (NSRelNodes); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (Arcs); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }
}


void cProgram::Unified ()
{
  cObIterator i;
  cObject *p;
  cCursor c;

  PassOK = 1;
  //OK at start

  UnifiedMakefile (this);
  UnifiedCreateMain (this);
  UnifiedGetSharedVarInfo ();
  UnifiedCopyNSRel ();
  UnifiedCopyArc ();
  UnifiedCopyUC ();
  UnifiedCopyGraph ();
  UnifiedMakeObj ();

  c.cd ();
  c.cd (eMain_h);
  c << "/* c2_main.h */\n\n"
    << "#ifndef _C2_MAIN_H\n"
    << "#define _C2_MAIN_H\n\n"
    << "#include <stdio.h>\n"
    << "#include <unistd.h>\n\n"
    << "#include <c2_misc.h>\n"
    << "#include <c2_workers.h>\n"
    << "#include \"c2_globtype.h\"\n\n";


  c.cd ();
  c.cd (eMain_c);
  c << "/* c2_main.c */\n"
    << "#include \"c2_main.h\"\n\n";

  //Create the start and end of the NameTable declaration.

  c.cd (eNameTableInit);
  c << "_c2_NameTable NameTable[] = {";

  c.up ();
  c.cd (eNameTableEnd);
  c << "  {-1, \"\"}};\n\n";


  //Create the start and end of the PortFunction table.

  c.up ();

  c.cd (ePortFunctionsInit);
  c << "typedef void (*PortFunction) (CompNode *, Index *, _c2_Value *, Messenger&);\n\n";
  c << "PortFunction PortFunctionsTable[] = {";

  c.up ();
  c.cd (ePortFunctionsEnd);
  c << "  NULL};\n\n";


  //Create the start and end of the ArcRouteFunction table.

  c.up ();

  c.cd (eArcRouteFunctionsInit);
  c << "typedef void (*ArcRouteFunction) (Graph *, CompNode *, Index, Index, Index *, CompNode **, _c2_SeqVarQ *, _c2_Value *, Messenger&);\n\n";
  c << "ArcRouteFunction ArcRouteFunctionsTable[] = {";

  c.up ();
  c.cd (eArcRouteFunctionsEnd);
  c << "  NULL};\n\n";


  c.cd ();
  c.cd (eGlob_h);
  c << "/* c2_globtype.h */\n\n"
    << "#include <code.H>\n\n"
    << "typedef double real;\n\n";

  UnifiedDoFuncDefs (FuncDefs, this);

  if (setjmp (PassEnv)) {
    PassOK = 0;
    return;
  }
  if (AddDbgrCode) {
    c.cd ();
    c.cd (eMain_c);
    c.cd (eDbgSymEntry);
    c.cd (eDbgSEBody);
    c << "  _c2_entrPgmSym(\"" << Name << "\", " << UID << ");\n";
  }
  for (p = i.Init (FuncSigs); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (Types); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  for (p = i.Init (Graphs); i.MoreLeft (); p = i.Next ()) {
    ((cAbsTree *) p)->Unified ();
  }

  //Put newline after objs list in makefile.
  c.cd ();
  c.cd (eMakefile);
  c.cd (eObj);
  c << "\n\n";

  //Put closing "#endif" at end of c2_main.h.

  c.cd ();
  c.cd (eMain_h);
  c.cd (eFreeFuncSig);
  c << "#endif\n";

  (void) UnifiedWriteFiles (this);
}
